/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

public class SalvageProjectPanel
extends WizardPanel {
    private static final String NAME = "Salvage Project";
    private JLabel errorMessageLabel;
    private DefaultListModel projectListModel;
    private JList projectList;
    private PartsTableModel partsTableModel;
    private JTable partsTable;

    SalvageProjectPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new MarsPanelBorder());
        JLabel titleLabel = new JLabel("Select a salvage project", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        this.add((Component)titleLabel, "North");
        JPanel centerPane = new JPanel(new GridLayout(1, 2, 10, 10));
        this.add((Component)centerPane, "Center");
        JPanel projectPane = new JPanel(new BorderLayout(0, 0));
        projectPane.setBorder(new MarsPanelBorder());
        centerPane.add(projectPane);
        JLabel projectLabel = new JLabel("Buildings and Construction Sites", 0);
        projectPane.add((Component)projectLabel, "North");
        JScrollPane projectListScrollPane = new JScrollPane();
        projectListScrollPane.setHorizontalScrollBarPolicy(31);
        projectPane.add((Component)projectListScrollPane, "Center");
        this.projectListModel = new DefaultListModel();
        this.populateProjectListModel();
        this.projectList = new JList(this.projectListModel);
        this.projectList.setSelectionMode(0);
        this.projectList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                SalvageProjectPanel.this.partsTableModel.update();
                Object project = SalvageProjectPanel.this.projectList.getSelectedValue();
                if (project != null) {
                    SalvageProjectPanel.this.getWizard().setButtons(true);
                    SalvageProjectPanel.this.errorMessageLabel.setText(" ");
                } else {
                    SalvageProjectPanel.this.getWizard().setButtons(false);
                    SalvageProjectPanel.this.errorMessageLabel.setText(" ");
                }
            }
        });
        projectListScrollPane.setViewportView(this.projectList);
        JPanel partsPane = new JPanel(new BorderLayout(0, 0));
        partsPane.setBorder(new MarsPanelBorder());
        centerPane.add(partsPane);
        JLabel partsLabel = new JLabel("Estimated Salvaged Parts", 0);
        partsPane.add((Component)partsLabel, "North");
        JScrollPane partsTableScrollPane = new JScrollPane();
        partsTableScrollPane.setHorizontalScrollBarPolicy(31);
        partsPane.add((Component)partsTableScrollPane, "Center");
        this.partsTableModel = new PartsTableModel();
        this.partsTable = new JTable(this.partsTableModel);
        this.partsTable.setRowSelectionAllowed(false);
        partsTableScrollPane.setViewportView(this.partsTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add((Component)this.errorMessageLabel, "South");
    }

    @Override
    void clearInfo() {
        this.projectListModel.clear();
        this.partsTableModel.update();
        this.getWizard().setButtons(false);
        this.errorMessageLabel.setText(" ");
    }

    @Override
    boolean commitChanges() {
        Object project = this.projectList.getSelectedValue();
        if (project != null) {
            if (project instanceof Building) {
                Building salvageBuilding = (Building)project;
                this.getWizard().getMissionData().setSalvageBuilding(salvageBuilding);
                return true;
            }
            if (project instanceof ConstructionSite) {
                ConstructionSite salvageSite = (ConstructionSite)project;
                this.getWizard().getMissionData().setSalvageSite(salvageSite);
                return true;
            }
        }
        return false;
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    void updatePanel() {
        this.populateProjectListModel();
        this.getWizard().setButtons(false);
    }

    private void populateProjectListModel() {
        this.projectListModel.clear();
        Settlement salvageSettlement = this.getWizard().getMissionData().getSalvageSettlement();
        if (salvageSettlement != null) {
            List buildingList = salvageSettlement.getBuildingManager().getBuildings();
            Collections.sort(buildingList);
            Iterator i = buildingList.iterator();
            while (i.hasNext()) {
                this.projectListModel.addElement(i.next());
            }
            Iterator j = salvageSettlement.getConstructionManager().getConstructionSitesNeedingSalvageMission().iterator();
            while (j.hasNext()) {
                this.projectListModel.addElement(j.next());
            }
        }
    }

    private class PartsTableModel
    extends AbstractTableModel {
        private ConstructionStageInfo info = null;
        private Map<Part, Integer> partsNumber = new HashMap<Part, Integer>();

        private PartsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String result = "";
            if (columnIndex == 0) {
                result = "Part";
            } else if (columnIndex == 1) {
                result = "Estimated Salvage";
            }
            return result;
        }

        @Override
        public int getRowCount() {
            return this.partsNumber.keySet().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.partsNumber.keySet().size() && col < 2) {
                Part part = (Part)this.partsNumber.keySet().toArray()[row];
                if (col == 0) {
                    return part.toString();
                }
                if (col == 1) {
                    return this.partsNumber.get(part);
                }
                return null;
            }
            return null;
        }

        private void update() {
            this.info = null;
            Object project = SalvageProjectPanel.this.projectList.getSelectedValue();
            if (project instanceof Building) {
                Building salvageBuilding = (Building)project;
                try {
                    this.info = ConstructionUtil.getConstructionStageInfo((String)salvageBuilding.getName());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            } else if (project instanceof ConstructionSite) {
                ConstructionSite salvageSite = (ConstructionSite)project;
                this.info = salvageSite.getCurrentConstructionStage().getInfo();
            }
            this.partsNumber.clear();
            this.populatePartsNumber();
            this.fireTableStructureChanged();
        }

        private void populatePartsNumber() {
            if (this.info != null) {
                try {
                    double totalSkill = 0.0;
                    Iterator<Person> i = SalvageProjectPanel.this.getWizard().getMissionData().getMembers().iterator();
                    while (i.hasNext()) {
                        int constructionSkill = i.next().getMind().getSkillManager().getSkillLevel("Construction");
                        totalSkill += (double)constructionSkill;
                    }
                    int memberNum = SalvageProjectPanel.this.getWizard().getMissionData().getMembers().size();
                    double averageSkill = totalSkill / (double)memberNum;
                    double salvageChance = 50.0 + averageSkill * 5.0;
                    if (salvageChance > 100.0) {
                        salvageChance = 100.0;
                    }
                    for (Part part : this.info.getParts().keySet()) {
                        int maxSalvage = (Integer)this.info.getParts().get(part);
                        int estimatedSalvage = (int)Math.round((double)maxSalvage * (salvageChance / 100.0));
                        this.partsNumber.put(part, estimatedSalvage);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

