/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

public class SalvageVehiclePanel
extends WizardPanel {
    private static final String NAME = "Salvage Vehicles";
    private VehicleTableModel vehicleTableModel;
    private JTable vehicleTable;
    private JLabel requiredLabel;
    private JLabel selectedLabel;
    private JLabel errorMessageLabel;

    SalvageVehiclePanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectVehicleLabel = new JLabel("Select the light utility vehicles for the mission.", 0);
        selectVehicleLabel.setFont(selectVehicleLabel.getFont().deriveFont(1));
        selectVehicleLabel.setAlignmentX(0.5f);
        this.add(selectVehicleLabel);
        this.requiredLabel = new JLabel("Required vehicles: ");
        this.requiredLabel.setAlignmentX(0.5f);
        this.add(this.requiredLabel);
        this.selectedLabel = new JLabel("Number selected: ");
        this.selectedLabel.setAlignmentX(0.5f);
        this.add(this.selectedLabel);
        JPanel vehiclePane = new JPanel(new BorderLayout(0, 0));
        vehiclePane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        vehiclePane.setAlignmentX(0.5f);
        this.add(vehiclePane);
        JScrollPane vehicleScrollPane = new JScrollPane();
        vehicleScrollPane.setHorizontalScrollBarPolicy(31);
        vehiclePane.add((Component)vehicleScrollPane, "Center");
        this.vehicleTableModel = new VehicleTableModel();
        this.vehicleTable = new JTable(this.vehicleTableModel);
        this.vehicleTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.vehicleTableModel));
        this.vehicleTable.setRowSelectionAllowed(true);
        this.vehicleTable.setSelectionMode(2);
        this.vehicleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    boolean goodVehicles = false;
                    SalvageVehiclePanel.this.errorMessageLabel.setText(" ");
                    int requiredVehicles = SalvageVehiclePanel.this.getRequiredVehiclesNum();
                    int[] indexes = SalvageVehiclePanel.this.vehicleTable.getSelectedRows();
                    SalvageVehiclePanel.this.selectedLabel.setText("Number selected: " + indexes.length);
                    if (indexes.length >= requiredVehicles) {
                        goodVehicles = true;
                        for (int indexe : indexes) {
                            if (!SalvageVehiclePanel.this.vehicleTableModel.isFailureRow(indexe)) continue;
                            SalvageVehiclePanel.this.errorMessageLabel.setText("Light utility vehicle cannot be used on the mission (see red cells).");
                            goodVehicles = false;
                        }
                    }
                    SalvageVehiclePanel.this.getWizard().setButtons(goodVehicles);
                }
            }
        });
        this.vehicleTable.setPreferredScrollableViewportSize(this.vehicleTable.getPreferredSize());
        vehicleScrollPane.setViewportView(this.vehicleTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    void clearInfo() {
        this.vehicleTable.clearSelection();
        this.errorMessageLabel.setText(" ");
        this.requiredLabel.setText("Required vehicles: ");
        this.selectedLabel.setText("Number selected: ");
    }

    @Override
    boolean commitChanges() {
        ArrayList<GroundVehicle> salvageVehicles = new ArrayList<GroundVehicle>();
        int[] selectedIndexs = this.vehicleTable.getSelectedRows();
        for (int x = 0; x < selectedIndexs.length; ++x) {
            LightUtilityVehicle selectedVehicle = (LightUtilityVehicle)this.vehicleTableModel.getUnit(selectedIndexs[x]);
            salvageVehicles.add((GroundVehicle)selectedVehicle);
        }
        this.getWizard().getMissionData().setSalvageVehicles(salvageVehicles);
        return true;
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    void updatePanel() {
        this.vehicleTableModel.updateTable();
        this.vehicleTable.setPreferredScrollableViewportSize(this.vehicleTable.getPreferredSize());
        this.requiredLabel.setText("Required vehicles: " + this.getRequiredVehiclesNum());
        if (this.getRequiredVehiclesNum() == 0) {
            this.getWizard().setButtons(true);
        }
    }

    private int getRequiredVehiclesNum() {
        int result = 0;
        ConstructionStageInfo salvageInfo = null;
        Building salvageBuilding = this.getWizard().getMissionData().getSalvageBuilding();
        if (salvageBuilding != null) {
            try {
                salvageInfo = ConstructionUtil.getConstructionStageInfo((String)salvageBuilding.getName());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            ConstructionSite salvageSite = this.getWizard().getMissionData().getSalvageSite();
            salvageInfo = salvageSite.getCurrentConstructionStage().getInfo();
        }
        if (salvageInfo != null) {
            result = salvageInfo.getVehicles().size();
        }
        return result;
    }

    private class VehicleTableModel
    extends UnitTableModel {
        private VehicleTableModel() {
            this.columns.add("Name");
            this.columns.add("Status");
            this.columns.add("Mission");
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = "unknown";
            if (row < this.units.size()) {
                LightUtilityVehicle vehicle = (LightUtilityVehicle)this.getUnit(row);
                try {
                    if (column == 0) {
                        result = vehicle.getName();
                    } else if (column == 1) {
                        result = vehicle.getStatus();
                    } else if (column == 2) {
                        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle((Vehicle)vehicle);
                        result = mission != null ? mission.getDescription() : "None";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            this.units.clear();
            Settlement settlement = SalvageVehiclePanel.this.getWizard().getMissionData().getSalvageSettlement();
            Collection vehicles = CollectionUtils.sortByName((Collection)settlement.getParkedVehicles());
            for (Vehicle vehicle : vehicles) {
                if (!(vehicle instanceof LightUtilityVehicle)) continue;
                this.units.add(vehicle);
            }
            this.fireTableDataChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            Mission mission;
            boolean result = false;
            LightUtilityVehicle vehicle = (LightUtilityVehicle)this.getUnit(row);
            if (column == 1) {
                if (!vehicle.getStatus().equals("Parked")) {
                    result = true;
                }
            } else if (column == 2 && (mission = Simulation.instance().getMissionManager().getMissionForVehicle((Vehicle)vehicle)) != null) {
                result = true;
            }
            return result;
        }
    }
}

