/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.NumberFormatter;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.Barrel;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.equipment.GasCanister;
import org.mars_sim.msp.core.person.ai.mission.TradeUtil;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Phase;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.MissionDataBean;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class TradeGoodsPanel
extends WizardPanel {
    private boolean buyGoods;
    private JLabel errorMessageLabel;
    private JTable goodsTable;
    private JTable tradeTable;
    private JLabel availableGoodsLabel;
    private GoodsTableModel goodsTableModel;
    private TradeTableModel tradeTableModel;
    private JButton leftArrowButton;
    private JButton rightArrowButton;
    private JFormattedTextField amountTextField;
    private NumberFormatter formatter;

    TradeGoodsPanel(CreateMissionWizard wizard, boolean buyGoods) {
        super(wizard);
        this.buyGoods = buyGoods;
        this.setLayout(new BorderLayout());
        this.setBorder(new MarsPanelBorder());
        String tradeString = "sold";
        if (buyGoods) {
            tradeString = "bought";
        }
        JLabel titleLabel = new JLabel("Choose good amounts to be " + tradeString + ".", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        this.add((Component)titleLabel, "North");
        JPanel availableGoodsPane = new JPanel(new BorderLayout());
        availableGoodsPane.setPreferredSize(new Dimension(260, 100));
        this.add((Component)availableGoodsPane, "West");
        this.availableGoodsLabel = new JLabel("Available goods at ", 0);
        availableGoodsPane.add((Component)this.availableGoodsLabel, "North");
        JScrollPane goodsScrollPane = new JScrollPane();
        availableGoodsPane.add((Component)goodsScrollPane, "Center");
        this.goodsTableModel = new GoodsTableModel();
        this.goodsTable = new JTable(this.goodsTableModel);
        this.goodsTable.setRowSelectionAllowed(true);
        this.goodsTable.setSelectionMode(0);
        this.goodsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() && TradeGoodsPanel.this.goodsTable.getSelectedRow() > -1) {
                    TradeGoodsPanel.this.tradeTable.clearSelection();
                    TradeGoodsPanel.this.errorMessageLabel.setText(" ");
                    TradeGoodsPanel.this.leftArrowButton.setEnabled(false);
                    TradeGoodsPanel.this.amountTextField.setEnabled(true);
                    TradeGoodsPanel.this.rightArrowButton.setEnabled(true);
                }
            }
        });
        goodsScrollPane.setViewportView(this.goodsTable);
        JPanel amountOuterPanel = new JPanel(new FlowLayout(1));
        this.add((Component)amountOuterPanel, "Center");
        JPanel amountControlPane = new JPanel(new BorderLayout());
        amountOuterPanel.add(amountControlPane);
        JLabel amountLabel = new JLabel("Amount", 0);
        amountControlPane.add((Component)amountLabel, "North");
        this.leftArrowButton = new JButton("<");
        this.leftArrowButton.setEnabled(false);
        this.leftArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int amount = (Integer)TradeGoodsPanel.this.formatter.stringToValue(TradeGoodsPanel.this.amountTextField.getText());
                    int selectedGoodIndex = TradeGoodsPanel.this.tradeTable.getSelectedRow();
                    if (selectedGoodIndex > -1) {
                        Good good = (Good)TradeGoodsPanel.this.tradeTableModel.tradeList.get(selectedGoodIndex);
                        int currentAmount = (Integer)TradeGoodsPanel.this.tradeTableModel.tradeMap.get(good);
                        if (amount <= currentAmount) {
                            TradeGoodsPanel.this.tradeTableModel.removeGoodAmount(good, amount);
                            TradeGoodsPanel.this.goodsTableModel.addGoodAmount(good, amount);
                            TradeGoodsPanel.this.errorMessageLabel.setText(" ");
                        } else {
                            TradeGoodsPanel.this.errorMessageLabel.setText("Amount to remove is larger than traded amount.");
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        amountControlPane.add((Component)this.leftArrowButton, "West");
        this.formatter = new NumberFormatter();
        this.formatter.setAllowsInvalid(false);
        this.formatter.setMinimum(Integer.valueOf(0));
        this.formatter.setMaximum(Integer.valueOf(9999));
        this.amountTextField = new JFormattedTextField(this.formatter);
        this.amountTextField.setValue(0);
        this.amountTextField.setColumns(5);
        this.amountTextField.setHorizontalAlignment(4);
        this.amountTextField.setEnabled(false);
        amountControlPane.add((Component)this.amountTextField, "Center");
        this.rightArrowButton = new JButton(">");
        this.rightArrowButton.setEnabled(false);
        this.rightArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int amount = (Integer)TradeGoodsPanel.this.formatter.stringToValue(TradeGoodsPanel.this.amountTextField.getText());
                    int selectedGoodIndex = TradeGoodsPanel.this.goodsTable.getSelectedRow();
                    if (selectedGoodIndex > -1) {
                        Good good = (Good)TradeGoodsPanel.this.goodsTableModel.goodsList.get(selectedGoodIndex);
                        int currentAmount = (Integer)TradeGoodsPanel.this.goodsTableModel.goodsMap.get(good);
                        if (amount <= currentAmount) {
                            if (good.getCategory().equals("vehicle") && (amount > 1 || TradeGoodsPanel.this.tradeTableModel.hasTradedVehicle())) {
                                TradeGoodsPanel.this.errorMessageLabel.setText("Only one vehicle can be traded.");
                            } else {
                                TradeGoodsPanel.this.goodsTableModel.removeGoodAmount(good, amount);
                                TradeGoodsPanel.this.tradeTableModel.addGoodAmount(good, amount);
                                TradeGoodsPanel.this.errorMessageLabel.setText(" ");
                            }
                        } else {
                            TradeGoodsPanel.this.errorMessageLabel.setText("Amount to add is larger than available amount.");
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        amountControlPane.add((Component)this.rightArrowButton, "East");
        JPanel tradedGoodsPane = new JPanel(new BorderLayout());
        tradedGoodsPane.setPreferredSize(new Dimension(260, 100));
        this.add((Component)tradedGoodsPane, "East");
        JLabel tradedGoodsLabel = new JLabel("Selling Goods", 0);
        if (buyGoods) {
            tradedGoodsLabel.setText("Buying Goods");
        }
        tradedGoodsPane.add((Component)tradedGoodsLabel, "North");
        JScrollPane tradeScrollPane = new JScrollPane();
        tradedGoodsPane.add((Component)tradeScrollPane, "Center");
        this.tradeTableModel = new TradeTableModel();
        this.tradeTable = new JTable(this.tradeTableModel);
        this.tradeTable.setRowSelectionAllowed(true);
        this.tradeTable.setSelectionMode(0);
        this.tradeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() && TradeGoodsPanel.this.tradeTable.getSelectedRow() > -1) {
                    TradeGoodsPanel.this.goodsTable.clearSelection();
                    TradeGoodsPanel.this.errorMessageLabel.setText(" ");
                    TradeGoodsPanel.this.leftArrowButton.setEnabled(true);
                    TradeGoodsPanel.this.amountTextField.setEnabled(true);
                    TradeGoodsPanel.this.rightArrowButton.setEnabled(false);
                }
            }
        });
        tradeScrollPane.setViewportView(this.tradeTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.add((Component)this.errorMessageLabel, "South");
    }

    @Override
    void clearInfo() {
        this.goodsTable.clearSelection();
        this.tradeTable.clearSelection();
        this.leftArrowButton.setEnabled(false);
        this.rightArrowButton.setEnabled(false);
        this.amountTextField.setEnabled(false);
    }

    @Override
    boolean commitChanges() {
        boolean result = false;
        try {
            if (this.hasEnoughContainers()) {
                MissionDataBean missionData = this.getWizard().getMissionData();
                if (this.buyGoods) {
                    missionData.setBuyGoods(this.tradeTableModel.getTradeGoods());
                } else {
                    missionData.setSellGoods(this.tradeTableModel.getTradeGoods());
                }
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return result;
    }

    private boolean hasEnoughContainers() {
        boolean result = true;
        HashMap<Class, Integer> containerMap = new HashMap<Class, Integer>(3);
        containerMap.put(Bag.class, this.getNumberOfTradedContainers(Bag.class));
        containerMap.put(Barrel.class, this.getNumberOfTradedContainers(Barrel.class));
        containerMap.put(GasCanister.class, this.getNumberOfTradedContainers(GasCanister.class));
        Map<Good, Integer> tradeGoods = this.tradeTableModel.getTradeGoods();
        for (Good good : tradeGoods.keySet()) {
            if (!good.getCategory().equals("amount resource")) continue;
            AmountResource resource = (AmountResource)good.getObject();
            Phase phase = resource.getPhase();
            Class containerType = this.getContainerTypeNeeded(phase);
            int containerNum = (Integer)containerMap.get(containerType);
            Equipment container = EquipmentFactory.getEquipment((Class)containerType, (Coordinates)new Coordinates(0.0, 0.0), (boolean)true);
            double capacity = container.getInventory().getAmountResourceCapacity(resource, false);
            double totalCapacity = (double)containerNum * capacity;
            double resourceAmount = tradeGoods.get(good).intValue();
            if (resourceAmount > totalCapacity) {
                double neededCapacity = resourceAmount - totalCapacity;
                int neededContainerNum = (int)Math.ceil(neededCapacity / capacity);
                String containerName = container.getName().toLowerCase();
                if (neededContainerNum > 1) {
                    containerName = containerName + "s";
                }
                this.errorMessageLabel.setText(neededContainerNum + " " + containerName + " needed to hold " + resource.getName());
                result = false;
                break;
            }
            int neededContainerNum = (int)Math.ceil(resourceAmount / capacity);
            int remainingContainerNum = containerNum - neededContainerNum;
            containerMap.put(containerType, remainingContainerNum);
        }
        return result;
    }

    private int getNumberOfTradedContainers(Class containerType) {
        int result = 0;
        Good containerGood = GoodsUtil.getEquipmentGood((Class)containerType);
        Map<Good, Integer> tradeGoods = this.tradeTableModel.getTradeGoods();
        if (tradeGoods.containsKey(containerGood)) {
            result = tradeGoods.get(containerGood);
        }
        return result;
    }

    private Class getContainerTypeNeeded(Phase phase) {
        Class<Bag> result = null;
        if (phase.equals((Object)Phase.SOLID)) {
            result = Bag.class;
        }
        if (phase.equals((Object)Phase.LIQUID)) {
            result = Barrel.class;
        }
        if (phase.equals((Object)Phase.GAS)) {
            result = GasCanister.class;
        }
        return result;
    }

    @Override
    String getPanelName() {
        if (this.buyGoods) {
            return "Buying Goods";
        }
        return "Selling Goods";
    }

    @Override
    void updatePanel() {
        MissionDataBean missionData = this.getWizard().getMissionData();
        String settlementName = "";
        settlementName = this.buyGoods ? missionData.getDestinationSettlement().getName() : missionData.getStartingSettlement().getName();
        this.availableGoodsLabel.setText("Available goods at " + settlementName);
        this.goodsTableModel.updateTable();
        this.tradeTableModel.updateTable();
        this.getWizard().setButtons(true);
    }

    private class TradeTableModel
    extends AbstractTableModel {
        private Map<Good, Integer> tradeMap;
        private List<Good> tradeList = new ArrayList<Good>();

        private TradeTableModel() {
            this.tradeMap = new HashMap<Good, Integer>();
        }

        @Override
        public int getRowCount() {
            return this.tradeList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Good";
            }
            return "Amount";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.tradeList.size()) {
                Good good = this.tradeList.get(row);
                result = column == 0 ? good.getName() : this.tradeMap.get(good);
            }
            return result;
        }

        void updateTable() {
            this.tradeList.clear();
            this.tradeMap.clear();
            this.fireTableDataChanged();
        }

        void addGoodAmount(Good good, int amount) {
            if (amount > 0) {
                if (this.tradeList.contains(good)) {
                    amount += this.tradeMap.get(good).intValue();
                } else {
                    this.tradeList.add(good);
                }
                this.tradeMap.put(good, amount);
                this.fireTableDataChanged();
            }
        }

        void removeGoodAmount(Good good, int amount) {
            if (amount > 0) {
                int finalAmount;
                int currentAmount = 0;
                if (this.tradeList.contains(good)) {
                    currentAmount = this.tradeMap.get(good);
                }
                if ((finalAmount = currentAmount - amount) > 0) {
                    int selectedGoodIndex = TradeGoodsPanel.this.tradeTable.getSelectedRow();
                    this.tradeMap.put(good, finalAmount);
                    this.fireTableDataChanged();
                    if (selectedGoodIndex > -1) {
                        TradeGoodsPanel.this.tradeTable.setRowSelectionInterval(selectedGoodIndex, selectedGoodIndex);
                    }
                } else {
                    this.tradeList.remove(good);
                    this.tradeMap.remove(good);
                    this.fireTableDataChanged();
                }
            }
        }

        Map<Good, Integer> getTradeGoods() {
            return new HashMap<Good, Integer>(this.tradeMap);
        }

        private boolean hasTradedVehicle() {
            boolean result = false;
            Iterator<Good> i = this.tradeList.iterator();
            while (i.hasNext()) {
                if (!i.next().getCategory().equals("vehicle")) continue;
                result = true;
            }
            return result;
        }
    }

    private class GoodsTableModel
    extends AbstractTableModel {
        private Map<Good, Integer> goodsMap;
        private List<Good> goodsList = GoodsUtil.getGoodsList();

        private GoodsTableModel() {
            this.goodsMap = new HashMap<Good, Integer>(this.goodsList.size());
            Iterator<Good> i = this.goodsList.iterator();
            while (i.hasNext()) {
                this.goodsMap.put(i.next(), 0);
            }
        }

        @Override
        public int getRowCount() {
            return this.goodsList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Good";
            }
            return "Amount";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.goodsList.size()) {
                Good good = this.goodsList.get(row);
                result = column == 0 ? good.getName() : this.goodsMap.get(good);
            }
            return result;
        }

        void updateTable() {
            MissionDataBean missionData = TradeGoodsPanel.this.getWizard().getMissionData();
            Settlement settlement = null;
            settlement = TradeGoodsPanel.this.buyGoods ? missionData.getDestinationSettlement() : missionData.getStartingSettlement();
            for (Good good : this.goodsList) {
                try {
                    int amount = (int)TradeUtil.getNumInInventory((Good)good, (Inventory)settlement.getInventory());
                    if (this.checkForVehicle(good)) {
                        --amount;
                    }
                    this.goodsMap.put(good, amount);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            this.fireTableDataChanged();
        }

        private boolean checkForVehicle(Good good) {
            boolean result = false;
            if (!TradeGoodsPanel.this.buyGoods && good.getCategory().equals("vehicle")) {
                String missionRoverName = TradeGoodsPanel.this.getWizard().getMissionData().getRover().getDescription();
                if (good.getName().equalsIgnoreCase(missionRoverName)) {
                    result = true;
                }
            }
            return result;
        }

        void addGoodAmount(Good good, int amount) {
            if (amount > 0) {
                this.goodsMap.put(good, amount += this.goodsMap.get(good).intValue());
                this.fireTableDataChanged();
            }
        }

        void removeGoodAmount(Good good, int amount) {
            if (amount > 0) {
                int finalAmount = this.goodsMap.get(good) - amount;
                this.goodsMap.put(good, finalAmount);
                int selectedGoodIndex = TradeGoodsPanel.this.goodsTable.getSelectedRow();
                this.fireTableDataChanged();
                if (selectedGoodIndex > -1) {
                    TradeGoodsPanel.this.goodsTable.setRowSelectionInterval(selectedGoodIndex, selectedGoodIndex);
                }
            }
        }
    }
}

