/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.CollectResourcesMission;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.TravelMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.edit.InfoPanel;

public class EditMissionDialog
extends JDialog {
    private Mission mission;
    private InfoPanel infoPane;

    public EditMissionDialog(Frame owner, Mission mission) {
        super(owner, "Edit Mission", true);
        this.mission = mission;
        this.setLayout(new BorderLayout(0, 0));
        ((JComponent)this.getContentPane()).setBorder(new MarsPanelBorder());
        this.infoPane = new InfoPanel(mission, this);
        this.add((Component)this.infoPane, "Center");
        JPanel buttonPane = new JPanel(new FlowLayout(2, 10, 5));
        this.add((Component)buttonPane, "South");
        JButton modifyButton = new JButton("Modify");
        modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMissionDialog.this.modifyMission();
                EditMissionDialog.this.dispose();
            }
        });
        buttonPane.add(modifyButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMissionDialog.this.dispose();
            }
        });
        buttonPane.add(cancelButton);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void modifyMission() {
        this.mission.setDescription(this.infoPane.descriptionField.getText());
        this.setAction((String)this.infoPane.actionDropDown.getSelectedItem());
        this.setMissionMembers();
    }

    private void setAction(String action) {
        if (action.equals("End EVA and Continue to Next Site")) {
            this.endCollectionPhase();
        } else if (action.equals("Return to Home Settlement and End Mission")) {
            this.returnHome();
        } else if (action.equals("Go to Nearest Settlement and End Mission")) {
            this.goToNearestSettlement();
        }
    }

    private void endCollectionPhase() {
        if (this.mission instanceof CollectResourcesMission) {
            ((CollectResourcesMission)this.mission).endCollectingAtSite();
        }
    }

    private void returnHome() {
        if (this.mission instanceof TravelMission) {
            TravelMission travelMission = (TravelMission)this.mission;
            int offset = 2;
            if (travelMission.getPhase().equals("Travelling")) {
                offset = 1;
            }
            travelMission.setNextNavpointIndex(travelMission.getNumberOfNavpoints() - offset);
            travelMission.updateTravelDestination();
            this.endCollectionPhase();
        }
    }

    private void goToNearestSettlement() {
        if (this.mission instanceof VehicleMission) {
            VehicleMission vehicleMission = (VehicleMission)this.mission;
            try {
                Settlement nearestSettlement = vehicleMission.findClosestSettlement();
                if (nearestSettlement != null) {
                    vehicleMission.clearRemainingNavpoints();
                    vehicleMission.addNavpoint(new NavPoint(nearestSettlement.getCoordinates(), nearestSettlement, nearestSettlement.getName()));
                    vehicleMission.associateAllMembersWithSettlement(nearestSettlement);
                    vehicleMission.updateTravelDestination();
                    this.endCollectionPhase();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setMissionMembers() {
        for (int x = 0; x < this.infoPane.memberListModel.size(); ++x) {
            Person person = (Person)this.infoPane.memberListModel.elementAt(x);
            if (this.mission.hasPerson(person)) continue;
            person.getMind().setMission(this.mission);
        }
        for (Person person : this.mission.getPeople()) {
            if (this.infoPane.memberListModel.contains(person)) continue;
            person.getMind().setMission(null);
        }
    }
}

