/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.CategoryDataset;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.monitor.ColumnSelector;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorTab;

class BarChartTab
extends MonitorTab {
    public static final Icon BARICON = ImageLoader.getIcon("BarChart");
    private static final int MAXLABEL = 12;
    private static final int COLUMNWIDTH = 4;
    private static final int LABELWIDTH = 8;
    private static final int SCROLLTHRESHOLD = 400;
    private static final long MIN_TIME_BETWEEN_UPDATES = 1000L;
    private TableBarDataset barModel = null;
    private JFreeChart chart = null;

    public BarChartTab(MonitorModel model, int[] columns) {
        super(model, false, BARICON);
        String title = model.getName();
        this.setName(title);
        this.barModel = new TableBarDataset(model, columns);
        this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)this.barModel, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        Plot plot = this.chart.getPlot();
        CategoryAxis hAxis = ((CategoryPlot)plot).getDomainAxis();
        CategoryLabelPosition defaultPos = new CategoryLabelPosition();
        CategoryLabelPosition verticalPosition = new CategoryLabelPosition(defaultPos.getCategoryAnchor(), defaultPos.getLabelAnchor(), defaultPos.getRotationAnchor(), 4.71238898038469);
        hAxis.setBottomCategoryLabelPosition(verticalPosition);
        int columnWidth = this.barModel.getSeriesCount() * 4;
        if (columnWidth < 8) {
            columnWidth = 8;
        }
        Object panel = new ChartPanel(this.chart);
        this.chart.setBackgroundPaint((Paint)this.getBackground());
        int chartwidth = columnWidth * this.barModel.getCategoryCount();
        if (chartwidth > 400) {
            Dimension preferredSize = new Dimension(chartwidth, 0);
            panel.setPreferredSize(preferredSize);
            panel = new JScrollPane((Component)panel, 21, 30);
        }
        this.add((Component)panel, "Center");
    }

    @Override
    public void displayProps(MainDesktopPane desktop) {
        int[] columns = ColumnSelector.createBarSelector(desktop.getMainWindow().getFrame(), this.getModel());
        if (columns.length > 0) {
            this.barModel.setColumns(columns);
        }
    }

    @Override
    protected List getSelection() {
        return new ArrayList();
    }

    @Override
    public void removeTab() {
        this.chart = null;
        this.barModel.setModel(null);
        this.barModel = null;
    }

    static class TableBarDataset
    extends AbstractSeriesDataset
    implements CategoryDataset,
    TableModelListener {
        private TableModel model;
        private int[] columns;
        private List<String> categories;
        private long lastUpdateTime;

        public TableBarDataset(TableModel model, int[] columns) {
            this.setModel(model);
            this.setColumns(columns);
        }

        public int getSeriesCount() {
            return this.columns.length;
        }

        public String getSeriesName(int series) {
            return this.model.getColumnName(this.columns[series]);
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public int getCategoryCount() {
            return this.categories.size();
        }

        private void loadCategories() {
            this.categories = new ArrayList<String>(this.model.getRowCount());
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                String value = (String)this.model.getValueAt(i, 0);
                if (value != null && value.length() > 12) {
                    value = value.substring(0, 10) + "..";
                }
                this.categories.add(value);
            }
        }

        public Number getValue(int series, String category) {
            int rowId = this.categories.indexOf(category);
            return (Number)this.model.getValueAt(rowId, this.columns[series]);
        }

        public void setColumns(int[] newcolumns) {
            this.columns = new int[newcolumns.length];
            System.arraycopy(newcolumns, 0, this.columns, 0, newcolumns.length);
            this.fireDatasetChanged();
        }

        public int getRowIndex(Comparable key) {
            int result = -1;
            if (key instanceof String) {
                String keyStr = (String)((Object)key);
                for (int x = 0; x < this.columns.length; ++x) {
                    if (!this.model.getColumnName(this.columns[x]).equals(keyStr)) continue;
                    result = x;
                }
            }
            return result;
        }

        public int getRowCount() {
            return this.columns.length;
        }

        public Comparable getRowKey(int index) {
            return this.model.getColumnName(this.columns[index]);
        }

        public List<String> getRowKeys() {
            ArrayList<String> result = new ArrayList<String>();
            for (int column : this.columns) {
                result.add(this.model.getColumnName(column));
            }
            return result;
        }

        public Comparable getColumnKey(int index) {
            return (Comparable)((Object)this.categories.get(index));
        }

        public List getColumnKeys() {
            return this.categories;
        }

        public int getColumnIndex(Comparable key) {
            int result = -1;
            for (int x = 0; x < this.categories.size(); ++x) {
                if (!key.equals(this.categories.get(x))) continue;
                result = x;
            }
            return result;
        }

        public int getColumnCount() {
            return this.getCategoryCount();
        }

        public Number getValue(int row, int column) {
            return (Number)this.model.getValueAt(column, this.columns[row]);
        }

        public Number getValue(Comparable rowKey, Comparable columnKey) {
            int rowIndex = this.getRowIndex(rowKey);
            int columnIndex = this.getColumnIndex(columnKey);
            return this.getValue(rowIndex, columnIndex);
        }

        public void setModel(TableModel newModel) {
            if (this.model != null) {
                this.model.removeTableModelListener(this);
            }
            this.model = newModel;
            if (this.model != null) {
                this.model.addTableModelListener(this);
                this.loadCategories();
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 1 || e.getType() == -1) {
                this.loadCategories();
                this.fireDatasetChanged();
            } else if (e.getColumn() == -1) {
                this.fireDatasetChanged();
            } else {
                long time;
                boolean dataChanged = false;
                for (int column : this.columns) {
                    if (column != e.getColumn()) continue;
                    dataChanged = true;
                }
                if (dataChanged && (time = System.nanoTime() / 1000000L) - this.lastUpdateTime > 1000L) {
                    this.lastUpdateTime = time;
                    this.fireDatasetChanged();
                }
            }
        }
    }
}

