/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.events.HistoricalEvent;
import org.mars_sim.msp.core.events.HistoricalEventListener;
import org.mars_sim.msp.core.events.HistoricalEventManager;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;

public class EventTableModel
extends AbstractTableModel
implements MonitorModel,
HistoricalEventListener {
    private static final int TIMESTAMP = 0;
    private static final int CATEGORY = 1;
    private static final int TYPE = 2;
    private static final int ACTOR = 3;
    private static final int DESC = 4;
    private static final int COLUMNCOUNT = 5;
    private static String[] columnNames = new String[5];
    private static Class[] columnTypes = new Class[5];
    private HistoricalEventManager manager;
    private List<HistoricalEvent> cachedEvents = new ArrayList<HistoricalEvent>();
    private boolean displayMalfunction = true;
    private boolean displayMedical = true;
    private boolean displayMission = false;
    private boolean displayTask = false;
    private boolean displayTransport = false;

    public EventTableModel(HistoricalEventManager manager) {
        this.manager = manager;
        this.updateCachedEvents();
        manager.addListener((HistoricalEventListener)this);
    }

    private void updateCachedEvents() {
        this.cachedEvents = new ArrayList<HistoricalEvent>();
        for (int x = 0; x < this.manager.size(); ++x) {
            HistoricalEvent event = this.manager.getEvent(x);
            String category = event.getCategory();
            if (category.equals("Malfunction") && this.displayMalfunction) {
                this.cachedEvents.add(event);
            }
            if (category.equals("Medical") && this.displayMedical) {
                this.cachedEvents.add(event);
            }
            if (category.equals("Mission") && this.displayMission) {
                this.cachedEvents.add(event);
            }
            if (category.equals("Task") && this.displayTask) {
                this.cachedEvents.add(event);
            }
            if (!category.equals("Transport") || !this.displayTransport) continue;
            this.cachedEvents.add(event);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventTableModel.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < columnTypes.length) {
            return columnTypes[columnIndex];
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < columnNames.length) {
            return columnNames[columnIndex];
        }
        return "Unknown";
    }

    @Override
    public String getName() {
        return "Historical Events";
    }

    @Override
    public int getRowCount() {
        return this.cachedEvents.size();
    }

    @Override
    public Object getObject(int row) {
        HistoricalEvent event = this.cachedEvents.get(row);
        Object result = null;
        if (event != null) {
            Object source = event.getSource();
            if (source instanceof Unit) {
                result = source;
            } else if (source instanceof Building) {
                result = ((Building)source).getBuildingManager().getSettlement();
            }
        }
        return result;
    }

    @Override
    public boolean getOrdered() {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HistoricalEvent event;
        Object result = null;
        if (rowIndex < this.cachedEvents.size() && (event = this.cachedEvents.get(rowIndex)) != null) {
            switch (columnIndex) {
                case 0: {
                    result = event.getTimestamp().getTimeStamp();
                    break;
                }
                case 1: {
                    result = event.getCategory();
                    break;
                }
                case 3: {
                    result = event.getSource();
                    break;
                }
                case 4: {
                    result = event.getDescription();
                    break;
                }
                case 2: {
                    result = event.getType();
                }
            }
        }
        return result;
    }

    @Override
    public String getCountString() {
        return this.cachedEvents.size() + " events";
    }

    public void eventAdded(int index, HistoricalEvent event) {
        this.updateCachedEvents();
    }

    public void eventsRemoved(int startIndex, int endIndex) {
        this.updateCachedEvents();
    }

    public boolean getDisplayMalfunction() {
        return this.displayMalfunction;
    }

    public void setDisplayMalfunction(boolean display) {
        this.displayMalfunction = display;
        this.updateCachedEvents();
    }

    public boolean getDisplayMedical() {
        return this.displayMedical;
    }

    public void setDisplayMedical(boolean display) {
        this.displayMedical = display;
        this.updateCachedEvents();
    }

    public boolean getDisplayMission() {
        return this.displayMission;
    }

    public void setDisplayMission(boolean display) {
        this.displayMission = display;
        this.updateCachedEvents();
    }

    public boolean getDisplayTask() {
        return this.displayTask;
    }

    public void setDisplayTask(boolean display) {
        this.displayTask = display;
        this.updateCachedEvents();
    }

    public boolean getDisplayTransport() {
        return this.displayTransport;
    }

    public void setDisplayTransport(boolean display) {
        this.displayTransport = display;
        this.updateCachedEvents();
    }

    @Override
    public void destroy() {
        this.manager.removeListener((HistoricalEventListener)this);
        this.manager = null;
        this.cachedEvents = null;
    }

    static {
        EventTableModel.columnNames[0] = "Time";
        EventTableModel.columnTypes[0] = String.class;
        EventTableModel.columnNames[1] = "Category";
        EventTableModel.columnTypes[1] = String.class;
        EventTableModel.columnNames[2] = "Event Type";
        EventTableModel.columnTypes[2] = String.class;
        EventTableModel.columnNames[3] = "Actor";
        EventTableModel.columnTypes[3] = Object.class;
        EventTableModel.columnNames[4] = "Description";
        EventTableModel.columnTypes[4] = String.class;
    }
}

