/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.awt.BorderLayout;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;

abstract class MonitorTab
extends JPanel {
    private MonitorModel model;
    private Icon icon;
    private boolean mandatory;

    public MonitorTab(MonitorModel model, boolean mandatory, Icon icon) {
        this.model = model;
        this.icon = icon;
        this.mandatory = mandatory;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public void removeTab() {
        this.model.destroy();
        this.model = null;
    }

    public void displayDetails(MainDesktopPane desktop) {
        List rows = this.getSelection();
        for (Object selected : rows) {
            if (!(selected instanceof Unit)) continue;
            desktop.openUnitWindow((Unit)selected, false);
        }
    }

    public void centerMap(MainDesktopPane desktop) {
        List rows = this.getSelection();
        Iterator it = rows.iterator();
        if (it.hasNext()) {
            Unit unit = (Unit)it.next();
            desktop.centerMapGlobe(unit.getCoordinates());
        }
    }

    public abstract void displayProps(MainDesktopPane var1);

    protected abstract List getSelection();

    public String getCountString() {
        return this.model.getCountString();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public MonitorModel getModel() {
        return this.model;
    }

    public boolean getMandatory() {
        return this.mandatory;
    }
}

