/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;

class TableProperties
extends JInternalFrame {
    private TableColumnModel model;
    private ArrayList<JCheckBox> columnButtons = new ArrayList();

    public TableProperties(String title, JTable table, MainDesktopPane main) {
        super(title + " Properties", false, true);
        this.model = table.getColumnModel();
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BorderLayout());
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPane);
        JPanel columnPane = new JPanel(new GridLayout(0, 1));
        columnPane.setBorder(new MarsPanelBorder());
        TableModel dataModel = table.getModel();
        for (int i = 0; i < dataModel.getColumnCount(); ++i) {
            String name = dataModel.getColumnName(i);
            JCheckBox column = new JCheckBox(name);
            column.setSelected(false);
            column.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TableProperties.this.columnSelected(event);
                }
            });
            this.columnButtons.add(column);
            columnPane.add(column);
        }
        Enumeration<TableColumn> en = this.model.getColumns();
        while (en.hasMoreElements()) {
            int selected = en.nextElement().getModelIndex();
            JCheckBox columnButton = this.columnButtons.get(selected);
            columnButton.setSelected(true);
        }
        mainPane.add((Component)columnPane, "Center");
        this.pack();
        main.add(this);
    }

    private void columnSelected(ActionEvent event) {
        JCheckBox button = (JCheckBox)event.getSource();
        int index = this.columnButtons.indexOf(button);
        if (button.isSelected()) {
            TableColumn col = new TableColumn(index);
            col.setHeaderValue(button.getText());
            this.model.addColumn(col);
        } else {
            TableColumn col = null;
            Enumeration<TableColumn> en = this.model.getColumns();
            while (col == null && en.hasMoreElements()) {
                TableColumn next = en.nextElement();
                if (next.getModelIndex() != index) continue;
                col = next;
            }
            this.model.removeColumn(col);
        }
    }
}

