/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.util.Arrays;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;

public class TableSorter
extends AbstractTableModel
implements TableModelListener,
MonitorModel {
    private static final long SORTING_TIME_BUFFER = 500L;
    private int[] indexes;
    private boolean sortAscending = false;
    private int sortedColumn;
    private MonitorModel sourceModel;
    private long lastSortedTime;

    public TableSorter(MonitorModel model) {
        this.sourceModel = model;
        this.sourceModel.addTableModelListener(this);
        this.reallocateIndexes();
    }

    @Override
    public boolean getOrdered() {
        return true;
    }

    private int compare(int row1, int row2) {
        Comparable obj1 = (Comparable)this.sourceModel.getValueAt(row1, this.sortedColumn);
        Object obj2 = this.sourceModel.getValueAt(row2, this.sortedColumn);
        int result = 0;
        if (obj1 == null) {
            result = obj2 == null ? 0 : 1;
        } else if (obj2 == null) {
            result = -1;
        } else {
            try {
                result = obj1.compareTo(obj2);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (result != 0) {
            return this.sortAscending ? result : -result;
        }
        return 0;
    }

    private void reallocateIndexes() {
        int rowCount = this.sourceModel.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        long currentTime;
        long timeDiff;
        TableModelEvent newEvent = null;
        int type = e.getType();
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        if (this.indexes == null) {
            return;
        }
        for (int x = 0; x < this.indexes.length; ++x) {
            if (this.indexes[x] == e.getFirstRow()) {
                firstRow = x;
            }
            if (this.indexes[x] != e.getLastRow()) continue;
            lastRow = x;
        }
        if (type == -1 || type == 1) {
            this.sortModel();
            newEvent = new TableModelEvent(this, firstRow, lastRow, e.getColumn(), e.getType());
        } else if ((e.getColumn() == this.sortedColumn || e.getColumn() == -1) && (timeDiff = (currentTime = System.currentTimeMillis()) - this.lastSortedTime) > 500L) {
            if (this.sortModel()) {
                newEvent = new TableModelEvent(this, 0, this.sourceModel.getRowCount());
            }
            this.lastSortedTime = currentTime;
        }
        if (newEvent == null) {
            if (firstRow == -1 || firstRow != lastRow) {
                firstRow = 0;
                if (this.sourceModel != null) {
                    lastRow = this.sourceModel.getRowCount();
                }
            }
            newEvent = new TableModelEvent(this, firstRow, lastRow, e.getColumn());
        }
        this.fireTableChanged(newEvent);
    }

    private void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) >= 0) continue;
                this.swap(i, j);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.sourceModel.getColumnCount();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.sourceModel.getColumnClass(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.sourceModel.getColumnName(columnIndex);
    }

    @Override
    public String getName() {
        if (this.sourceModel != null) {
            return this.sourceModel.getName();
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this.sourceModel != null) {
            return this.sourceModel.getRowCount();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        try {
            return this.sourceModel.getValueAt(this.indexes[aRow], aColumn);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getObject(int row) {
        if (row < this.indexes.length) {
            return this.sourceModel.getObject(this.indexes[row]);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.sourceModel.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    @Override
    public String getCountString() {
        return this.sourceModel.getCountString();
    }

    public void sortByColumn(int column, boolean ascending) {
        this.sortAscending = ascending;
        this.sortedColumn = column;
        boolean sorted = this.sortModel();
        if (sorted) {
            this.fireTableRowsUpdated(0, this.sourceModel.getRowCount());
        }
    }

    private boolean sortModel() {
        int[] original = (int[])this.indexes.clone();
        this.reallocateIndexes();
        Class<?> cellType = this.sourceModel.getColumnClass(this.sortedColumn);
        if (Comparable.class.isAssignableFrom(cellType)) {
            this.n2sort();
        }
        return !Arrays.equals(original, this.indexes);
    }

    private void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    @Override
    public void destroy() {
    }
}

