/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.UnitEvent;
import org.mars_sim.msp.core.UnitListener;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.core.equipment.Container;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;

public class TradeTableModel
extends AbstractTableModel
implements UnitListener,
MonitorModel,
UnitManagerListener {
    private List<Good> goodsList = GoodsUtil.getGoodsList();
    private List<Settlement> settlements;

    TradeTableModel() {
        UnitManager unitManager = Simulation.instance().getUnitManager();
        this.settlements = new ArrayList<Settlement>(unitManager.getSettlements());
        Iterator<Settlement> i = this.settlements.iterator();
        while (i.hasNext()) {
            i.next().addUnitListener((UnitListener)this);
        }
        unitManager.addUnitManagerListener((UnitManagerListener)this);
    }

    public void unitUpdate(UnitEvent event) {
        if (event.getType().equals("goods values")) {
            SwingUtilities.invokeLater(new TradeTableUpdater(event));
        }
    }

    @Override
    public void destroy() {
        Iterator<Settlement> i = this.settlements.iterator();
        while (i.hasNext()) {
            i.next().removeUnitListener((UnitListener)this);
        }
        Simulation.instance().getUnitManager().removeUnitManagerListener((UnitManagerListener)this);
    }

    @Override
    public String getCountString() {
        return this.goodsList.size() + " trade goods";
    }

    @Override
    public String getName() {
        return "Trade Goods";
    }

    @Override
    public Object getObject(int row) {
        return this.goodsList.get(row);
    }

    @Override
    public boolean getOrdered() {
        return false;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Trade Good";
        }
        if (columnIndex == 1) {
            return "Category";
        }
        return this.settlements.get(columnIndex - 2).getName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 2) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return this.settlements.size() + 2;
    }

    @Override
    public int getRowCount() {
        return this.goodsList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.goodsList.get(rowIndex).getName();
        }
        if (columnIndex == 1) {
            return this.getGoodCategory(this.goodsList.get(rowIndex));
        }
        try {
            Settlement settlement = this.settlements.get(columnIndex - 2);
            Good good = this.goodsList.get(rowIndex);
            double result = settlement.getGoodsManager().getGoodValuePerItem(good);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getGoodCategory(Good good) {
        String result = good.getCategory();
        if (result.equals("amount resource")) {
            result = "resource";
        } else if (result.equals("item resource")) {
            result = "part";
        } else if (result.equals("equipment") && Container.class.isAssignableFrom(good.getClassType())) {
            result = "container";
        }
        return result;
    }

    public void unitManagerUpdate(UnitManagerEvent event) {
        if (event.getUnit() instanceof Settlement) {
            Settlement settlement = (Settlement)event.getUnit();
            if ("add unit".equals(event.getEventType())) {
                if (!this.settlements.contains(settlement)) {
                    this.settlements.add(settlement);
                    settlement.addUnitListener((UnitListener)this);
                }
            } else if ("remove unit".equals(event.getEventType()) && this.settlements.contains(settlement)) {
                this.settlements.remove(settlement);
                settlement.removeUnitListener((UnitListener)this);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TradeTableModel.this.fireTableStructureChanged();
                    TradeTableModel.this.fireTableStructureChanged();
                }
            });
        }
    }

    private class TradeTableUpdater
    implements Runnable {
        private UnitEvent event;

        private TradeTableUpdater(UnitEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (this.event.getTarget() == null) {
                TradeTableModel.this.fireTableDataChanged();
            } else {
                int rowIndex = TradeTableModel.this.goodsList.indexOf(this.event.getTarget());
                int columnIndex = TradeTableModel.this.settlements.indexOf(this.event.getSource()) + 2;
                TradeTableModel.this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }
}

