/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitListener;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;

public abstract class UnitTableModel
extends AbstractTableModel
implements MonitorModel,
UnitListener {
    private Collection<Unit> units;
    private String name;
    private String statusSuffix;
    private String[] columnNames;
    private Class[] columnTypes;
    private int size = -1;
    private boolean refreshSize = true;

    protected UnitTableModel(String name, String suffix, String[] names, Class[] types) {
        this.name = name;
        this.statusSuffix = suffix;
        this.units = new ConcurrentLinkedQueue<Unit>();
        this.getRowCount();
        this.columnNames = names;
        this.columnTypes = types;
    }

    protected void addUnit(Unit newUnit) {
        if (!this.units.contains(newUnit)) {
            this.units.add(newUnit);
            this.refreshSize = true;
            newUnit.addUnitListener((UnitListener)this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UnitTableModel.this.fireTableRowsInserted(UnitTableModel.this.getUnitNumber() - 1, UnitTableModel.this.getUnitNumber() - 1);
                }
            });
        }
    }

    protected void removeUnit(Unit oldUnit) {
        if (this.units.contains(oldUnit)) {
            int index = this.getIndex(oldUnit);
            this.units.remove(oldUnit);
            this.refreshSize = true;
            oldUnit.removeUnitListener((UnitListener)this);
            SwingUtilities.invokeLater(new RemoveUnitTableUpdater(index));
        }
    }

    private int getIndex(Unit unit) {
        Iterator<Unit> it = this.units.iterator();
        int idx = -1;
        while (it.hasNext()) {
            ++idx;
            Unit u = it.next();
            if (!u.equals(unit)) continue;
            return idx;
        }
        throw new IllegalStateException("Could not find index for unit " + unit);
    }

    protected void addAll(Collection<Unit> newUnits) {
        Iterator<Unit> i = newUnits.iterator();
        while (i.hasNext()) {
            this.addUnit(i.next());
        }
    }

    protected void clear() {
        Iterator<Unit> i = this.units.iterator();
        while (i.hasNext()) {
            i.next().removeUnitListener((UnitListener)this);
        }
        this.units.clear();
        this.refreshSize = true;
        this.fireTableDataChanged();
    }

    protected boolean containsUnit(Unit unit) {
        return this.units.contains(unit);
    }

    protected int getUnitNumber() {
        if (this.refreshSize) {
            this.size = this.units == null ? 0 : this.units.size();
            this.refreshSize = false;
        }
        return this.size;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.columnTypes.length) {
            return this.columnTypes[columnIndex];
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.columnNames.length) {
            return this.columnNames[columnIndex];
        }
        return "Unknown";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.getUnitNumber();
    }

    @Override
    public boolean getOrdered() {
        return false;
    }

    protected Unit getUnit(int index) {
        if (index > this.getRowCount() - 1) {
            throw new IllegalStateException("Invalid index " + index + " for " + this.getRowCount() + " rows");
        }
        int idx = -1;
        Iterator<Unit> it = this.units.iterator();
        while (it.hasNext()) {
            if (++idx == index) {
                return it.next();
            }
            it.next();
        }
        throw new IllegalStateException("Could not find an index " + index);
    }

    protected int getUnitIndex(Unit unit) {
        if (this.units != null && this.units.contains(unit)) {
            return this.getIndex(unit);
        }
        return -1;
    }

    @Override
    public Object getObject(int row) {
        return this.getUnit(row);
    }

    @Override
    public String getCountString() {
        return this.getUnitNumber() + this.statusSuffix;
    }

    @Override
    public void destroy() {
        if (this.units != null) {
            this.clear();
        }
        this.units = null;
    }

    public boolean equals(Object o) {
        boolean result = true;
        if (o instanceof UnitTableModel) {
            UnitTableModel oModel = (UnitTableModel)o;
            if (!this.units.equals(oModel.units)) {
                result = false;
            }
            if (!this.name.equals(oModel.name)) {
                result = false;
            }
            if (!this.statusSuffix.equals(oModel.statusSuffix)) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private class RemoveUnitTableUpdater
    implements Runnable {
        private int index;

        private RemoveUnitTableUpdater(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            UnitTableModel.this.fireTableRowsDeleted(this.index, this.index);
        }
    }
}

