/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.navigator;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.ui.swing.ImageLoader;

public class MarsGlobe {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.tool.navigator.MarsGlobe";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private static final int map_height = 150;
    private static final int map_width = 300;
    private Coordinates centerCoords;
    private Vector<Integer>[] sphereColor;
    private Image marsMap;
    private Image globeImage;
    private boolean imageDone;
    private JComponent displayArea;

    public MarsGlobe(String globeType, JComponent displayArea) {
        this.displayArea = displayArea;
        this.sphereColor = new Vector[150];
        this.centerCoords = new Coordinates(1.5707963267948966, 1.5707963267948966);
        String imageName = globeType.equals("surface") ? "SurfaceMarsMapSmall.jpg" : "TopoMarsMapSmall.jpg";
        MediaTracker mtrack = new MediaTracker(displayArea);
        this.marsMap = ImageLoader.getImage(imageName);
        mtrack.addImage(this.marsMap, 0);
        try {
            mtrack.waitForAll();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Media Tracker Error " + e);
        }
        this.setup_sphere();
    }

    public synchronized void drawSphere(Coordinates newCenter) {
        double row_iterate;
        boolean north;
        Coordinates adjNewCenter = new Coordinates(newCenter.getPhi(), newCenter.getTheta() + Math.PI);
        if (this.centerCoords.equals((Object)adjNewCenter)) {
            return;
        }
        this.imageDone = false;
        this.centerCoords.setCoords(adjNewCenter);
        double PI_half = 1.5707963267948966;
        double PI_double = Math.PI * 2;
        double end_row = this.centerCoords.getPhi() - PI_half;
        double start_row = end_row + Math.PI;
        if (this.centerCoords.getPhi() <= PI_half) {
            north = true;
            end_row = this.centerCoords.getPhi() - PI_half;
            start_row = end_row + Math.PI;
            row_iterate = -0.020943951023931952;
        } else {
            north = false;
            start_row = this.centerCoords.getPhi() - PI_half;
            end_row = start_row + Math.PI;
            row_iterate = 0.020943951023931952;
        }
        double col_correction = -1.5707963267948966 - this.centerCoords.getTheta();
        double rho = 47.7464829275686;
        double sin_offset = Math.sin(this.centerCoords.getPhi() + Math.PI);
        double cos_offset = Math.cos(this.centerCoords.getPhi() + Math.PI);
        double col_array_modifier = 1.0 / PI_double;
        int half_map = 75;
        int[] buffer_array = new int[22500];
        for (double row = start_row; north && row >= end_row || !north && row <= end_row; row += row_iterate) {
            int array_y;
            if (row < 0.0 || row >= Math.PI || (array_y = (int)Math.round(150.0 * row / Math.PI)) >= 150) continue;
            int circum = this.sphereColor[array_y].size();
            double row_cos = Math.cos(row);
            double col_boundry = Math.PI;
            if (this.centerCoords.getPhi() <= PI_half) {
                if (row >= PI_half * Math.cos(this.centerCoords.getPhi()) && row < PI_half) {
                    col_boundry = PI_half * (1.0 + row_cos);
                } else if (row >= PI_half) {
                    col_boundry = PI_half;
                }
            } else if (row <= PI_half * Math.cos(this.centerCoords.getPhi()) && row > PI_half) {
                col_boundry = PI_half * (1.0 - row_cos);
            } else if (row <= PI_half) {
                col_boundry = PI_half;
            }
            if (this.centerCoords.getPhi() == PI_half) {
                col_boundry = PI_half;
            }
            double col_iterate = Math.PI / (double)circum;
            double error_correction = this.centerCoords.getPhi() - PI_half;
            if (error_correction > 0.0) {
                if (error_correction < row_iterate) {
                    col_boundry = PI_half;
                }
            } else if (error_correction > 0.0 - row_iterate) {
                col_boundry = PI_half;
            }
            double start_col = this.centerCoords.getTheta() - col_boundry;
            double end_col = this.centerCoords.getTheta() + col_boundry;
            if (col_boundry == Math.PI) {
                end_col -= col_iterate;
            }
            double temp_buff_x = rho * Math.sin(row);
            double temp_buff_y1 = temp_buff_x * cos_offset;
            double temp_buff_y2 = rho * row_cos * sin_offset;
            double col_array_modifier2 = col_array_modifier * (double)circum;
            for (double col = start_col; col <= end_col; col += col_iterate) {
                int array_x = (int)(col_array_modifier2 * col);
                if (array_x < 0) {
                    array_x += circum;
                } else if (array_x >= circum) {
                    array_x -= circum;
                }
                double temp_col = col + col_correction;
                int buff_x = (int)Math.round(temp_buff_x * Math.cos(temp_col)) + half_map;
                int buff_y = (int)Math.round(temp_buff_y1 * Math.sin(temp_col) + temp_buff_y2) + half_map;
                buffer_array[buff_x + 150 * buff_y] = this.sphereColor[array_y].elementAt(array_x);
            }
        }
        this.globeImage = this.displayArea.createImage(new MemoryImageSource(150, 150, buffer_array, 0, 150));
        MediaTracker mt = new MediaTracker(this.displayArea);
        mt.addImage(this.globeImage, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Media Tracker Error " + e);
        }
        this.imageDone = true;
    }

    public Image getGlobeImage() {
        return this.globeImage;
    }

    private void setup_sphere() {
        double offset;
        double ih_d = 150.0;
        int[] pixels_color = new int[45000];
        int[][] map_pixels = new int[300][150];
        PixelGrabber pg_color = new PixelGrabber(this.marsMap, 0, 0, 300, 150, pixels_color, 0, 300);
        try {
            pg_color.grabPixels();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "grabber error" + e);
        }
        if ((pg_color.status() & 0x80) != 0) {
            logger.info("grabber error");
        }
        for (int x = 0; x < 300; ++x) {
            for (int y = 0; y < 150; ++y) {
                map_pixels[x][y] = pixels_color[x + y * 300];
            }
        }
        double rho = 47.7464829275686;
        for (double phi = offset = Math.PI / (2.0 * ih_d); phi < Math.PI; phi += Math.PI / ih_d) {
            int row = (int)Math.floor(phi / Math.PI * ih_d);
            double circum = Math.PI * 2 * (rho * Math.sin(phi));
            int col_num = (int)Math.round(circum);
            this.sphereColor[row] = new Vector(col_num);
            for (double theta = 0.0; theta < Math.PI * 2; theta += Math.PI * 2 / circum) {
                int map_col = theta == 0.0 ? 0 : (int)Math.floor(theta / Math.PI * ih_d);
                this.sphereColor[row].addElement(map_pixels[map_col][row]);
            }
        }
    }

    public boolean isImageDone() {
        return this.imageDone;
    }
}

