/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MainWindow;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.sound.AudioPlayer;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;

public class PreferencesWindow
extends ToolWindow {
    public static final String NAME = "Preferences Tool";
    private AudioPlayer soundPlayer;
    private JCheckBox muteCheck;
    private JSlider volumeSlider;
    private JCheckBox toolToolBarCheck;
    private JCheckBox unitToolBarCheck;

    public PreferencesWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        this.setResizable(false);
        this.soundPlayer = desktop.getSoundPlayer();
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new MarsPanelBorder());
        this.setContentPane(mainPane);
        JPanel audioPane = new JPanel(new BorderLayout());
        audioPane.setBorder(new MarsPanelBorder());
        mainPane.add((Component)audioPane, "North");
        JLabel volumeLabel = new JLabel("Volume", 0);
        audioPane.add((Component)volumeLabel, "North");
        float volume = this.soundPlayer.getVolume();
        int intVolume = Math.round(volume * 10.0f);
        this.volumeSlider = new JSlider(0, 0, 10, intVolume);
        this.volumeSlider.setMajorTickSpacing(1);
        this.volumeSlider.setPaintTicks(true);
        this.volumeSlider.setToolTipText("Adjust the volume of sound output.");
        this.volumeSlider.setEnabled(!this.soundPlayer.isMute());
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                float newVolume = (float)PreferencesWindow.this.volumeSlider.getValue() / 10.0f;
                PreferencesWindow.this.soundPlayer.setVolume(newVolume);
            }
        });
        audioPane.add((Component)this.volumeSlider, "South");
        this.muteCheck = new JCheckBox("Mute", this.soundPlayer.isMute());
        this.muteCheck.setToolTipText("Mute all sound output.");
        this.muteCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.soundPlayer.setMute(PreferencesWindow.this.muteCheck.isSelected());
                PreferencesWindow.this.volumeSlider.setEnabled(!PreferencesWindow.this.soundPlayer.isMute());
            }
        });
        audioPane.add(this.muteCheck);
        JPanel uiPane = new JPanel(new BorderLayout());
        uiPane.setBorder(new MarsPanelBorder());
        mainPane.add((Component)uiPane, "South");
        final MainWindow theMainwindow = desktop.getMainWindow();
        boolean unitToolBarVisible = theMainwindow.getUnitToolBar().isVisible();
        this.unitToolBarCheck = new JCheckBox("Show Unit Toolbar", unitToolBarVisible);
        this.unitToolBarCheck.setToolTipText("Show the Unit Bar at the bottom.");
        this.unitToolBarCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                theMainwindow.getUnitToolBar().setVisible(PreferencesWindow.this.unitToolBarCheck.isSelected());
            }
        });
        uiPane.add((Component)this.unitToolBarCheck, "Center");
        boolean toolToolBarVisible = theMainwindow.getToolToolBar().isVisible();
        this.toolToolBarCheck = new JCheckBox("Show Toolbar", toolToolBarVisible);
        this.toolToolBarCheck.setToolTipText("Show the Tool Bar at the top.");
        this.toolToolBarCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                theMainwindow.getToolToolBar().setVisible(PreferencesWindow.this.toolToolBarCheck.isSelected());
            }
        });
        uiPane.add((Component)this.toolToolBarCheck, "South");
        this.pack();
    }

    @Override
    public void destroy() {
        this.soundPlayer.cleanAudioPlayer();
        this.soundPlayer = null;
    }
}

