/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;
import org.mars_sim.msp.core.interplanetary.transport.resupply.ResupplyUtil;
import org.mars_sim.msp.core.interplanetary.transport.settlement.ArrivingSettlement;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.SettlementTemplate;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.resupply.MartianSolComboBoxModel;
import org.mars_sim.msp.ui.swing.tool.resupply.TransportItemEditingPanel;

public class ArrivingSettlementEditingPanel
extends TransportItemEditingPanel {
    private ArrivingSettlement settlement;
    private JTextField nameTF;
    private JComboBox templateCB;
    private JRadioButton arrivalDateRB;
    private JLabel arrivalDateTitleLabel;
    private JRadioButton timeUntilArrivalRB;
    private JLabel timeUntilArrivalLabel;
    private MartianSolComboBoxModel martianSolCBModel;
    private JLabel solLabel;
    private JComboBox solCB;
    private JLabel monthLabel;
    private JComboBox monthCB;
    private JLabel orbitLabel;
    private JComboBox orbitCB;
    private JTextField solsTF;
    private JLabel solInfoLabel;
    private JTextField latitudeTF;
    private JComboBox latitudeDirectionCB;
    private JTextField longitudeTF;
    private JComboBox longitudeDirectionCB;
    private JTextField populationTF;
    private JLabel errorLabel;

    public ArrivingSettlementEditingPanel(ArrivingSettlement settlement) {
        super((Transportable)settlement);
        this.settlement = settlement;
        this.setBorder(new MarsPanelBorder());
        this.setLayout(new BorderLayout(0, 0));
        JPanel topEditPane = new JPanel(new BorderLayout(10, 10));
        this.add((Component)topEditPane, "North");
        JPanel topInnerEditPane = new JPanel(new GridLayout(3, 1, 0, 10));
        topEditPane.add((Component)topInnerEditPane, "North");
        JPanel namePane = new JPanel(new FlowLayout(0, 0, 0));
        topInnerEditPane.add(namePane);
        JLabel nameTitleLabel = new JLabel("Settlement Name: ");
        namePane.add(nameTitleLabel);
        this.nameTF = new JTextField("", 25);
        if (settlement != null) {
            this.nameTF.setText(settlement.getName());
        }
        namePane.add(this.nameTF);
        JPanel templatePane = new JPanel(new FlowLayout(0, 0, 0));
        topInnerEditPane.add(templatePane);
        JLabel templateTitleLabel = new JLabel("Layout Template: ");
        templatePane.add(templateTitleLabel);
        Vector<String> templateNames = new Vector<String>();
        Iterator i = SimulationConfig.instance().getSettlementConfiguration().getSettlementTemplates().iterator();
        while (i.hasNext()) {
            templateNames.add(((SettlementTemplate)i.next()).getTemplateName());
        }
        this.templateCB = new JComboBox(templateNames);
        if (settlement != null) {
            this.templateCB.setSelectedItem(settlement.getTemplate());
        }
        this.templateCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArrivingSettlementEditingPanel.this.updateTemplatePopulationNum((String)ArrivingSettlementEditingPanel.this.templateCB.getSelectedItem());
            }
        });
        templatePane.add(this.templateCB);
        JPanel populationPane = new JPanel(new FlowLayout(0, 0, 0));
        topInnerEditPane.add(populationPane);
        JLabel populationLabel = new JLabel("Population Number: ");
        populationPane.add(populationLabel);
        int populationNum = 0;
        if (settlement != null) {
            populationNum = settlement.getPopulationNum();
        } else {
            SettlementTemplate template;
            String templateName = (String)this.templateCB.getSelectedItem();
            if (templateName != null && (template = SimulationConfig.instance().getSettlementConfiguration().getSettlementTemplate(templateName)) != null) {
                populationNum = template.getDefaultPopulation();
            }
        }
        this.populationTF = new JTextField(6);
        this.populationTF.setText(Integer.toString(populationNum));
        this.populationTF.setHorizontalAlignment(4);
        populationPane.add(this.populationTF);
        JPanel arrivalDatePane = new JPanel(new GridLayout(2, 1, 10, 10));
        arrivalDatePane.setBorder(new TitledBorder("Arrival Date"));
        topEditPane.add((Component)arrivalDatePane, "Center");
        ButtonGroup dateTypeRBGroup = new ButtonGroup();
        JPanel arrivalDateSelectionPane = new JPanel(new FlowLayout(0, 5, 0));
        arrivalDatePane.add(arrivalDateSelectionPane);
        this.arrivalDateRB = new JRadioButton();
        dateTypeRBGroup.add(this.arrivalDateRB);
        this.arrivalDateRB.setSelected(true);
        this.arrivalDateRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRadioButton rb = (JRadioButton)evt.getSource();
                ArrivingSettlementEditingPanel.this.setEnableArrivalDatePane(rb.isSelected());
                ArrivingSettlementEditingPanel.this.setEnableTimeUntilArrivalPane(!rb.isSelected());
            }
        });
        arrivalDateSelectionPane.add(this.arrivalDateRB);
        this.arrivalDateTitleLabel = new JLabel("Arrival Date:");
        arrivalDateSelectionPane.add(this.arrivalDateTitleLabel);
        MarsClock arrivingTime = Simulation.instance().getMasterClock().getMarsClock();
        if (settlement != null) {
            arrivingTime = settlement.getArrivalDate();
        }
        this.solLabel = new JLabel("Sol");
        arrivalDateSelectionPane.add(this.solLabel);
        this.martianSolCBModel = new MartianSolComboBoxModel(arrivingTime.getMonth(), arrivingTime.getOrbit());
        this.solCB = new JComboBox(this.martianSolCBModel);
        this.solCB.setSelectedItem(arrivingTime.getSolOfMonth());
        arrivalDateSelectionPane.add(this.solCB);
        this.monthLabel = new JLabel("Month");
        arrivalDateSelectionPane.add(this.monthLabel);
        this.monthCB = new JComboBox<String>(MarsClock.getMonthNames());
        this.monthCB.setSelectedItem(arrivingTime.getMonthName());
        this.monthCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrivingSettlementEditingPanel.this.martianSolCBModel.updateSolNumber(ArrivingSettlementEditingPanel.this.monthCB.getSelectedIndex() + 1, Integer.parseInt((String)ArrivingSettlementEditingPanel.this.orbitCB.getSelectedItem()));
            }
        });
        arrivalDateSelectionPane.add(this.monthCB);
        this.orbitLabel = new JLabel("Orbit");
        arrivalDateSelectionPane.add(this.orbitLabel);
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMinimumIntegerDigits(2);
        String[] orbitValues = new String[20];
        int startOrbit = arrivingTime.getOrbit();
        for (int x = 0; x < 20; ++x) {
            orbitValues[x] = formatter.format(startOrbit + x);
        }
        this.orbitCB = new JComboBox<String>(orbitValues);
        this.orbitCB.setSelectedItem(formatter.format(startOrbit));
        this.orbitCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrivingSettlementEditingPanel.this.martianSolCBModel.updateSolNumber(ArrivingSettlementEditingPanel.this.monthCB.getSelectedIndex() + 1, Integer.parseInt((String)ArrivingSettlementEditingPanel.this.orbitCB.getSelectedItem()));
            }
        });
        arrivalDateSelectionPane.add(this.orbitCB);
        JPanel timeUntilArrivalPane = new JPanel(new FlowLayout(0, 5, 0));
        arrivalDatePane.add(timeUntilArrivalPane);
        this.timeUntilArrivalRB = new JRadioButton();
        dateTypeRBGroup.add(this.timeUntilArrivalRB);
        this.timeUntilArrivalRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRadioButton rb = (JRadioButton)evt.getSource();
                ArrivingSettlementEditingPanel.this.setEnableTimeUntilArrivalPane(rb.isSelected());
                ArrivingSettlementEditingPanel.this.setEnableArrivalDatePane(!rb.isSelected());
            }
        });
        timeUntilArrivalPane.add(this.timeUntilArrivalRB);
        this.timeUntilArrivalLabel = new JLabel("Sols Until Arrival:");
        this.timeUntilArrivalLabel.setEnabled(false);
        timeUntilArrivalPane.add(this.timeUntilArrivalLabel);
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        int solsDiff = (int)Math.round(MarsClock.getTimeDiff((MarsClock)arrivingTime, (MarsClock)currentTime) / 1000.0);
        this.solsTF = new JTextField(6);
        this.solsTF.setText(Integer.toString(solsDiff));
        this.solsTF.setHorizontalAlignment(4);
        this.solsTF.setEnabled(false);
        timeUntilArrivalPane.add(this.solsTF);
        this.solInfoLabel = new JLabel("(668 Sols = 1 Martian Orbit)");
        this.solInfoLabel.setEnabled(false);
        timeUntilArrivalPane.add(this.solInfoLabel);
        JPanel landingLocationPane = new JPanel(new GridLayout(2, 1, 0, 10));
        landingLocationPane.setBorder(new TitledBorder("Landing Location"));
        topEditPane.add((Component)landingLocationPane, "South");
        JPanel latitudePane = new JPanel(new FlowLayout(0, 5, 0));
        landingLocationPane.add(latitudePane);
        JLabel latitudeTitleLabel = new JLabel("Latitude: ");
        latitudePane.add(latitudeTitleLabel);
        this.latitudeTF = new JTextField("0.0", 4);
        if (settlement != null) {
            String latString = settlement.getLandingLocation().getFormattedLatitudeString();
            String cleanLatString = latString.substring(0, latString.length() - 3);
            this.latitudeTF.setText(cleanLatString);
        }
        this.latitudeTF.setHorizontalAlignment(4);
        latitudePane.add(this.latitudeTF);
        JLabel latDegLabel = new JLabel("\u00ba");
        latitudePane.add(latDegLabel);
        this.latitudeDirectionCB = new JComboBox();
        this.latitudeDirectionCB.addItem("N");
        this.latitudeDirectionCB.addItem("S");
        if (settlement != null) {
            String latString = settlement.getLandingLocation().getFormattedLatitudeString();
            String dirString = latString.substring(latString.length() - 1, latString.length());
            this.latitudeDirectionCB.setSelectedItem(dirString);
        }
        latitudePane.add(this.latitudeDirectionCB);
        JPanel longitudePane = new JPanel(new FlowLayout(0, 5, 0));
        landingLocationPane.add(longitudePane);
        JLabel longitudeTitleLabel = new JLabel("Longitude: ");
        longitudePane.add(longitudeTitleLabel);
        this.longitudeTF = new JTextField("0.0", 4);
        if (settlement != null) {
            String lonString = settlement.getLandingLocation().getFormattedLongitudeString();
            String cleanLonString = lonString.substring(0, lonString.length() - 3);
            this.longitudeTF.setText(cleanLonString);
        }
        this.longitudeTF.setHorizontalAlignment(4);
        longitudePane.add(this.longitudeTF);
        JLabel lonDegLabel = new JLabel("\u00ba");
        longitudePane.add(lonDegLabel);
        this.longitudeDirectionCB = new JComboBox();
        this.longitudeDirectionCB.addItem("W");
        this.longitudeDirectionCB.addItem("E");
        if (settlement != null) {
            String lonString = settlement.getLandingLocation().getFormattedLongitudeString();
            String dirString = lonString.substring(lonString.length() - 1, lonString.length());
            this.longitudeDirectionCB.setSelectedItem(dirString);
        }
        longitudePane.add(this.longitudeDirectionCB);
        JPanel errorPane = new JPanel(new FlowLayout(1, 10, 10));
        this.add((Component)errorPane, "South");
        this.errorLabel = new JLabel(" ");
        this.errorLabel.setForeground(Color.RED);
        errorPane.add(this.errorLabel);
    }

    private void setEnableArrivalDatePane(boolean enable) {
        this.arrivalDateTitleLabel.setEnabled(enable);
        this.solLabel.setEnabled(enable);
        this.solCB.setEnabled(enable);
        this.monthLabel.setEnabled(enable);
        this.monthCB.setEnabled(enable);
        this.orbitLabel.setEnabled(enable);
        this.orbitCB.setEnabled(enable);
    }

    private void setEnableTimeUntilArrivalPane(boolean enable) {
        this.timeUntilArrivalLabel.setEnabled(enable);
        this.solsTF.setEnabled(enable);
        this.solInfoLabel.setEnabled(enable);
    }

    private void updateTemplatePopulationNum(String templateName) {
        SettlementTemplate template;
        if (templateName != null && (template = SimulationConfig.instance().getSettlementConfiguration().getSettlementTemplate(templateName)) != null) {
            this.populationTF.setText(Integer.toString(template.getDefaultPopulation()));
        }
    }

    private boolean validateData() {
        String latitudeString;
        String populationNumString;
        String templateName;
        boolean result = true;
        String errorString = "";
        if (this.nameTF.getText().trim().isEmpty()) {
            result = false;
            errorString = "Settlement name cannot not be blank.";
        }
        if ((templateName = (String)this.templateCB.getSelectedItem()) == null || templateName.trim().isEmpty()) {
            result = false;
            errorString = "A settlement template must be selected.";
        }
        if ((populationNumString = this.populationTF.getText()).trim().isEmpty()) {
            result = false;
            errorString = "Population number cannot be blank. (0 is allowed)";
        } else {
            try {
                int popNum = Integer.parseInt(populationNumString);
                if (popNum < 0) {
                    result = false;
                    errorString = "Population number cannot be less than 0.";
                }
            }
            catch (NumberFormatException e) {
                result = false;
                errorString = "Population number must be a valid integer value.";
            }
        }
        if (this.solsTF.isEnabled()) {
            String timeArrivalString = this.solsTF.getText().trim();
            if (timeArrivalString.isEmpty()) {
                result = false;
                errorString = "Sols until arrival cannot be blank.";
            } else {
                try {
                    double timeArrival = Double.parseDouble(timeArrivalString);
                    if (timeArrival < 0.0) {
                        result = false;
                        errorString = "Sols until arrival cannot be less than 0.";
                    }
                }
                catch (NumberFormatException e) {
                    result = false;
                    errorString = "Sols until arrival must be a valid number.";
                }
            }
        }
        if ((latitudeString = this.latitudeTF.getText().trim()).isEmpty()) {
            result = false;
            errorString = "Latitude value cannot be blank.";
        } else {
            try {
                Double latitudeValue = Double.parseDouble(latitudeString);
                if (latitudeValue < 0.0 || latitudeValue > 90.0) {
                    result = false;
                    errorString = "Latitude value must be in the range of 0.0 to 90.0.";
                }
            }
            catch (NumberFormatException e) {
                result = false;
                errorString = "Latitude value must be a valid number. (0.0 - 90.0)";
            }
        }
        String longitudeString = this.longitudeTF.getText().trim();
        if (longitudeString.isEmpty()) {
            result = false;
            errorString = "Longitude value cannot be blank.";
        } else {
            try {
                Double longitudeValue = Double.parseDouble(longitudeString);
                if (longitudeValue < 0.0 || longitudeValue > 180.0) {
                    result = false;
                    errorString = "Longitude value must be in the range of 0.0 to 180.0.";
                }
            }
            catch (NumberFormatException e) {
                result = false;
                errorString = "Longitude value must be a valid number. (0.0 - 180.0)";
            }
        }
        if (result && !this.validateLandingLocation()) {
            result = false;
            errorString = "Landing location cannot be at an existing settlement's location.";
        }
        this.errorLabel.setText(errorString);
        return result;
    }

    private boolean validateLandingLocation() {
        boolean result = true;
        String fullLatString = this.latitudeTF.getText().trim() + " " + this.latitudeDirectionCB.getSelectedItem();
        String fullLonString = this.longitudeTF.getText().trim() + " " + this.longitudeDirectionCB.getSelectedItem();
        try {
            Coordinates landingLocation = new Coordinates(fullLatString, fullLonString);
            Iterator i = Simulation.instance().getUnitManager().getSettlements().iterator();
            while (i.hasNext()) {
                if (!((Settlement)i.next()).getCoordinates().equals((Object)landingLocation)) continue;
                result = false;
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.err);
            result = false;
        }
        return result;
    }

    @Override
    public boolean modifyTransportItem() {
        if (this.validateData()) {
            this.populateArrivingSettlement(this.settlement);
            this.settlement.commitModification();
            return true;
        }
        return false;
    }

    @Override
    public boolean createTransportItem() {
        if (this.validateData()) {
            String name = this.nameTF.getText().trim();
            String template = (String)this.templateCB.getSelectedItem();
            int popNum = Integer.parseInt(this.populationTF.getText());
            MarsClock arrivalDate = this.getArrivalDate();
            Coordinates landingLoc = this.getLandingLocation();
            ArrivingSettlement newArrivingSettlement = new ArrivingSettlement(name, template, arrivalDate, landingLoc, popNum);
            this.populateArrivingSettlement(newArrivingSettlement);
            Simulation.instance().getTransportManager().addNewTransportItem((Transportable)newArrivingSettlement);
            return true;
        }
        return false;
    }

    private void populateArrivingSettlement(ArrivingSettlement settlement) {
        settlement.setName(this.nameTF.getText().trim());
        settlement.setTemplate((String)this.templateCB.getSelectedItem());
        MarsClock arrivalDate = this.getArrivalDate();
        settlement.setArrivalDate(arrivalDate);
        MarsClock launchDate = (MarsClock)arrivalDate.clone();
        launchDate.addTime(-1.0 * (double)ResupplyUtil.AVG_TRANSIT_TIME * 1000.0);
        settlement.setLaunchDate(launchDate);
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        String state = "planned";
        if (MarsClock.getTimeDiff((MarsClock)currentTime, (MarsClock)launchDate) > 0.0) {
            state = "in transit";
            if (MarsClock.getTimeDiff((MarsClock)currentTime, (MarsClock)arrivalDate) > 0.0) {
                state = "arrived";
            }
        }
        settlement.setTransitState(state);
        int popNum = Integer.parseInt(this.populationTF.getText());
        settlement.setPopulationNum(popNum);
        Coordinates landingLocation = this.getLandingLocation();
        settlement.setLandingLocation(landingLocation);
    }

    private MarsClock getArrivalDate() {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        MarsClock result = (MarsClock)currentTime.clone();
        if (this.arrivalDateRB.isSelected()) {
            try {
                int sol = this.solCB.getSelectedIndex() + 1;
                int month = this.monthCB.getSelectedIndex() + 1;
                int orbit = Integer.parseInt((String)this.orbitCB.getSelectedItem());
                double millisols = 0.0;
                if (sol == currentTime.getSolOfMonth() && month == currentTime.getMonth() && orbit == currentTime.getOrbit()) {
                    millisols = currentTime.getMillisol();
                }
                result = new MarsClock(orbit, month, sol, millisols);
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
            }
        } else if (this.timeUntilArrivalRB.isSelected()) {
            try {
                int solsDiff = Integer.parseInt(this.solsTF.getText());
                if (solsDiff > 0) {
                    result.addTime((double)solsDiff * 1000.0);
                } else {
                    result.addTime(currentTime.getMillisol());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    private Coordinates getLandingLocation() {
        String fullLatString = this.latitudeTF.getText().trim() + " " + this.latitudeDirectionCB.getSelectedItem();
        String fullLonString = this.longitudeTF.getText().trim() + " " + this.longitudeDirectionCB.getSelectedItem();
        return new Coordinates(fullLatString, fullLonString);
    }
}

