/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.events.HistoricalEvent;
import org.mars_sim.msp.core.events.HistoricalEventListener;
import org.mars_sim.msp.core.interplanetary.transport.TransportManager;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;

public class IncomingListPanel
extends JPanel
implements ListSelectionListener {
    private JList incomingList;
    private IncomingListModel listModel;

    public IncomingListPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Incoming Transport Items"));
        this.setPreferredSize(new Dimension(225, 200));
        this.listModel = new IncomingListModel();
        this.incomingList = new JList(this.listModel);
        this.incomingList.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.incomingList);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPane, "Center");
    }

    JList getIncomingList() {
        return this.incomingList;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        JList arrivedList;
        if (evt.getValueIsAdjusting() && (arrivedList = (JList)evt.getSource()).getSelectedValue() != null) {
            this.incomingList.clearSelection();
        }
    }

    public void destroy() {
        this.listModel.destroy();
    }

    private class IncomingListModel
    extends AbstractListModel
    implements HistoricalEventListener {
        private List transportList;

        private IncomingListModel() {
            TransportManager manager = Simulation.instance().getTransportManager();
            this.transportList = manager.getIncomingTransportItems();
            Collections.sort(this.transportList);
            Simulation.instance().getEventManager().addListener((HistoricalEventListener)this);
        }

        @Override
        public Transportable getElementAt(int index) {
            Transportable result = null;
            if (index > -1 && index < this.transportList.size()) {
                result = (Transportable)this.transportList.get(index);
            }
            return result;
        }

        @Override
        public int getSize() {
            return this.transportList.size();
        }

        public void eventAdded(int index, HistoricalEvent event) {
            if (event.getCategory().equals("Transport")) {
                Transportable transportItem = (Transportable)event.getSource();
                if ("Transport Item Created".equals(event.getType())) {
                    if ("planned".equals(transportItem.getTransitState()) || "in transit".equals(transportItem.getTransitState())) {
                        this.transportList.add(transportItem);
                        Collections.sort(this.transportList);
                        int transportIndex = this.transportList.indexOf(transportItem);
                        this.fireIntervalAdded(this, transportIndex, transportIndex);
                    }
                } else if ("Transport Item Arrived".equals(event.getType()) || "Transport Item Canceled".equals(event.getType())) {
                    int transportIndex = this.transportList.indexOf(transportItem);
                    this.transportList.remove(transportItem);
                    this.fireIntervalRemoved(this, transportIndex, transportIndex);
                } else if ("Transport Item Modified".equals(event.getType()) && this.transportList.contains(transportItem)) {
                    Collections.sort(this.transportList);
                    this.fireContentsChanged(this, 0, this.transportList.size() - 1);
                }
            }
        }

        public void eventsRemoved(int startIndex, int endIndex) {
        }

        public void destroy() {
            this.transportList.clear();
            this.transportList = null;
            Simulation.instance().getEventManager().removeListener((HistoricalEventListener)this);
        }
    }
}

