/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;
import org.mars_sim.msp.core.interplanetary.transport.resupply.Resupply;
import org.mars_sim.msp.core.interplanetary.transport.settlement.ArrivingSettlement;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.resupply.ArrivingSettlementEditingPanel;
import org.mars_sim.msp.ui.swing.tool.resupply.ResupplyMissionEditingPanel;
import org.mars_sim.msp.ui.swing.tool.resupply.TransportItemEditingPanel;

public class ModifyTransportItemDialog
extends JDialog {
    private Transportable transportItem;
    private TransportItemEditingPanel editingPanel;

    public ModifyTransportItemDialog(JFrame owner, String title, Transportable transportItem) {
        super(owner, "Modify Transport Item", true);
        this.transportItem = transportItem;
        this.setLayout(new BorderLayout(0, 0));
        ((JComponent)this.getContentPane()).setBorder(new MarsPanelBorder());
        this.editingPanel = null;
        if (transportItem instanceof ArrivingSettlement) {
            this.editingPanel = new ArrivingSettlementEditingPanel((ArrivingSettlement)transportItem);
        } else if (transportItem instanceof Resupply) {
            this.editingPanel = new ResupplyMissionEditingPanel((Resupply)transportItem);
        } else {
            throw new IllegalStateException("Transport item: " + transportItem + " is not valid.");
        }
        this.getContentPane().add((Component)this.editingPanel, "Center");
        JPanel buttonPane = new JPanel(new FlowLayout(1, 10, 5));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton modifyButton = new JButton("Modify");
        modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyTransportItemDialog.this.modifyTransportItem();
            }
        });
        buttonPane.add(modifyButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModifyTransportItemDialog.this.dispose();
            }
        });
        buttonPane.add(cancelButton);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void modifyTransportItem() {
        if (this.editingPanel != null && this.editingPanel.modifyTransportItem()) {
            this.dispose();
        }
    }
}

