/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.events.HistoricalEvent;
import org.mars_sim.msp.core.events.HistoricalEventListener;
import org.mars_sim.msp.core.interplanetary.transport.resupply.Resupply;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.time.ClockListener;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;

public class ResupplyDetailPanel
extends JPanel
implements ClockListener,
HistoricalEventListener {
    private Resupply resupply = null;
    private JLabel destinationValueLabel;
    private JLabel stateValueLabel;
    private JLabel arrivalDateValueLabel;
    private JLabel timeArrivalValueLabel;
    private JLabel immigrantsValueLabel;
    private int solsToArrival = -1;
    private JPanel innerSupplyPane;

    public ResupplyDetailPanel() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(new MarsPanelBorder());
        JPanel infoPane = new JPanel(new BorderLayout());
        this.add((Component)infoPane, "North");
        JLabel titleLabel = new JLabel("Resupply Mission", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        titleLabel.setPreferredSize(new Dimension(-1, 25));
        infoPane.add((Component)titleLabel, "North");
        JPanel info2Pane = new JPanel(new GridLayout(5, 1, 5, 5));
        infoPane.add((Component)info2Pane, "Center");
        JPanel destinationPane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(destinationPane);
        JLabel destinationTitleLabel = new JLabel("Destination: ", 2);
        destinationPane.add(destinationTitleLabel);
        this.destinationValueLabel = new JLabel("", 2);
        destinationPane.add(this.destinationValueLabel);
        JPanel statePane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(statePane);
        JLabel stateTitleLabel = new JLabel("State: ", 2);
        statePane.add(stateTitleLabel);
        this.stateValueLabel = new JLabel("", 2);
        statePane.add(this.stateValueLabel);
        JPanel arrivalDatePane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(arrivalDatePane);
        JLabel arrivalDateTitleLabel = new JLabel("Arrival Date: ", 2);
        arrivalDatePane.add(arrivalDateTitleLabel);
        this.arrivalDateValueLabel = new JLabel("", 2);
        arrivalDatePane.add(this.arrivalDateValueLabel);
        JPanel timeArrivalPane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(timeArrivalPane);
        JLabel timeArrivalTitleLabel = new JLabel("Time Until Arrival: ", 2);
        timeArrivalPane.add(timeArrivalTitleLabel);
        this.timeArrivalValueLabel = new JLabel("", 2);
        timeArrivalPane.add(this.timeArrivalValueLabel);
        JPanel immigrantsPane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(immigrantsPane);
        JLabel immigrantsTitleLabel = new JLabel("Immigrants: ", 2);
        immigrantsPane.add(immigrantsTitleLabel);
        this.immigrantsValueLabel = new JLabel("", 2);
        immigrantsPane.add(this.immigrantsValueLabel);
        JPanel outerSupplyPane = new JPanel(new BorderLayout(0, 0));
        outerSupplyPane.setBorder(new TitledBorder("Supplies"));
        this.add((Component)outerSupplyPane, "Center");
        this.innerSupplyPane = new JPanel();
        this.innerSupplyPane.setLayout(new BoxLayout(this.innerSupplyPane, 1));
        outerSupplyPane.add((Component)new JScrollPane(this.innerSupplyPane), "Center");
        Simulation.instance().getMasterClock().addClockListener((ClockListener)this);
        Simulation.instance().getEventManager().addListener((HistoricalEventListener)this);
    }

    public void destroy() {
        this.resupply = null;
        Simulation.instance().getEventManager().removeListener((HistoricalEventListener)this);
        Simulation.instance().getMasterClock().removeClockListener((ClockListener)this);
    }

    public void setResupply(Resupply resupply) {
        if (this.resupply != resupply) {
            this.resupply = resupply;
            if (resupply == null) {
                this.clearInfo();
            } else {
                this.updateResupplyInfo();
            }
        }
    }

    private void clearInfo() {
        this.destinationValueLabel.setText("");
        this.stateValueLabel.setText("");
        this.arrivalDateValueLabel.setText("");
        this.timeArrivalValueLabel.setText("");
        this.immigrantsValueLabel.setText("");
        this.innerSupplyPane.removeAll();
    }

    private void updateResupplyInfo() {
        this.destinationValueLabel.setText(this.resupply.getSettlement().getName());
        this.stateValueLabel.setText(this.resupply.getTransitState());
        this.arrivalDateValueLabel.setText(this.resupply.getArrivalDate().getDateString());
        this.updateTimeToArrival();
        this.immigrantsValueLabel.setText(Integer.toString(this.resupply.getNewImmigrantNum()));
        this.updateSupplyPanel();
        this.validate();
    }

    private void updateSupplyPanel() {
        JPanel partsPanel;
        JPanel resourcesPanel;
        JPanel equipmentPanel;
        JPanel vehiclesPanel;
        this.innerSupplyPane.removeAll();
        JPanel buildingsPanel = this.createBuildingsDisplayPanel();
        if (buildingsPanel != null) {
            this.innerSupplyPane.add(buildingsPanel);
            this.innerSupplyPane.add(Box.createVerticalStrut(10));
        }
        if ((vehiclesPanel = this.createVehiclesDisplayPanel()) != null) {
            this.innerSupplyPane.add(vehiclesPanel);
            this.innerSupplyPane.add(Box.createVerticalStrut(10));
        }
        if ((equipmentPanel = this.createEquipmentDisplayPanel()) != null) {
            this.innerSupplyPane.add(equipmentPanel);
            this.innerSupplyPane.add(Box.createVerticalStrut(10));
        }
        if ((resourcesPanel = this.createResourcesDisplayPanel()) != null) {
            this.innerSupplyPane.add(resourcesPanel);
            this.innerSupplyPane.add(Box.createVerticalStrut(10));
        }
        if ((partsPanel = this.createPartsDisplayPanel()) != null) {
            this.innerSupplyPane.add(partsPanel);
        }
        this.innerSupplyPane.add(Box.createVerticalGlue());
    }

    private JPanel createBuildingsDisplayPanel() {
        JPanel buildingsPanel = null;
        List buildings = this.resupply.getNewBuildings();
        if (buildings.size() > 0) {
            buildingsPanel = new JPanel(new BorderLayout());
            JLabel buildingsLabel = new JLabel("Buildings", 0);
            buildingsPanel.add((Component)buildingsLabel, "North");
            HashMap<String, Integer> buildingMap = new HashMap<String, Integer>(buildings.size());
            for (String building : buildings) {
                if (buildingMap.containsKey(building)) {
                    int num = (Integer)buildingMap.get(building) + 1;
                    buildingMap.put(building, num);
                    continue;
                }
                buildingMap.put(building, 1);
            }
            DefaultTableModel tableModel = new DefaultTableModel();
            tableModel.addColumn("Building Type");
            tableModel.addColumn("Num");
            ArrayList buildingTypes = new ArrayList(buildingMap.keySet());
            Collections.sort(buildingTypes);
            for (String buildingName : buildingTypes) {
                int num = (Integer)buildingMap.get(buildingName);
                Vector<Object> rowData = new Vector<Object>(2);
                rowData.add(buildingName);
                rowData.add(num);
                tableModel.addRow(rowData);
            }
            JTable buildingTable = new JTable(tableModel);
            buildingTable.setCellSelectionEnabled(false);
            buildingTable.getColumnModel().getColumn(1).setMaxWidth(50);
            buildingTable.getColumnModel().getColumn(1).setCellRenderer(new NumberCellRenderer(0));
            buildingsPanel.add((Component)new JScrollPane(buildingTable), "Center");
            int panelHeight = buildingTable.getPreferredSize().height + buildingTable.getTableHeader().getPreferredSize().height + buildingsLabel.getPreferredSize().height + 7;
            buildingsPanel.setPreferredSize(new Dimension(100, panelHeight));
        }
        return buildingsPanel;
    }

    private JPanel createVehiclesDisplayPanel() {
        JPanel vehiclesPanel = null;
        List vehicles = this.resupply.getNewVehicles();
        if (vehicles.size() > 0) {
            vehiclesPanel = new JPanel(new BorderLayout());
            JLabel vehiclesLabel = new JLabel("Vehicles", 0);
            vehiclesPanel.add((Component)vehiclesLabel, "North");
            HashMap<String, Integer> vehicleMap = new HashMap<String, Integer>(vehicles.size());
            for (String vehicle : vehicles) {
                if (vehicleMap.containsKey(vehicle)) {
                    int num = (Integer)vehicleMap.get(vehicle) + 1;
                    vehicleMap.put(vehicle, num);
                    continue;
                }
                vehicleMap.put(vehicle, 1);
            }
            DefaultTableModel tableModel = new DefaultTableModel();
            tableModel.addColumn("Vehicle Type");
            tableModel.addColumn("Num");
            ArrayList vehicleTypes = new ArrayList(vehicleMap.keySet());
            Collections.sort(vehicleTypes);
            for (String vehicleName : vehicleTypes) {
                int num = (Integer)vehicleMap.get(vehicleName);
                Vector<Object> rowData = new Vector<Object>(2);
                rowData.add(vehicleName);
                rowData.add(num);
                tableModel.addRow(rowData);
            }
            JTable vehicleTable = new JTable(tableModel);
            vehicleTable.setCellSelectionEnabled(false);
            vehicleTable.getColumnModel().getColumn(1).setMaxWidth(50);
            vehicleTable.getColumnModel().getColumn(1).setCellRenderer(new NumberCellRenderer(0));
            vehiclesPanel.add((Component)new JScrollPane(vehicleTable), "Center");
            int panelHeight = vehicleTable.getPreferredSize().height + vehicleTable.getTableHeader().getPreferredSize().height + vehiclesLabel.getPreferredSize().height + 7;
            vehiclesPanel.setPreferredSize(new Dimension(100, panelHeight));
        }
        return vehiclesPanel;
    }

    private JPanel createEquipmentDisplayPanel() {
        JPanel equipmentPanel = null;
        Map equipment = this.resupply.getNewEquipment();
        if (equipment.size() > 0) {
            equipmentPanel = new JPanel(new BorderLayout());
            JLabel equipmentLabel = new JLabel("Equipment", 0);
            equipmentPanel.add((Component)equipmentLabel, "North");
            DefaultTableModel tableModel = new DefaultTableModel();
            tableModel.addColumn("Equipment Type");
            tableModel.addColumn("Num");
            ArrayList equipmentTypes = new ArrayList(equipment.keySet());
            Collections.sort(equipmentTypes);
            for (String equipmentType : equipmentTypes) {
                int num = (Integer)equipment.get(equipmentType);
                Vector<Object> rowData = new Vector<Object>(2);
                rowData.add(equipmentType);
                rowData.add(num);
                tableModel.addRow(rowData);
            }
            JTable equipmentTable = new JTable(tableModel);
            equipmentTable.setCellSelectionEnabled(false);
            equipmentTable.getColumnModel().getColumn(1).setMaxWidth(50);
            equipmentTable.getColumnModel().getColumn(1).setCellRenderer(new NumberCellRenderer(0));
            equipmentPanel.add((Component)new JScrollPane(equipmentTable), "Center");
            int panelHeight = equipmentTable.getPreferredSize().height + equipmentTable.getTableHeader().getPreferredSize().height + equipmentLabel.getPreferredSize().height + 7;
            equipmentPanel.setPreferredSize(new Dimension(100, panelHeight));
        }
        return equipmentPanel;
    }

    private JPanel createResourcesDisplayPanel() {
        JPanel resourcesPanel = null;
        Map resources = this.resupply.getNewResources();
        if (resources.size() > 0) {
            resourcesPanel = new JPanel(new BorderLayout());
            JLabel resourcesLabel = new JLabel("Resources", 0);
            resourcesPanel.add((Component)resourcesLabel, "North");
            DefaultTableModel tableModel = new DefaultTableModel();
            tableModel.addColumn("Resource Type");
            tableModel.addColumn("Amount");
            ArrayList resourceTypes = new ArrayList(resources.keySet());
            Collections.sort(resourceTypes);
            for (AmountResource resourceType : resourceTypes) {
                double amount = (Double)resources.get(resourceType);
                Vector<Object> rowData = new Vector<Object>(2);
                rowData.add(resourceType);
                rowData.add(amount);
                tableModel.addRow(rowData);
            }
            JTable resourcesTable = new JTable(tableModel);
            resourcesTable.setCellSelectionEnabled(false);
            resourcesTable.getColumnModel().getColumn(1).setMaxWidth(70);
            resourcesTable.getColumnModel().getColumn(1).setCellRenderer(new NumberCellRenderer(1));
            resourcesPanel.add((Component)new JScrollPane(resourcesTable), "Center");
            int panelHeight = resourcesTable.getPreferredSize().height + resourcesTable.getTableHeader().getPreferredSize().height + resourcesLabel.getPreferredSize().height + 7;
            resourcesPanel.setPreferredSize(new Dimension(100, panelHeight));
        }
        return resourcesPanel;
    }

    private JPanel createPartsDisplayPanel() {
        JPanel partsPanel = null;
        Map parts = this.resupply.getNewParts();
        if (parts.size() > 0) {
            partsPanel = new JPanel(new BorderLayout());
            JLabel partsLabel = new JLabel("Parts", 0);
            partsPanel.add((Component)partsLabel, "North");
            DefaultTableModel tableModel = new DefaultTableModel();
            tableModel.addColumn("Part Type");
            tableModel.addColumn("Num");
            ArrayList partTypes = new ArrayList(parts.keySet());
            Collections.sort(partTypes);
            for (Part partType : partTypes) {
                int num = (Integer)parts.get(partType);
                Vector<Object> rowData = new Vector<Object>(2);
                rowData.add(partType);
                rowData.add(num);
                tableModel.addRow(rowData);
            }
            JTable partsTable = new JTable(tableModel);
            partsTable.setCellSelectionEnabled(false);
            partsTable.getColumnModel().getColumn(1).setMaxWidth(50);
            partsTable.getColumnModel().getColumn(1).setCellRenderer(new NumberCellRenderer(0));
            partsPanel.add((Component)new JScrollPane(partsTable), "Center");
            int panelHeight = partsTable.getPreferredSize().height + partsTable.getTableHeader().getPreferredSize().height + partsLabel.getPreferredSize().height + 7;
            partsPanel.setPreferredSize(new Dimension(100, panelHeight));
        }
        return partsPanel;
    }

    private void updateTimeToArrival() {
        String timeArrival = "---";
        this.solsToArrival = -1;
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        double timeDiff = MarsClock.getTimeDiff((MarsClock)this.resupply.getArrivalDate(), (MarsClock)currentTime);
        if (timeDiff > 0.0) {
            this.solsToArrival = (int)Math.abs(timeDiff / 1000.0);
            timeArrival = Integer.toString(this.solsToArrival) + " Sols";
        }
        this.timeArrivalValueLabel.setText(timeArrival);
    }

    public void eventAdded(int index, HistoricalEvent event) {
        if ("Transport".equals(event.getCategory()) && "Transport Item Modified".equals(event.getType()) && this.resupply != null && event.getSource().equals(this.resupply)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ResupplyDetailPanel.this.resupply != null) {
                        ResupplyDetailPanel.this.updateResupplyInfo();
                    }
                }
            });
        }
    }

    public void eventsRemoved(int startIndex, int endIndex) {
    }

    public void clockPulse(double time) {
        if (this.resupply != null && this.solsToArrival >= 0) {
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            double timeDiff = MarsClock.getTimeDiff((MarsClock)this.resupply.getArrivalDate(), (MarsClock)currentTime);
            double newSolsToArrival = (int)Math.abs(timeDiff / 1000.0);
            if (newSolsToArrival != (double)this.solsToArrival) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ResupplyDetailPanel.this.resupply != null) {
                            ResupplyDetailPanel.this.updateTimeToArrival();
                        }
                    }
                });
            }
        }
    }

    public void pauseChange(boolean isPaused) {
    }
}

