/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;
import org.mars_sim.msp.core.interplanetary.transport.resupply.Resupply;
import org.mars_sim.msp.core.interplanetary.transport.resupply.ResupplyUtil;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.resupply.MartianSolComboBoxModel;
import org.mars_sim.msp.ui.swing.tool.resupply.SupplyTableModel;
import org.mars_sim.msp.ui.swing.tool.resupply.TransportItemEditingPanel;

public class ResupplyMissionEditingPanel
extends TransportItemEditingPanel {
    private Resupply resupply;
    private JComboBox destinationCB;
    private JRadioButton arrivalDateRB;
    private JLabel arrivalDateTitleLabel;
    private JRadioButton timeUntilArrivalRB;
    private JLabel timeUntilArrivalLabel;
    private MartianSolComboBoxModel martianSolCBModel;
    private JLabel solLabel;
    private JComboBox solCB;
    private JLabel monthLabel;
    private JComboBox monthCB;
    private JLabel orbitLabel;
    private JComboBox orbitCB;
    private JTextField solsTF;
    private JLabel solInfoLabel;
    private JTextField immigrantsTF;
    private SupplyTableModel supplyTableModel;
    private JTable supplyTable;
    private JButton removeSupplyButton;

    public ResupplyMissionEditingPanel(Resupply resupply) {
        super((Transportable)resupply);
        this.resupply = resupply;
        this.setBorder(new MarsPanelBorder());
        this.setLayout(new BorderLayout(0, 0));
        JPanel topEditPane = new JPanel(new BorderLayout(10, 10));
        this.add((Component)topEditPane, "North");
        JPanel destinationPane = new JPanel(new FlowLayout(0, 0, 0));
        topEditPane.add((Component)destinationPane, "North");
        JLabel destinationTitleLabel = new JLabel("Destination: ");
        destinationPane.add(destinationTitleLabel);
        Vector settlements = new Vector(Simulation.instance().getUnitManager().getSettlements());
        Collections.sort(settlements);
        this.destinationCB = new JComboBox(settlements);
        if (resupply != null) {
            this.destinationCB.setSelectedItem(resupply.getSettlement());
        }
        destinationPane.add(this.destinationCB);
        JPanel arrivalDatePane = new JPanel(new GridLayout(2, 1, 10, 10));
        arrivalDatePane.setBorder(new TitledBorder("Arrival Date"));
        topEditPane.add((Component)arrivalDatePane, "Center");
        ButtonGroup dateTypeRBGroup = new ButtonGroup();
        JPanel arrivalDateSelectionPane = new JPanel(new FlowLayout(0, 5, 0));
        arrivalDatePane.add(arrivalDateSelectionPane);
        this.arrivalDateRB = new JRadioButton();
        dateTypeRBGroup.add(this.arrivalDateRB);
        this.arrivalDateRB.setSelected(true);
        this.arrivalDateRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRadioButton rb = (JRadioButton)evt.getSource();
                ResupplyMissionEditingPanel.this.setEnableArrivalDatePane(rb.isSelected());
                ResupplyMissionEditingPanel.this.setEnableTimeUntilArrivalPane(!rb.isSelected());
            }
        });
        arrivalDateSelectionPane.add(this.arrivalDateRB);
        this.arrivalDateTitleLabel = new JLabel("Arrival Date:");
        arrivalDateSelectionPane.add(this.arrivalDateTitleLabel);
        MarsClock resupplyTime = Simulation.instance().getMasterClock().getMarsClock();
        if (resupply != null) {
            resupplyTime = resupply.getArrivalDate();
        }
        this.solLabel = new JLabel("Sol");
        arrivalDateSelectionPane.add(this.solLabel);
        this.martianSolCBModel = new MartianSolComboBoxModel(resupplyTime.getMonth(), resupplyTime.getOrbit());
        this.solCB = new JComboBox(this.martianSolCBModel);
        this.solCB.setSelectedItem(resupplyTime.getSolOfMonth());
        arrivalDateSelectionPane.add(this.solCB);
        this.monthLabel = new JLabel("Month");
        arrivalDateSelectionPane.add(this.monthLabel);
        this.monthCB = new JComboBox<String>(MarsClock.getMonthNames());
        this.monthCB.setSelectedItem(resupplyTime.getMonthName());
        this.monthCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResupplyMissionEditingPanel.this.martianSolCBModel.updateSolNumber(ResupplyMissionEditingPanel.this.monthCB.getSelectedIndex() + 1, Integer.parseInt((String)ResupplyMissionEditingPanel.this.orbitCB.getSelectedItem()));
            }
        });
        arrivalDateSelectionPane.add(this.monthCB);
        this.orbitLabel = new JLabel("Orbit");
        arrivalDateSelectionPane.add(this.orbitLabel);
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMinimumIntegerDigits(2);
        String[] orbitValues = new String[20];
        int startOrbit = resupplyTime.getOrbit();
        for (int x = 0; x < 20; ++x) {
            orbitValues[x] = formatter.format(startOrbit + x);
        }
        this.orbitCB = new JComboBox<String>(orbitValues);
        this.orbitCB.setSelectedItem(formatter.format(startOrbit));
        this.orbitCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResupplyMissionEditingPanel.this.martianSolCBModel.updateSolNumber(ResupplyMissionEditingPanel.this.monthCB.getSelectedIndex() + 1, Integer.parseInt((String)ResupplyMissionEditingPanel.this.orbitCB.getSelectedItem()));
            }
        });
        arrivalDateSelectionPane.add(this.orbitCB);
        JPanel timeUntilArrivalPane = new JPanel(new FlowLayout(0, 5, 0));
        arrivalDatePane.add(timeUntilArrivalPane);
        this.timeUntilArrivalRB = new JRadioButton();
        dateTypeRBGroup.add(this.timeUntilArrivalRB);
        this.timeUntilArrivalRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRadioButton rb = (JRadioButton)evt.getSource();
                ResupplyMissionEditingPanel.this.setEnableTimeUntilArrivalPane(rb.isSelected());
                ResupplyMissionEditingPanel.this.setEnableArrivalDatePane(!rb.isSelected());
            }
        });
        timeUntilArrivalPane.add(this.timeUntilArrivalRB);
        this.timeUntilArrivalLabel = new JLabel("Sols Until Arrival:");
        this.timeUntilArrivalLabel.setEnabled(false);
        timeUntilArrivalPane.add(this.timeUntilArrivalLabel);
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        int solsDiff = (int)Math.round(MarsClock.getTimeDiff((MarsClock)resupplyTime, (MarsClock)currentTime) / 1000.0);
        this.solsTF = new JTextField(6);
        this.solsTF.setText(Integer.toString(solsDiff));
        this.solsTF.setHorizontalAlignment(4);
        this.solsTF.setEnabled(false);
        timeUntilArrivalPane.add(this.solsTF);
        this.solInfoLabel = new JLabel("(668 Sols = 1 Martian Orbit)");
        this.solInfoLabel.setEnabled(false);
        timeUntilArrivalPane.add(this.solInfoLabel);
        JPanel immigrantsPane = new JPanel(new FlowLayout(0, 5, 0));
        topEditPane.add((Component)immigrantsPane, "South");
        JLabel immigrantsLabel = new JLabel("Number of Immigrants: ");
        immigrantsPane.add(immigrantsLabel);
        int immigrantsNum = 0;
        if (resupply != null) {
            immigrantsNum = resupply.getNewImmigrantNum();
        }
        this.immigrantsTF = new JTextField(6);
        this.immigrantsTF.setText(Integer.toString(immigrantsNum));
        this.immigrantsTF.setHorizontalAlignment(4);
        immigrantsPane.add(this.immigrantsTF);
        JPanel bottomEditPane = new JPanel(new BorderLayout(0, 0));
        bottomEditPane.setBorder(new TitledBorder("Supplies"));
        this.add((Component)bottomEditPane, "Center");
        this.supplyTableModel = new SupplyTableModel(resupply);
        this.supplyTable = new JTable(this.supplyTableModel);
        this.supplyTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.supplyTable.getColumnModel().getColumn(0).setCellEditor(new CategoryCellEditor());
        this.supplyTable.getColumnModel().getColumn(1).setMaxWidth(200);
        this.supplyTable.getColumnModel().getColumn(1).setCellEditor(new TypeCellEditor());
        this.supplyTable.getColumnModel().getColumn(2).setMaxWidth(150);
        this.supplyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    boolean hasSelection = ResupplyMissionEditingPanel.this.supplyTable.getSelectedRow() > -1;
                    ResupplyMissionEditingPanel.this.removeSupplyButton.setEnabled(hasSelection);
                }
            }
        });
        JScrollPane supplyScrollPane = new JScrollPane(this.supplyTable);
        supplyScrollPane.setPreferredSize(new Dimension(450, 200));
        bottomEditPane.add((Component)supplyScrollPane, "Center");
        JPanel supplyButtonPane = new JPanel(new FlowLayout(1, 10, 0));
        bottomEditPane.add((Component)supplyButtonPane, "South");
        JButton addSupplyButton = new JButton("Add");
        addSupplyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResupplyMissionEditingPanel.this.addNewSupplyRow();
            }
        });
        supplyButtonPane.add(addSupplyButton);
        this.removeSupplyButton = new JButton("Remove");
        this.removeSupplyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResupplyMissionEditingPanel.this.removeSelectedSupplyRows();
            }
        });
        this.removeSupplyButton.setEnabled(false);
        supplyButtonPane.add(this.removeSupplyButton);
    }

    private void setEnableArrivalDatePane(boolean enable) {
        this.arrivalDateTitleLabel.setEnabled(enable);
        this.solLabel.setEnabled(enable);
        this.solCB.setEnabled(enable);
        this.monthLabel.setEnabled(enable);
        this.monthCB.setEnabled(enable);
        this.orbitLabel.setEnabled(enable);
        this.orbitCB.setEnabled(enable);
    }

    private void setEnableTimeUntilArrivalPane(boolean enable) {
        this.timeUntilArrivalLabel.setEnabled(enable);
        this.solsTF.setEnabled(enable);
        this.solInfoLabel.setEnabled(enable);
    }

    private void addNewSupplyRow() {
        this.supplyTableModel.addNewSupplyItem();
        int index = this.supplyTable.getRowCount() - 1;
        this.supplyTable.setRowSelectionInterval(index, index);
        this.supplyTable.scrollRectToVisible(this.supplyTable.getCellRect(index, 0, true));
    }

    private void removeSelectedSupplyRows() {
        int[] removedIndexes = this.supplyTable.getSelectedRows();
        this.supplyTableModel.removeSupplyItems(removedIndexes);
    }

    @Override
    public boolean modifyTransportItem() {
        this.populateResupplyMission(this.resupply);
        this.resupply.commitModification();
        return true;
    }

    @Override
    public boolean createTransportItem() {
        Settlement destination = (Settlement)this.destinationCB.getSelectedItem();
        MarsClock arrivalDate = this.getArrivalDate();
        Resupply newResupply = new Resupply(arrivalDate, destination);
        this.populateResupplyMission(newResupply);
        Simulation.instance().getTransportManager().addNewTransportItem((Transportable)newResupply);
        return true;
    }

    private void populateResupplyMission(Resupply resupplyMission) {
        Settlement destination = (Settlement)this.destinationCB.getSelectedItem();
        resupplyMission.setSettlement(destination);
        MarsClock arrivalDate = this.getArrivalDate();
        resupplyMission.setArrivalDate(arrivalDate);
        MarsClock launchDate = (MarsClock)arrivalDate.clone();
        launchDate.addTime(-1.0 * (double)ResupplyUtil.AVG_TRANSIT_TIME * 1000.0);
        resupplyMission.setLaunchDate(launchDate);
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        String state = "planned";
        if (MarsClock.getTimeDiff((MarsClock)currentTime, (MarsClock)launchDate) > 0.0) {
            state = "in transit";
            if (MarsClock.getTimeDiff((MarsClock)currentTime, (MarsClock)arrivalDate) > 0.0) {
                state = "arrived";
            }
        }
        resupplyMission.setTransitState(state);
        int immigrantNum = 0;
        try {
            immigrantNum = Integer.parseInt(this.immigrantsTF.getText());
            if (immigrantNum < 0) {
                immigrantNum = 0;
            }
            resupplyMission.setNewImmigrantNum(immigrantNum);
        }
        catch (NumberFormatException e) {
            e.printStackTrace(System.err);
        }
        if (this.supplyTable.isEditing()) {
            this.supplyTable.getCellEditor().stopCellEditing();
        }
        List<SupplyTableModel.SupplyItem> supplyItems = this.supplyTableModel.getSupplyItems();
        ArrayList<String> newBuildings = new ArrayList<String>();
        for (SupplyTableModel.SupplyItem item : supplyItems) {
            if (!"Building".equals(item.category.trim())) continue;
            int num = item.number.intValue();
            for (int x = 0; x < num; ++x) {
                newBuildings.add(item.type.trim());
            }
        }
        resupplyMission.setNewBuildings(newBuildings);
        ArrayList<String> newVehicles = new ArrayList<String>();
        for (SupplyTableModel.SupplyItem item : supplyItems) {
            if (!"Vehicle".equals(item.category.trim())) continue;
            int num = item.number.intValue();
            for (int x = 0; x < num; ++x) {
                newVehicles.add(item.type.trim());
            }
        }
        resupplyMission.setNewVehicles(newVehicles);
        HashMap<String, Integer> newEquipment = new HashMap<String, Integer>();
        for (SupplyTableModel.SupplyItem item : supplyItems) {
            if (!"Equipment".equals(item.category.trim())) continue;
            String type = item.type.trim();
            int num = item.number.intValue();
            if (newEquipment.containsKey(type)) {
                num += ((Integer)newEquipment.get(type)).intValue();
            }
            newEquipment.put(type, num);
        }
        resupplyMission.setNewEquipment(newEquipment);
        HashMap<AmountResource, Double> newResources = new HashMap<AmountResource, Double>();
        for (SupplyTableModel.SupplyItem item : supplyItems) {
            if (!"Resource".equals(item.category.trim())) continue;
            String type = item.type.trim();
            AmountResource resource = AmountResource.findAmountResource((String)type);
            double amount = item.number.doubleValue();
            if (newResources.containsKey(resource)) {
                amount += ((Double)newResources.get(resource)).doubleValue();
            }
            newResources.put(resource, amount);
        }
        resupplyMission.setNewResources(newResources);
        HashMap<Part, Integer> newParts = new HashMap<Part, Integer>();
        for (SupplyTableModel.SupplyItem item : supplyItems) {
            if (!"Part".equals(item.category.trim())) continue;
            String type = item.type.trim();
            Part part = (Part)Part.findItemResource((String)type);
            int num = item.number.intValue();
            if (newParts.containsKey(part)) {
                num += ((Integer)newParts.get(part)).intValue();
            }
            newParts.put(part, num);
        }
        resupplyMission.setNewParts(newParts);
    }

    private MarsClock getArrivalDate() {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        MarsClock result = (MarsClock)currentTime.clone();
        if (this.arrivalDateRB.isSelected()) {
            try {
                int sol = this.solCB.getSelectedIndex() + 1;
                int month = this.monthCB.getSelectedIndex() + 1;
                int orbit = Integer.parseInt((String)this.orbitCB.getSelectedItem());
                double millisols = 0.0;
                if (sol == currentTime.getSolOfMonth() && month == currentTime.getMonth() && orbit == currentTime.getOrbit()) {
                    millisols = currentTime.getMillisol();
                }
                result = new MarsClock(orbit, month, sol, millisols);
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
            }
        } else if (this.timeUntilArrivalRB.isSelected()) {
            try {
                int solsDiff = Integer.parseInt(this.solsTF.getText());
                if (solsDiff > 0) {
                    result.addTime((double)solsDiff * 1000.0);
                } else {
                    result.addTime(currentTime.getMillisol());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    private class TypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Map<String, JComboBox> typeCBMap;
        private JComboBox currentCB;

        private TypeCellEditor() {
            Map<String, List<String>> categoryTypeMap = SupplyTableModel.getCategoryTypeMap();
            this.typeCBMap = new HashMap<String, JComboBox>(categoryTypeMap.keySet().size());
            for (String category : categoryTypeMap.keySet()) {
                JComboBox<String> categoryCB = new JComboBox<String>();
                List<String> types = categoryTypeMap.get(category);
                for (String type : types) {
                    categoryCB.addItem(type);
                }
                this.typeCBMap.put(category, categoryCB);
            }
        }

        @Override
        public Object getCellEditorValue() {
            Object result = null;
            if (this.currentCB != null) {
                result = this.currentCB.getSelectedItem();
            }
            return result;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String category = (String)table.getValueAt(row, 0);
            this.currentCB = this.typeCBMap.get(category);
            this.currentCB.setSelectedItem(table.getValueAt(row, column));
            return this.currentCB;
        }
    }

    private class CategoryCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JComboBox categoryCB = new JComboBox();
        private int editingRow;
        private String previousCategory;

        private CategoryCellEditor() {
            Iterator<String> i = SupplyTableModel.getCategoryList().iterator();
            while (i.hasNext()) {
                this.categoryCB.addItem(i.next());
            }
            this.categoryCB.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.categoryCB.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editingRow = row;
            this.previousCategory = (String)table.getValueAt(row, column);
            this.categoryCB.setSelectedItem(this.previousCategory);
            return this.categoryCB;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String category = (String)this.categoryCB.getSelectedItem();
            if (this.editingRow > -1 && !category.equals(this.previousCategory)) {
                ResupplyMissionEditingPanel.this.supplyTable.setValueAt(category, this.editingRow, 0);
                String defaultType = SupplyTableModel.getCategoryTypeMap().get(category).get(0);
                ResupplyMissionEditingPanel.this.supplyTable.setValueAt(defaultType, this.editingRow, 1);
            }
        }
    }
}

