/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.interplanetary.transport.resupply.Resupply;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;

public class SupplyTableModel
extends AbstractTableModel {
    public static final String BUILDING = "Building";
    public static final String VEHICLE = "Vehicle";
    public static final String EQUIPMENT = "Equipment";
    public static final String RESOURCE = "Resource";
    public static final String PART = "Part";
    private static List<String> categoryList;
    private static Map<String, List<String>> categoryTypeMap;
    private List<SupplyItem> supplyList = new ArrayList<SupplyItem>();

    public SupplyTableModel(Resupply resupply) {
        if (resupply != null) {
            this.populateSupplies(resupply);
        }
    }

    private void populateSupplies(Resupply resupply) {
        this.populateSupplyTypeList(BUILDING, resupply.getNewBuildings());
        this.populateSupplyTypeList(VEHICLE, resupply.getNewVehicles());
        ArrayList sortEquipment = new ArrayList(resupply.getNewEquipment().keySet());
        Collections.sort(sortEquipment);
        for (String equipmentType : sortEquipment) {
            int num = (Integer)resupply.getNewEquipment().get(equipmentType);
            SupplyItem supplyItem = new SupplyItem(EQUIPMENT, equipmentType, num);
            this.supplyList.add(supplyItem);
        }
        ArrayList sortResources = new ArrayList(resupply.getNewResources().keySet());
        Collections.sort(sortResources);
        for (AmountResource resource : sortResources) {
            double amount = (Double)resupply.getNewResources().get(resource);
            SupplyItem supplyItem = new SupplyItem(RESOURCE, resource.getName(), amount);
            this.supplyList.add(supplyItem);
        }
        ArrayList sortParts = new ArrayList(resupply.getNewParts().keySet());
        Collections.sort(sortParts);
        for (Part part : sortParts) {
            int num = (Integer)resupply.getNewParts().get(part);
            SupplyItem supplyItem = new SupplyItem(PART, part.getName(), num);
            this.supplyList.add(supplyItem);
        }
    }

    private void populateSupplyTypeList(String category, List<String> supplies) {
        HashMap<String, Integer> supplyMap = new HashMap<String, Integer>(supplies.size());
        for (String supplyType : supplies) {
            if (supplyMap.keySet().contains(supplyType)) {
                int num = (Integer)supplyMap.get(supplyType) + 1;
                supplyMap.put(supplyType, num);
                continue;
            }
            supplyMap.put(supplyType, 1);
        }
        ArrayList sortKeys = new ArrayList(supplyMap.keySet());
        Collections.sort(sortKeys);
        for (String supplyType : sortKeys) {
            int num = (Integer)supplyMap.get(supplyType);
            SupplyItem supplyItem = new SupplyItem(category, supplyType, num);
            this.supplyList.add(supplyItem);
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        if (column == 0 || column == 1) {
            result = String.class;
        } else if (column == 2) {
            result = Integer.class;
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = null;
        if (column == 0) {
            result = "Category";
        } else if (column == 1) {
            result = "Supply Type";
        } else if (column == 2) {
            result = "Number/Amount (kg)";
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.supplyList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        Object result = null;
        if (rowIndex < this.supplyList.size()) {
            SupplyItem item = this.supplyList.get(rowIndex);
            if (colIndex == 0) {
                result = item.category;
            } else if (colIndex == 1) {
                result = item.type;
            } else if (colIndex == 2) {
                result = item.number.intValue();
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row < this.supplyList.size()) {
            SupplyItem item = this.supplyList.get(row);
            if (col == 0) {
                item.category = (String)value;
            } else if (col == 1) {
                item.type = (String)value;
            } else if (col == 2) {
                try {
                    item.number = (Integer)value;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace(System.err);
                }
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    public void addNewSupplyItem() {
        String category = SupplyTableModel.getCategoryList().get(0);
        String type = SupplyTableModel.getCategoryTypeMap().get(category).get(0);
        int num = 1;
        this.supplyList.add(new SupplyItem(category, type, num));
        this.fireTableRowsInserted(this.supplyList.size() - 1, this.supplyList.size() - 1);
    }

    public void removeSupplyItems(int[] rows) {
        ArrayList<SupplyItem> items = new ArrayList<SupplyItem>(rows.length);
        for (int x = 0; x < rows.length; ++x) {
            items.add(this.supplyList.get(rows[x]));
        }
        this.supplyList.removeAll(items);
        this.fireTableDataChanged();
    }

    public List<SupplyItem> getSupplyItems() {
        return new ArrayList<SupplyItem>(this.supplyList);
    }

    public static List<String> getCategoryList() {
        if (categoryList == null) {
            categoryList = new ArrayList<String>(5);
            categoryList.add(BUILDING);
            categoryList.add(VEHICLE);
            categoryList.add(EQUIPMENT);
            categoryList.add(RESOURCE);
            categoryList.add(PART);
        }
        return categoryList;
    }

    public static Map<String, List<String>> getCategoryTypeMap() {
        if (categoryTypeMap == null) {
            categoryTypeMap = new HashMap<String, List<String>>(5);
            Set buildingTypes = SimulationConfig.instance().getBuildingConfiguration().getBuildingNames();
            ArrayList sortedBuildingTypes = new ArrayList(buildingTypes);
            Collections.sort(sortedBuildingTypes);
            categoryTypeMap.put(BUILDING, sortedBuildingTypes);
            Set vehicleTypes = SimulationConfig.instance().getVehicleConfiguration().getVehicleTypes();
            ArrayList sortedVehicleTypes = new ArrayList(vehicleTypes);
            Collections.sort(sortedVehicleTypes);
            categoryTypeMap.put(VEHICLE, sortedVehicleTypes);
            Set equipmentTypes = EquipmentFactory.getEquipmentNames();
            ArrayList sortedEquipmentTypes = new ArrayList(equipmentTypes);
            Collections.sort(sortedEquipmentTypes);
            categoryTypeMap.put(EQUIPMENT, sortedEquipmentTypes);
            ArrayList<String> resourceNames = new ArrayList<String>();
            Iterator i = AmountResource.getAmountResources().iterator();
            while (i.hasNext()) {
                resourceNames.add(((AmountResource)i.next()).getName());
            }
            Collections.sort(resourceNames);
            categoryTypeMap.put(RESOURCE, resourceNames);
            ArrayList<String> partNames = new ArrayList<String>();
            Iterator j = Part.getParts().iterator();
            while (j.hasNext()) {
                partNames.add(((Part)j.next()).getName());
            }
            Collections.sort(partNames);
            categoryTypeMap.put(PART, partNames);
        }
        return categoryTypeMap;
    }

    public class SupplyItem {
        public String category;
        public String type;
        public Number number;

        public SupplyItem(String category, String type, Number number) {
            this.category = category;
            this.type = type;
            this.number = number;
        }
    }
}

