/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.science;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.science.ScienceWindow;

public class OngoingStudyListPanel
extends JPanel {
    private ScienceWindow scienceWindow;
    private StudyTableModel studyTableModel;
    private JTable studyTable;
    private JScrollPane listScrollPane;

    OngoingStudyListPanel(ScienceWindow scienceWindow) {
        this.scienceWindow = scienceWindow;
        this.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel("Ongoing Scientific Studies", 0);
        this.add((Component)titleLabel, "North");
        this.listScrollPane = new JScrollPane();
        this.listScrollPane.setBorder(new MarsPanelBorder());
        this.listScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.listScrollPane, "Center");
        this.studyTableModel = new StudyTableModel();
        this.studyTable = new JTable(this.studyTableModel);
        this.studyTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.studyTable.setCellSelectionEnabled(false);
        this.studyTable.setRowSelectionAllowed(true);
        this.studyTable.setSelectionMode(0);
        this.studyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ScientificStudy selectedStudy;
                int row;
                if (event.getValueIsAdjusting() && (row = OngoingStudyListPanel.this.studyTable.getSelectedRow()) >= 0 && (selectedStudy = OngoingStudyListPanel.this.studyTableModel.getStudy(row)) != null) {
                    OngoingStudyListPanel.this.setSelectedScientificStudy(selectedStudy);
                }
            }
        });
        this.listScrollPane.setViewportView(this.studyTable);
    }

    void update() {
        this.studyTableModel.update();
        this.selectScientificStudy(this.scienceWindow.getScientificStudy(), false);
    }

    void setSelectedScientificStudy(ScientificStudy study) {
        this.scienceWindow.setScientificStudy(study);
    }

    void selectScientificStudy(ScientificStudy study, boolean scrollSelection) {
        int currentSelectedRow;
        int studyIndex = this.studyTableModel.getStudyIndex(study);
        if (studyIndex != (currentSelectedRow = this.studyTable.getSelectedRow())) {
            if (studyIndex >= 0) {
                this.studyTable.getSelectionModel().setSelectionInterval(studyIndex, studyIndex);
                if (scrollSelection) {
                    Rectangle cellRect = this.studyTable.getCellRect(studyIndex, 0, true);
                    this.listScrollPane.getViewport().setViewPosition(cellRect.getLocation());
                }
            } else {
                this.studyTable.clearSelection();
            }
        }
    }

    private static class StudyTableModel
    extends AbstractTableModel {
        private List<ScientificStudy> studies;

        private StudyTableModel() {
            ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
            this.studies = manager.getOngoingStudies();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            String result = "";
            if (column == 0) {
                result = "Study";
            } else if (column == 1) {
                result = "Phase";
            }
            return result;
        }

        @Override
        public int getRowCount() {
            return this.studies.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String result = "";
            if (rowIndex >= 0 && rowIndex < this.studies.size()) {
                ScientificStudy study = this.studies.get(rowIndex);
                if (columnIndex == 0) {
                    result = study.toString();
                } else if (columnIndex == 1) {
                    result = study.getPhase();
                }
            }
            return result;
        }

        private void update() {
            ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
            List newStudies = manager.getOngoingStudies();
            if (!this.studies.equals(newStudies)) {
                this.studies = newStudies;
            }
            this.fireTableDataChanged();
        }

        private ScientificStudy getStudy(int row) {
            ScientificStudy result = null;
            if (row >= 0 && row < this.studies.size()) {
                result = this.studies.get(row);
            }
            return result;
        }

        private int getStudyIndex(ScientificStudy study) {
            int result = -1;
            if (this.studies.contains(study)) {
                result = this.studies.indexOf(study);
            }
            return result;
        }
    }
}

