/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.science;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.science.ResearcherPanel;
import org.mars_sim.msp.ui.swing.tool.science.ScienceWindow;

public class StudyDetailPanel
extends JPanel {
    private JLabel scienceFieldLabel;
    private JLabel levelLabel;
    private JLabel statusLabel;
    private ResearcherPanel primaryResearcherPane;
    private ResearcherPanel[] collabResearcherPanes;
    private ScientificStudy study;

    StudyDetailPanel(ScienceWindow scienceWindow) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(425, -1));
        JLabel titleLabel = new JLabel("Study Details", 0);
        this.add((Component)titleLabel, "North");
        Box mainPane = Box.createVerticalBox();
        mainPane.setBorder(new MarsPanelBorder());
        this.add((Component)mainPane, "Center");
        JPanel infoPane = new JPanel(new GridLayout(3, 1, 0, 0));
        infoPane.setBorder(new MarsPanelBorder());
        infoPane.setAlignmentX(0.0f);
        mainPane.add(infoPane);
        this.scienceFieldLabel = new JLabel("Study Science: ", 2);
        infoPane.add(this.scienceFieldLabel);
        this.levelLabel = new JLabel("Difficulty Level: ", 2);
        infoPane.add(this.levelLabel);
        this.statusLabel = new JLabel("Status: ", 2);
        infoPane.add(this.statusLabel);
        this.primaryResearcherPane = new ResearcherPanel(scienceWindow);
        this.primaryResearcherPane.setAlignmentX(0.0f);
        mainPane.add(this.primaryResearcherPane);
        this.collabResearcherPanes = new ResearcherPanel[3];
        for (int x = 0; x < 3; ++x) {
            this.collabResearcherPanes[x] = new ResearcherPanel(scienceWindow);
            this.collabResearcherPanes[x].setAlignmentX(0.0f);
            mainPane.add(this.collabResearcherPanes[x]);
        }
        mainPane.add(Box.createVerticalGlue());
    }

    void update() {
        if (this.study != null) {
            this.statusLabel.setText("Status: " + this.getStatusString(this.study));
            Iterator i = this.study.getCollaborativeResearchers().keySet().iterator();
            int count = 0;
            while (i.hasNext()) {
                Person researcher = (Person)i.next();
                if (!researcher.equals(this.collabResearcherPanes[count].getStudyResearcher())) {
                    this.collabResearcherPanes[count].setStudyResearcher(this.study, researcher);
                }
                ++count;
            }
            for (int x = count; x < this.collabResearcherPanes.length; ++x) {
                if (this.collabResearcherPanes[x].getStudyResearcher() == null) continue;
                this.collabResearcherPanes[x].setStudyResearcher(null, null);
            }
            this.primaryResearcherPane.update();
            for (ResearcherPanel collabResearcherPane : this.collabResearcherPanes) {
                collabResearcherPane.update();
            }
        }
    }

    void displayScientificStudy(ScientificStudy study) {
        this.study = study;
        if (study != null) {
            this.scienceFieldLabel.setText("Study Science: " + study.getScience().getName());
            this.levelLabel.setText("Difficulty Level: " + study.getDifficultyLevel());
            this.statusLabel.setText("Status: " + this.getStatusString(study));
            this.primaryResearcherPane.setStudyResearcher(study, study.getPrimaryResearcher());
            Iterator i = study.getCollaborativeResearchers().keySet().iterator();
            int count = 0;
            while (i.hasNext()) {
                this.collabResearcherPanes[count].setStudyResearcher(study, (Person)i.next());
                ++count;
            }
            for (int x = count; x < this.collabResearcherPanes.length; ++x) {
                this.collabResearcherPanes[x].setStudyResearcher(null, null);
            }
        } else {
            this.clearLabels();
            this.clearResearcherPanels();
        }
    }

    private void clearLabels() {
        this.scienceFieldLabel.setText("Study Science: ");
        this.levelLabel.setText("Difficulty Level: ");
        this.statusLabel.setText("Status: ");
    }

    private void clearResearcherPanels() {
        this.primaryResearcherPane.setStudyResearcher(null, null);
        for (ResearcherPanel collabResearcherPane : this.collabResearcherPanes) {
            collabResearcherPane.setStudyResearcher(null, null);
        }
    }

    private String getStatusString(ScientificStudy study) {
        String result = "";
        if (study != null) {
            result = !study.isCompleted() ? study.getPhase() : study.getCompletionState();
        }
        return result;
    }
}

