/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.settlement;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.ClockListener;
import org.mars_sim.msp.ui.swing.tool.settlement.BackgroundTileMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.LabelMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.PersonMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.StructureMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.VehicleMapLayer;

public class SettlementMapPanel
extends JPanel
implements ClockListener {
    public static final double DEFAULT_SCALE = 5.0;
    public static final double MAX_SCALE = 55.0;
    public static final double MIN_SCALE = 0.45454545454545453;
    private static final Color MAP_BACKGROUND = new Color(181, 95, 0);
    private Settlement settlement = null;
    private double xPos = 0.0;
    private double yPos = 0.0;
    private double rotation = 0.0;
    private double scale = 5.0;
    private boolean showBuildingLabels = true;
    private boolean showConstructionLabels = true;
    private boolean showPersonLabels = true;
    private boolean showVehicleLabels = true;
    private List<SettlementMapLayer> mapLayers;
    private Map<Settlement, Person> selectedPerson = new HashMap<Settlement, Person>();

    public SettlementMapPanel() {
        this.mapLayers = new ArrayList<SettlementMapLayer>(5);
        this.mapLayers.add(new BackgroundTileMapLayer(this));
        this.mapLayers.add(new StructureMapLayer(this));
        this.mapLayers.add(new VehicleMapLayer(this));
        this.mapLayers.add(new PersonMapLayer(this));
        this.mapLayers.add(new LabelMapLayer(this));
        this.setPreferredSize(new Dimension(400, 400));
        this.setOpaque(true);
        this.setBackground(MAP_BACKGROUND);
        this.setForeground(Color.WHITE);
        Simulation.instance().getMasterClock().addClockListener((ClockListener)this);
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
        this.repaint();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.repaint();
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
        this.repaint();
    }

    public void reCenter() {
        this.xPos = 0.0;
        this.yPos = 0.0;
        this.setRotation(0.0);
        this.scale = 5.0;
        this.repaint();
    }

    public void moveCenter(double xDiff, double yDiff) {
        double realXDiff = Math.cos(this.rotation) * (xDiff /= this.scale) + Math.sin(this.rotation) * (yDiff /= this.scale);
        double realYDiff = Math.cos(this.rotation) * yDiff - Math.sin(this.rotation) * xDiff;
        this.xPos += realXDiff;
        this.yPos += realYDiff;
        this.repaint();
    }

    public void selectPersonAt(int xPixel, int yPixel) {
        Point2D.Double settlementPosition = this.convertToSettlementLocation(xPixel, yPixel);
        double range = 6.0 / this.scale;
        Person selectedPerson = null;
        for (Person person : PersonMapLayer.getPeopleToDisplay(this.settlement)) {
            double distanceY;
            double distanceX = person.getXLocation() - settlementPosition.getX();
            double distance = Math.hypot(distanceX, distanceY = person.getYLocation() - settlementPosition.getY());
            if (!(distance <= range)) continue;
            selectedPerson = person;
        }
        if (selectedPerson != null) {
            this.selectPerson(selectedPerson);
            this.repaint();
        }
    }

    public void selectPerson(Person person) {
        if (this.settlement != null && person != null) {
            Person currentlySelected = this.selectedPerson.get(this.settlement);
            if (person.equals(currentlySelected)) {
                this.selectedPerson.put(this.settlement, null);
            } else {
                this.selectedPerson.put(this.settlement, person);
            }
        }
    }

    public Person getSelectedPerson() {
        Person result = null;
        if (this.settlement != null) {
            result = this.selectedPerson.get(this.settlement);
        }
        return result;
    }

    public Point2D.Double convertToSettlementLocation(int xPixel, int yPixel) {
        Point2D.Double result = new Point2D.Double(0.0, 0.0);
        double xDiff1 = this.getWidth() / 2 - xPixel;
        double yDiff1 = this.getHeight() / 2 - yPixel;
        double xDiff2 = xDiff1 / this.scale;
        double yDiff2 = yDiff1 / this.scale;
        double xDiff3 = Math.cos(this.rotation) * xDiff2 + Math.sin(this.rotation) * yDiff2;
        double yDiff3 = Math.cos(this.rotation) * yDiff2 - Math.sin(this.rotation) * xDiff2;
        double newXPos = this.xPos + xDiff3;
        double newYPos = this.yPos + yDiff3;
        result.setLocation(newXPos, newYPos);
        return result;
    }

    public boolean isShowBuildingLabels() {
        return this.showBuildingLabels;
    }

    public void setShowBuildingLabels(boolean showLabels) {
        this.showBuildingLabels = showLabels;
        this.repaint();
    }

    public boolean isShowConstructionLabels() {
        return this.showConstructionLabels;
    }

    public void setShowConstructionLabels(boolean showLabels) {
        this.showConstructionLabels = showLabels;
        this.repaint();
    }

    public boolean isShowPersonLabels() {
        return this.showPersonLabels;
    }

    public void setShowPersonLabels(boolean showLabels) {
        this.showPersonLabels = showLabels;
        this.repaint();
    }

    public boolean isShowVehicleLabels() {
        return this.showVehicleLabels;
    }

    public void setShowVehicleLabels(boolean showLabels) {
        this.showVehicleLabels = showLabels;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Iterator<SettlementMapLayer> i = this.mapLayers.iterator();
        while (i.hasNext()) {
            i.next().displayLayer(g2d, this.settlement, this.xPos, this.yPos, this.getWidth(), this.getHeight(), this.rotation, this.scale);
        }
    }

    public void destroy() {
        Simulation.instance().getMasterClock().removeClockListener((ClockListener)this);
        Iterator<SettlementMapLayer> i = this.mapLayers.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
    }

    public void clockPulse(double time) {
        this.repaint();
    }

    public void pauseChange(boolean isPaused) {
    }
}

