/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.settlement;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapPanel;

public class SettlementWindow
extends ToolWindow {
    public static final String NAME = "Settlement Map Tool";
    private static final double ROTATION_CHANGE = 0.15707963267948966;
    private static final double ZOOM_CHANGE = 1.0;
    private JComboBox settlementListBox;
    private SettlementComboBoxModel settlementCBModel;
    private JLabel zoomLabel;
    private JSlider zoomSlider;
    private SettlementMapPanel mapPane;
    private int xLast;
    private int yLast;
    private JPopupMenu labelsMenu;

    public SettlementWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        this.setMaximizable(true);
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new MarsPanelBorder());
        this.setContentPane(mainPane);
        JPanel widgetPane = new JPanel();
        widgetPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPane.add((Component)widgetPane, "North");
        this.mapPane = new SettlementMapPanel();
        this.mapPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SettlementWindow.this.xLast = evt.getX();
                SettlementWindow.this.yLast = evt.getY();
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                SettlementWindow.this.mapPane.selectPersonAt(evt.getX(), evt.getY());
            }
        });
        this.mapPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                double xDiff = evt.getX() - SettlementWindow.this.xLast;
                double yDiff = evt.getY() - SettlementWindow.this.yLast;
                SettlementWindow.this.mapPane.moveCenter(xDiff, yDiff);
                SettlementWindow.this.xLast = evt.getX();
                SettlementWindow.this.yLast = evt.getY();
            }
        });
        mainPane.add((Component)this.mapPane, "Center");
        this.settlementCBModel = new SettlementComboBoxModel();
        this.settlementListBox = new JComboBox(this.settlementCBModel);
        this.settlementListBox.setToolTipText("Select settlement");
        this.settlementListBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Settlement settlement = (Settlement)event.getItem();
                SettlementWindow.this.mapPane.setSettlement(settlement);
            }
        });
        widgetPane.add(this.settlementListBox);
        if (this.settlementListBox.getModel().getSize() > 0) {
            this.settlementListBox.setSelectedIndex(0);
            this.mapPane.setSettlement((Settlement)this.settlementListBox.getSelectedItem());
        }
        JPanel zoomPane = new JPanel(new BorderLayout());
        this.zoomLabel = new JLabel("Zoom", 0);
        zoomPane.add((Component)this.zoomLabel, "North");
        this.zoomSlider = new JSlider(0, -10, 10, 0);
        this.zoomSlider.setMajorTickSpacing(5);
        this.zoomSlider.setMinorTickSpacing(1);
        this.zoomSlider.setPaintTicks(true);
        this.zoomSlider.setPaintLabels(true);
        this.zoomSlider.setToolTipText("Zoom view of settlement");
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                double defaultScale;
                int sliderValue = SettlementWindow.this.zoomSlider.getValue();
                double newScale = defaultScale = 5.0;
                if (sliderValue > 0) {
                    newScale += defaultScale * (double)sliderValue * 1.0;
                } else if (sliderValue < 0) {
                    newScale = defaultScale / (1.0 + (double)sliderValue * -1.0 * 1.0);
                }
                SettlementWindow.this.mapPane.setScale(newScale);
            }
        });
        zoomPane.add((Component)this.zoomSlider, "Center");
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                int numClicks = evt.getWheelRotation();
                if (numClicks > 0) {
                    if (SettlementWindow.this.zoomSlider.getValue() > SettlementWindow.this.zoomSlider.getMinimum()) {
                        SettlementWindow.this.zoomSlider.setValue(SettlementWindow.this.zoomSlider.getValue() - 1);
                    }
                } else if (numClicks < 0 && SettlementWindow.this.zoomSlider.getValue() < SettlementWindow.this.zoomSlider.getMaximum()) {
                    SettlementWindow.this.zoomSlider.setValue(SettlementWindow.this.zoomSlider.getValue() + 1);
                }
            }
        });
        widgetPane.add(zoomPane);
        JPanel buttonsPane = new JPanel();
        widgetPane.add(buttonsPane);
        JButton rotateClockwiseButton = new JButton(ImageLoader.getIcon("Clockwise"));
        rotateClockwiseButton.setToolTipText("Rotate map clockwise");
        rotateClockwiseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettlementWindow.this.mapPane.setRotation(SettlementWindow.this.mapPane.getRotation() + 0.15707963267948966);
            }
        });
        buttonsPane.add(rotateClockwiseButton);
        JButton rotateCounterClockwiseButton = new JButton(ImageLoader.getIcon("CounterClockwise"));
        rotateCounterClockwiseButton.setToolTipText("Rotate map counter-clockwise");
        rotateCounterClockwiseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettlementWindow.this.mapPane.setRotation(SettlementWindow.this.mapPane.getRotation() - 0.15707963267948966);
            }
        });
        buttonsPane.add(rotateCounterClockwiseButton);
        JButton recenterButton = new JButton("Recenter");
        recenterButton.setToolTipText("Recenter view to center, normal zoom");
        recenterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettlementWindow.this.mapPane.reCenter();
                SettlementWindow.this.zoomSlider.setValue(0);
            }
        });
        buttonsPane.add(recenterButton);
        JButton labelsButton = new JButton("Labels");
        labelsButton.setToolTipText("Add/remove label overlays");
        labelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JButton button = (JButton)evt.getSource();
                if (SettlementWindow.this.labelsMenu == null) {
                    SettlementWindow.this.labelsMenu = SettlementWindow.this.createLabelsMenu();
                }
                SettlementWindow.this.labelsMenu.show(button, 0, button.getHeight());
            }
        });
        buttonsPane.add(labelsButton);
        JButton openInfoButton = new JButton("Open Info");
        openInfoButton.setToolTipText("Opens the Settlement Info Window");
        openInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settlement settlement = SettlementWindow.this.mapPane.getSettlement();
                if (settlement != null) {
                    SettlementWindow.this.getDesktop().openUnitWindow((Unit)settlement, false);
                }
            }
        });
        buttonsPane.add(openInfoButton);
        this.pack();
    }

    private JPopupMenu createLabelsMenu() {
        JPopupMenu result = new JPopupMenu("Label Display Options:");
        JCheckBoxMenuItem buildingLabelMenuItem = new JCheckBoxMenuItem("Buildings", this.getMapPanel().isShowBuildingLabels());
        buildingLabelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettlementWindow.this.getMapPanel().setShowBuildingLabels(!SettlementWindow.this.getMapPanel().isShowBuildingLabels());
            }
        });
        result.add(buildingLabelMenuItem);
        JCheckBoxMenuItem constructionLabelMenuItem = new JCheckBoxMenuItem("Construction Sites", this.getMapPanel().isShowConstructionLabels());
        constructionLabelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettlementWindow.this.getMapPanel().setShowConstructionLabels(!SettlementWindow.this.getMapPanel().isShowConstructionLabels());
            }
        });
        result.add(constructionLabelMenuItem);
        JCheckBoxMenuItem vehicleLabelMenuItem = new JCheckBoxMenuItem("Vehicles", this.getMapPanel().isShowVehicleLabels());
        vehicleLabelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettlementWindow.this.getMapPanel().setShowVehicleLabels(!SettlementWindow.this.getMapPanel().isShowVehicleLabels());
            }
        });
        result.add(vehicleLabelMenuItem);
        JCheckBoxMenuItem personLabelMenuItem = new JCheckBoxMenuItem("People", this.getMapPanel().isShowPersonLabels());
        personLabelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettlementWindow.this.getMapPanel().setShowPersonLabels(!SettlementWindow.this.getMapPanel().isShowPersonLabels());
            }
        });
        result.add(personLabelMenuItem);
        result.pack();
        return result;
    }

    private SettlementMapPanel getMapPanel() {
        return this.mapPane;
    }

    private MainDesktopPane getDesktop() {
        return this.desktop;
    }

    @Override
    public void destroy() {
        this.settlementCBModel.destroy();
        this.mapPane.destroy();
    }

    private class SettlementComboBoxModel
    extends DefaultComboBoxModel
    implements UnitManagerListener {
        public SettlementComboBoxModel() {
            this.updateSettlements();
            UnitManager unitManager = Simulation.instance().getUnitManager();
            unitManager.addUnitManagerListener((UnitManagerListener)this);
        }

        private void updateSettlements() {
            Settlement selectedSettlement = (Settlement)this.getSelectedItem();
            this.removeAllElements();
            UnitManager unitManager = Simulation.instance().getUnitManager();
            ArrayList settlements = new ArrayList(unitManager.getSettlements());
            Collections.sort(settlements);
            Iterator i = settlements.iterator();
            while (i.hasNext()) {
                this.addElement(i.next());
            }
            if (selectedSettlement != null) {
                this.setSelectedItem(selectedSettlement);
            }
        }

        public void unitManagerUpdate(UnitManagerEvent event) {
            if (event.getUnit() instanceof Settlement) {
                this.updateSettlements();
            }
        }

        public void destroy() {
            this.removeAllElements();
            UnitManager unitManager = Simulation.instance().getUnitManager();
            unitManager.removeUnitManagerListener((UnitManagerListener)this);
        }
    }
}

