/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.settlement;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.gvt.GraphicsNode;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.ui.swing.tool.settlement.SVGMapUtil;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapPanel;

public class StructureMapLayer
implements SettlementMapLayer {
    private static final Color BUILDING_COLOR = Color.GREEN;
    private static final Color CONSTRUCTION_SITE_COLOR = Color.BLACK;
    private SettlementMapPanel mapPanel;
    private Map<Double, Map<GraphicsNode, BufferedImage>> svgImageCache;
    private double scale;

    public StructureMapLayer(SettlementMapPanel mapPanel) {
        this.mapPanel = mapPanel;
        this.svgImageCache = new HashMap<Double, Map<GraphicsNode, BufferedImage>>(21);
        System.setProperty("org.apache.batik.warn_destination", "false");
    }

    @Override
    public void displayLayer(Graphics2D g2d, Settlement settlement, double xPos, double yPos, int mapWidth, int mapHeight, double rotation, double scale) {
        this.scale = scale;
        AffineTransform saveTransform = g2d.getTransform();
        double mapCenterX = (double)mapWidth / 2.0;
        double mapCenterY = (double)mapHeight / 2.0;
        g2d.translate(mapCenterX + xPos * scale, mapCenterY + yPos * scale);
        g2d.rotate(rotation, 0.0 - xPos * scale, 0.0 - yPos * scale);
        this.drawBuildings(g2d, settlement);
        this.drawConstructionSites(g2d, settlement);
        g2d.setTransform(saveTransform);
    }

    private void drawBuildings(Graphics2D g2d, Settlement settlement) {
        if (settlement != null) {
            Iterator i = settlement.getBuildingManager().getBuildings().iterator();
            while (i.hasNext()) {
                this.drawBuilding((Building)i.next(), g2d);
            }
        }
    }

    private void drawBuilding(Building building, Graphics2D g2d) {
        GraphicsNode svg = SVGMapUtil.getBuildingSVG(building.getName().toLowerCase());
        if (svg != null) {
            this.drawSVGStructure(g2d, building.getXLocation(), building.getYLocation(), building.getWidth(), building.getLength(), building.getFacing(), svg);
        } else {
            this.drawRectangleStructure(g2d, building.getXLocation(), building.getYLocation(), building.getWidth(), building.getLength(), building.getFacing(), BUILDING_COLOR);
        }
    }

    private void drawConstructionSites(Graphics2D g2d, Settlement settlement) {
        if (settlement != null) {
            Iterator i = settlement.getConstructionManager().getConstructionSites().iterator();
            while (i.hasNext()) {
                this.drawConstructionSite((ConstructionSite)i.next(), g2d);
            }
        }
    }

    private void drawConstructionSite(ConstructionSite site, Graphics2D g2d) {
        GraphicsNode svg = null;
        ConstructionStage stage = site.getCurrentConstructionStage();
        if (stage != null) {
            svg = SVGMapUtil.getConstructionSiteSVG(stage.getInfo().getName().toLowerCase());
        }
        if (svg != null) {
            this.drawSVGStructure(g2d, site.getXLocation(), site.getYLocation(), site.getWidth(), site.getLength(), site.getFacing(), svg);
        } else {
            this.drawRectangleStructure(g2d, site.getXLocation(), site.getYLocation(), site.getWidth(), site.getLength(), site.getFacing(), CONSTRUCTION_SITE_COLOR);
        }
    }

    private void drawSVGStructure(Graphics2D g2d, double xLoc, double yLoc, double width, double length, double facing, GraphicsNode svg) {
        this.drawStructure(true, g2d, xLoc, yLoc, width, length, facing, svg, null);
    }

    private void drawRectangleStructure(Graphics2D g2d, double xLoc, double yLoc, double width, double length, double facing, Color color) {
        this.drawStructure(false, g2d, xLoc, yLoc, width, length, facing, null, color);
    }

    private void drawStructure(boolean isSVG, Graphics2D g2d, double xLoc, double yLoc, double width, double length, double facing, GraphicsNode svg, Color color) {
        AffineTransform saveTransform = g2d.getTransform();
        Rectangle2D bounds = null;
        bounds = isSVG ? svg.getBounds() : new Rectangle2D.Double(0.0, 0.0, width, length);
        double scalingWidth = width / bounds.getWidth() * this.scale;
        double scalingLength = length / bounds.getHeight() * this.scale;
        double boundsPosX = bounds.getX() * scalingWidth;
        double boundsPosY = bounds.getY() * scalingLength;
        double centerX = width * this.scale / 2.0;
        double centerY = length * this.scale / 2.0;
        double translationX = -1.0 * xLoc * this.scale - centerX - boundsPosX;
        double translationY = -1.0 * yLoc * this.scale - centerY - boundsPosY;
        double facingRadian = facing / 180.0 * Math.PI;
        AffineTransform newTransform = new AffineTransform();
        newTransform.translate(translationX, translationY);
        newTransform.rotate(facingRadian, centerX + boundsPosX, centerY + boundsPosY);
        if (isSVG) {
            BufferedImage image = this.getBufferedImage(svg, width, length);
            if (image != null) {
                g2d.transform(newTransform);
                g2d.drawImage((Image)image, 0, 0, this.mapPanel);
            }
        } else {
            newTransform.scale(scalingWidth, scalingLength);
            g2d.transform(newTransform);
            g2d.setColor(color);
            g2d.fill(bounds);
        }
        g2d.setTransform(saveTransform);
    }

    private BufferedImage getBufferedImage(GraphicsNode svg, double width, double length) {
        Map<Object, Object> imageCache = null;
        if (this.svgImageCache.containsKey(this.scale)) {
            imageCache = this.svgImageCache.get(this.scale);
        } else {
            imageCache = new HashMap(100);
            this.svgImageCache.put(this.scale, imageCache);
        }
        BufferedImage image = null;
        if (imageCache.containsKey(svg)) {
            image = (BufferedImage)imageCache.get(svg);
        } else {
            image = this.createBufferedImage(svg, width, length);
            imageCache.put(svg, image);
        }
        return image;
    }

    private BufferedImage createBufferedImage(GraphicsNode svg, double width, double length) {
        int imageLength;
        int imageWidth = (int)(width * this.scale);
        if (imageWidth <= 0) {
            imageWidth = 1;
        }
        if ((imageLength = (int)(length * this.scale)) <= 0) {
            imageLength = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageLength, 2);
        Rectangle2D bounds = svg.getBounds();
        double scalingWidth = width / bounds.getWidth() * this.scale;
        double scalingLength = length / bounds.getHeight() * this.scale;
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        svg.setTransform(AffineTransform.getScaleInstance(scalingWidth, scalingLength));
        svg.paint(g2d);
        g2d.dispose();
        return bufferedImage;
    }

    @Override
    public void destroy() {
        Iterator<Map<GraphicsNode, BufferedImage>> i = this.svgImageCache.values().iterator();
        while (i.hasNext()) {
            i.next().clear();
        }
        this.svgImageCache.clear();
    }
}

