/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class InventoryTabPanel
extends TabPanel
implements ListSelectionListener {
    private ResourceTableModel resourceTableModel;
    private EquipmentTableModel equipmentTableModel;
    private JTable equipmentTable;

    public InventoryTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Inventory", null, "Inventory", unit, desktop);
        Inventory inv = unit.getInventory();
        JPanel inventoryLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(inventoryLabelPanel);
        JLabel inventoryLabel = new JLabel("Inventory", 0);
        inventoryLabelPanel.add(inventoryLabel);
        JPanel inventoryContentPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.centerContentPanel.add((Component)inventoryContentPanel, "Center");
        JScrollPane resourcesPanel = new JScrollPane();
        resourcesPanel.setBorder(new MarsPanelBorder());
        inventoryContentPanel.add(resourcesPanel);
        this.resourceTableModel = new ResourceTableModel(inv);
        JTable resourcesTable = new JTable(this.resourceTableModel);
        resourcesTable.setPreferredScrollableViewportSize(new Dimension(200, 75));
        resourcesTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        resourcesTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        resourcesTable.setCellSelectionEnabled(false);
        resourcesTable.setDefaultRenderer(Double.class, new NumberCellRenderer(1));
        resourcesPanel.setViewportView(resourcesTable);
        JScrollPane equipmentPanel = new JScrollPane();
        equipmentPanel.setBorder(new MarsPanelBorder());
        inventoryContentPanel.add(equipmentPanel);
        this.equipmentTableModel = new EquipmentTableModel(inv);
        this.equipmentTable = new JTable(this.equipmentTableModel);
        this.equipmentTable.setPreferredScrollableViewportSize(new Dimension(200, 75));
        this.equipmentTable.setCellSelectionEnabled(true);
        this.equipmentTable.setSelectionMode(0);
        this.equipmentTable.getSelectionModel().addListSelectionListener(this);
        equipmentPanel.setViewportView(this.equipmentTable);
    }

    @Override
    public void update() {
        this.resourceTableModel.update();
        this.equipmentTableModel.update();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.equipmentTable.getSelectedRow();
        Object selectedEquipment = this.equipmentTable.getValueAt(index, 0);
        if (selectedEquipment != null && selectedEquipment instanceof Equipment) {
            this.desktop.openUnitWindow((Unit)((Equipment)selectedEquipment), false);
        }
    }

    private static class EquipmentTableModel
    extends AbstractTableModel {
        Inventory inventory;
        List<Unit> equipment;

        private EquipmentTableModel(Inventory inventory) {
            this.inventory = inventory;
            Collection equipmentCol = inventory.findAllUnitsOfClass(Equipment.class);
            this.equipment = new ArrayList<Unit>(equipmentCol);
            Collections.sort(this.equipment);
        }

        @Override
        public int getRowCount() {
            return this.equipment.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<?> dataType = super.getColumnClass(columnIndex);
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Equipment";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= 0 && row < this.equipment.size()) {
                return this.equipment.get(row);
            }
            return "unknown";
        }

        public void update() {
            ArrayList<Unit> newEquipment = new ArrayList<Unit>(this.inventory.findAllUnitsOfClass(Equipment.class));
            Collections.sort(newEquipment);
            if (!this.equipment.equals(newEquipment)) {
                this.equipment = newEquipment;
                this.fireTableDataChanged();
            }
        }
    }

    private static class ResourceTableModel
    extends AbstractTableModel {
        private Inventory inventory;
        private Map<Resource, Number> resources;
        private List<Resource> keys;
        private DecimalFormat decFormatter = new DecimalFormat("0.0");

        private ResourceTableModel(Inventory inventory) {
            this.inventory = inventory;
            this.keys = new ArrayList<Resource>();
            this.resources = new HashMap<Resource, Number>();
            this.keys.addAll(inventory.getAllAmountResourcesStored(false));
            for (AmountResource amountResource : this.keys) {
                this.resources.put((Resource)amountResource, inventory.getAmountResourceStored(amountResource, true));
            }
            Set set = inventory.getAllItemResourcesStored();
            this.keys.addAll(set);
            for (ItemResource resource : set) {
                this.resources.put((Resource)resource, inventory.getItemResourceNum(resource));
            }
            Collections.sort(this.keys);
        }

        @Override
        public int getRowCount() {
            return this.keys.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 1) {
                dataType = Double.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Resource";
            }
            if (columnIndex == 1) {
                return "# or Mass (kg)";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.keys.get(row);
            }
            if (column == 1) {
                Resource resource = this.keys.get(row);
                String result = this.resources.get(resource).toString();
                if (resource instanceof AmountResource) {
                    double amount = (Double)this.resources.get(resource);
                    result = this.decFormatter.format(amount);
                }
                return result;
            }
            return "unknown";
        }

        public void update() {
            try {
                ArrayList<Resource> newResourceKeys = new ArrayList<Resource>();
                newResourceKeys.addAll(this.inventory.getAllAmountResourcesStored(true));
                HashMap<Resource, Number> newResources = new HashMap<Resource, Number>();
                for (AmountResource amountResource : newResourceKeys) {
                    newResources.put((Resource)amountResource, this.inventory.getAmountResourceStored(amountResource, true));
                }
                Set set = this.inventory.getAllItemResourcesStored();
                newResourceKeys.addAll(set);
                for (ItemResource resource : set) {
                    newResources.put((Resource)resource, this.inventory.getItemResourceNum(resource));
                }
                Collections.sort(newResourceKeys);
                if (!this.resources.equals(newResources)) {
                    this.resources = newResources;
                    this.keys = newResourceKeys;
                    this.fireTableDataChanged();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

