/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class LocationTabPanel
extends TabPanel
implements ActionListener {
    private JLabel latitudeLabel;
    private JLabel longitudeLabel;
    private Coordinates locationCache;
    private JButton centerMapButton;
    private JPanel locationLabelPanel;
    private JButton locationButton;
    private JLabel locationTextLabel;

    public LocationTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Location", null, "Location", unit, desktop);
        JPanel locationPanel = new JPanel(new BorderLayout());
        locationPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(locationPanel);
        this.locationLabelPanel = new JPanel(new FlowLayout(0));
        locationPanel.add((Component)this.locationLabelPanel, "North");
        this.centerMapButton = new JButton(ImageLoader.getIcon("CenterMap"));
        this.centerMapButton.setMargin(new Insets(1, 1, 1, 1));
        this.centerMapButton.addActionListener(this);
        this.centerMapButton.setToolTipText("Locate in Mars Navigator");
        this.locationLabelPanel.add(this.centerMapButton);
        JLabel locationLabel = new JLabel("Location: ", 0);
        this.locationLabelPanel.add(locationLabel);
        this.locationButton = new JButton();
        this.locationButton.addActionListener(this);
        this.locationTextLabel = new JLabel("", 2);
        Unit container = unit.getContainerUnit();
        if (container != null) {
            this.locationButton.setText(container.getName());
            this.addLocationButton();
        } else {
            Person person;
            this.locationTextLabel.setText("Outside");
            if (unit instanceof Person && (person = (Person)unit).getLocationSituation().equals("Buried")) {
                this.locationTextLabel.setText("Buried Outside");
            }
            this.addLocationTextLabel();
        }
        JPanel locationCoordsPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        locationPanel.add((Component)locationCoordsPanel, "Center");
        this.locationCache = new Coordinates(unit.getCoordinates());
        this.latitudeLabel = new JLabel("Latitude: " + this.locationCache.getFormattedLatitudeString(), 2);
        locationCoordsPanel.add(this.latitudeLabel);
        this.longitudeLabel = new JLabel("Longitude: " + this.locationCache.getFormattedLongitudeString(), 2);
        locationCoordsPanel.add(this.longitudeLabel);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JComponent source = (JComponent)event.getSource();
        if (source == this.centerMapButton) {
            this.desktop.centerMapGlobe(this.unit.getCoordinates());
        }
        if (source == this.locationButton) {
            this.desktop.openUnitWindow(this.unit.getContainerUnit(), false);
        }
    }

    @Override
    public void update() {
        Unit container;
        if (!this.locationCache.equals((Object)this.unit.getCoordinates())) {
            this.locationCache.setCoords(this.unit.getCoordinates());
            this.latitudeLabel.setText("Latitude: " + this.locationCache.getFormattedLatitudeString());
            this.longitudeLabel.setText("Longitude: " + this.locationCache.getFormattedLongitudeString());
        }
        if ((container = this.unit.getContainerUnit()) != null) {
            this.locationButton.setText(container.getName());
            this.addLocationButton();
        } else {
            Person person;
            this.locationTextLabel.setText("Outside");
            if (this.unit instanceof Person && (person = (Person)this.unit).getLocationSituation().equals("Buried")) {
                this.locationTextLabel.setText("Buried Outside");
            }
            this.addLocationTextLabel();
        }
    }

    private void addLocationButton() {
        try {
            Component lastComponent = this.locationLabelPanel.getComponent(2);
            if (lastComponent == this.locationTextLabel) {
                this.locationLabelPanel.remove(this.locationTextLabel);
                this.locationLabelPanel.add(this.locationButton);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.locationLabelPanel.add(this.locationButton);
        }
    }

    private void addLocationTextLabel() {
        try {
            Component lastComponent = this.locationLabelPanel.getComponent(2);
            if (lastComponent == this.locationButton) {
                this.locationLabelPanel.remove(this.locationButton);
                this.locationLabelPanel.add(this.locationTextLabel);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.locationLabelPanel.add(this.locationTextLabel);
        }
    }
}

