/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.MalfunctionPanel;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class MaintenanceTabPanel
extends TabPanel {
    private JLabel wearConditionLabel;
    private int wearConditionCache;
    private JLabel lastCompletedLabel;
    private BoundedRangeModel progressBarModel;
    private int lastCompletedTime;
    private JLabel partsLabel;
    private Collection<MalfunctionPanel> malfunctionPanels;
    private Collection<Malfunction> malfunctionCache;
    private JPanel malfunctionListPanel;

    public MaintenanceTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Maint", null, "Maintenance", unit, desktop);
        Malfunctionable malfunctionable = (Malfunctionable)unit;
        MalfunctionManager manager = malfunctionable.getMalfunctionManager();
        JPanel maintenancePanel = new JPanel(new GridLayout(5, 1, 0, 0));
        maintenancePanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(maintenancePanel);
        JLabel maintenanceLabel = new JLabel("Maintenance", 0);
        maintenancePanel.add(maintenanceLabel);
        this.wearConditionCache = (int)Math.round(manager.getWearCondition());
        this.wearConditionLabel = new JLabel("Wear Condition: " + this.wearConditionCache + "%", 0);
        this.wearConditionLabel.setToolTipText("The wear & tear condition: 100% = new; 0% = worn out");
        maintenancePanel.add(this.wearConditionLabel);
        this.lastCompletedTime = (int)(manager.getTimeSinceLastMaintenance() / 1000.0);
        this.lastCompletedLabel = new JLabel("Last Completed: " + this.lastCompletedTime + " sols", 0);
        maintenancePanel.add(this.lastCompletedLabel);
        JPanel progressPanel = new JPanel(new FlowLayout(1, 0, 0));
        maintenancePanel.add(progressPanel);
        this.partsLabel = new JLabel(this.getPartsString(), 0);
        this.partsLabel.setPreferredSize(new Dimension(-1, -1));
        maintenancePanel.add(this.partsLabel);
        JProgressBar progressBar = new JProgressBar();
        this.progressBarModel = progressBar.getModel();
        progressBar.setStringPainted(true);
        progressPanel.add(progressBar);
        double completed = manager.getMaintenanceWorkTimeCompleted();
        double total = manager.getMaintenanceWorkTime();
        int percentDone = (int)(100.0 * (completed / total));
        this.progressBarModel.setValue(percentDone);
        JPanel malfunctionPanel = new JPanel(new BorderLayout(0, 0));
        malfunctionPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add((Component)malfunctionPanel, "Center");
        JLabel malfunctionsLabel = new JLabel("Malfunctions", 0);
        malfunctionPanel.add((Component)malfunctionsLabel, "North");
        JScrollPane malfunctionScrollPanel = new JScrollPane();
        malfunctionScrollPanel.setPreferredSize(new Dimension(170, 90));
        malfunctionPanel.add((Component)malfunctionScrollPanel, "Center");
        JPanel malfunctionListMainPanel = new JPanel(new BorderLayout(0, 0));
        malfunctionScrollPanel.setViewportView(malfunctionListMainPanel);
        this.malfunctionListPanel = new JPanel();
        this.malfunctionListPanel.setLayout(new BoxLayout(this.malfunctionListPanel, 1));
        malfunctionListMainPanel.add((Component)this.malfunctionListPanel, "North");
        this.malfunctionCache = malfunctionable.getMalfunctionManager().getMalfunctions();
        this.malfunctionPanels = new ArrayList<MalfunctionPanel>();
        Iterator<Malfunction> i = this.malfunctionCache.iterator();
        while (i.hasNext()) {
            MalfunctionPanel panel = new MalfunctionPanel(i.next());
            this.malfunctionListPanel.add(panel);
            this.malfunctionPanels.add(panel);
        }
    }

    @Override
    public void update() {
        int lastComplete;
        Malfunctionable malfunctionable = (Malfunctionable)this.unit;
        MalfunctionManager manager = malfunctionable.getMalfunctionManager();
        int wearCondition = (int)Math.round(manager.getWearCondition());
        if (wearCondition != this.wearConditionCache) {
            this.wearConditionCache = wearCondition;
            this.wearConditionLabel.setText("Wear Condition: " + wearCondition + "%");
        }
        if ((lastComplete = (int)(manager.getTimeSinceLastMaintenance() / 1000.0)) != this.lastCompletedTime) {
            this.lastCompletedTime = lastComplete;
            this.lastCompletedLabel.setText("Last Completed: " + this.lastCompletedTime + " sols");
        }
        double completed = manager.getMaintenanceWorkTimeCompleted();
        double total = manager.getMaintenanceWorkTime();
        int percentDone = (int)(100.0 * (completed / total));
        this.progressBarModel.setValue(percentDone);
        this.partsLabel.setText(this.getPartsString());
        List malfunctions = manager.getMalfunctions();
        if (!this.malfunctionCache.equals(malfunctions)) {
            for (Malfunction malfunction : malfunctions) {
                if (this.malfunctionCache.contains(malfunction)) continue;
                MalfunctionPanel panel = new MalfunctionPanel(malfunction);
                this.malfunctionPanels.add(panel);
                this.malfunctionListPanel.add(panel);
            }
            for (Malfunction malfunction : this.malfunctionCache) {
                MalfunctionPanel panel;
                if (malfunctions.contains(malfunction) || (panel = this.getMalfunctionPanel(malfunction)) == null) continue;
                this.malfunctionPanels.remove(panel);
                this.malfunctionListPanel.remove(panel);
            }
            this.malfunctionCache = malfunctions;
        }
        Iterator<MalfunctionPanel> i = this.malfunctionPanels.iterator();
        while (i.hasNext()) {
            i.next().update();
        }
    }

    private String getPartsString() {
        Malfunctionable malfunctionable = (Malfunctionable)this.unit;
        StringBuilder buf = new StringBuilder("Parts: ");
        Map parts = malfunctionable.getMalfunctionManager().getMaintenanceParts();
        if (parts.size() > 0) {
            Iterator i = parts.keySet().iterator();
            while (i.hasNext()) {
                Part part = (Part)i.next();
                int number = (Integer)parts.get(part);
                buf.append(number).append(" ").append(part.getName());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
        } else {
            buf.append("none");
        }
        return buf.toString();
    }

    private MalfunctionPanel getMalfunctionPanel(Malfunction malfunction) {
        MalfunctionPanel result = null;
        for (MalfunctionPanel panel : this.malfunctionPanels) {
            if (panel.getMalfunction() != malfunction) continue;
            result = panel;
        }
        return result;
    }
}

