/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.manufacture.Salvagable;
import org.mars_sim.msp.core.manufacture.SalvageInfo;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class SalvageTabPanel
extends TabPanel {
    private String finishTimeString;
    private JLabel finishTimeLabel;
    private PartTableModel partTableModel;

    public SalvageTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Salvage", null, "Salvage Info", unit, desktop);
        Salvagable salvageItem = (Salvagable)unit;
        SalvageInfo salvageInfo = salvageItem.getSalvageInfo();
        JPanel salvageHeaderPanel = new JPanel(new FlowLayout(1, 0, 10));
        this.topContentPanel.add(salvageHeaderPanel);
        JLabel salvageHeaderLabel = new JLabel(unit.getName() + " has been salvaged.", 0);
        salvageHeaderPanel.add(salvageHeaderLabel);
        JPanel salvageInfoPanel = new JPanel(new BorderLayout(0, 0));
        this.topContentPanel.add(salvageInfoPanel);
        JPanel timePanel = new JPanel(new GridLayout(2, 1, 0, 0));
        salvageInfoPanel.add((Component)timePanel, "North");
        String startTimeString = salvageInfo.getStartTime().getTimeStamp();
        JLabel startTimeLabel = new JLabel("Start Time: " + startTimeString, 2);
        timePanel.add(startTimeLabel);
        MarsClock finishTime = salvageInfo.getFinishTime();
        this.finishTimeString = "";
        if (finishTime != null) {
            this.finishTimeString = finishTime.getTimeStamp();
        }
        this.finishTimeLabel = new JLabel("Finish Time: " + this.finishTimeString, 2);
        timePanel.add(this.finishTimeLabel);
        JPanel settlementPanel = new JPanel(new FlowLayout(0, 0, 0));
        salvageInfoPanel.add(settlementPanel);
        JLabel settlementLabel = new JLabel("Settlement: ");
        settlementPanel.add(settlementLabel);
        JButton settlementButton = new JButton(salvageInfo.getSettlement().getName());
        settlementButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SalvageInfo info = ((Salvagable)SalvageTabPanel.this.getUnit()).getSalvageInfo();
                SalvageTabPanel.this.getDesktop().openUnitWindow((Unit)info.getSettlement(), false);
            }
        });
        settlementPanel.add(settlementButton);
        JPanel partsPanel = new JPanel(new BorderLayout(0, 10));
        partsPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(partsPanel);
        JLabel partsLabel = new JLabel("Salvaged Parts", 0);
        partsPanel.add((Component)partsLabel, "North");
        JScrollPane partsTablePanel = new JScrollPane();
        partsPanel.add((Component)partsTablePanel, "Center");
        this.partTableModel = new PartTableModel(salvageInfo);
        JTable partsTable = new JTable(this.partTableModel);
        partsTable.setPreferredScrollableViewportSize(new Dimension(150, 75));
        partsTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        partsTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        partsTable.setCellSelectionEnabled(false);
        partsTable.setDefaultRenderer(Double.class, new NumberCellRenderer(1));
        partsTablePanel.setViewportView(partsTable);
    }

    @Override
    public void update() {
        SalvageInfo salvageInfo = ((Salvagable)this.unit).getSalvageInfo();
        MarsClock finishTime = salvageInfo.getFinishTime();
        String newFinishTimeString = "";
        if (finishTime != null) {
            newFinishTimeString = finishTime.getTimeStamp();
        }
        if (!this.finishTimeString.equals(newFinishTimeString)) {
            this.finishTimeString = newFinishTimeString;
            this.finishTimeLabel.setText("Finish Time: " + this.finishTimeString);
        }
        this.partTableModel.update();
    }

    private static class PartTableModel
    extends AbstractTableModel {
        private SalvageInfo salvageInfo;
        private Map<Part, Integer> parts;
        private List<Part> keys;

        private PartTableModel(SalvageInfo salvageInfo) {
            this.salvageInfo = salvageInfo;
            this.parts = new HashMap<Part, Integer>(salvageInfo.getPartsSalvaged());
            this.keys = new ArrayList<Part>(this.parts.keySet());
            Collections.sort(this.keys);
        }

        @Override
        public int getRowCount() {
            return this.keys.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 1) {
                dataType = Integer.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Part";
            }
            if (columnIndex == 1) {
                return "Number";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.keys.get(row);
            }
            if (column == 1) {
                return this.parts.get(this.keys.get(row));
            }
            return "unknown";
        }

        public void update() {
            if (!this.parts.equals(this.salvageInfo.getPartsSalvaged())) {
                this.parts.putAll(this.salvageInfo.getPartsSalvaged());
                this.keys.addAll(this.parts.keySet());
                Collections.sort(this.keys);
                this.fireTableDataChanged();
            }
        }
    }
}

