/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfo;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfoFactory;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public abstract class UnitWindow
extends JInternalFrame {
    protected MainDesktopPane desktop;
    protected Unit unit;
    private Collection<TabPanel> tabPanels;
    private JTabbedPane centerPanel;

    public UnitWindow(MainDesktopPane desktop, Unit unit, boolean displayDescription) {
        super(unit.getName(), false, true, false, true);
        this.desktop = desktop;
        this.unit = unit;
        this.tabPanels = new ArrayList<TabPanel>();
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPane);
        JPanel namePanel = new JPanel(new BorderLayout(0, 0));
        mainPane.add((Component)namePanel, "North");
        UnitDisplayInfo displayInfo = UnitDisplayInfoFactory.getUnitDisplayInfo(unit);
        JLabel nameLabel = new JLabel(unit.getName(), displayInfo.getButtonIcon(), 0);
        nameLabel.setVerticalTextPosition(3);
        nameLabel.setHorizontalTextPosition(0);
        namePanel.add((Component)nameLabel, "North");
        if (displayDescription) {
            JLabel descriptionLabel = new JLabel(unit.getDescription(), 0);
            namePanel.add((Component)descriptionLabel, "South");
        }
        this.centerPanel = new JTabbedPane();
        mainPane.add((Component)this.centerPanel, "Center");
    }

    protected final void addTabPanel(TabPanel panel) {
        if (!this.tabPanels.contains(panel)) {
            this.tabPanels.add(panel);
            this.centerPanel.addTab(panel.getTabTitle(), panel.getTabIcon(), panel, panel.getTabToolTip());
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void update() {
        Iterator<TabPanel> i = this.tabPanels.iterator();
        while (i.hasNext()) {
            i.next().update();
        }
    }

    public void destroy() {
    }
}

