/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class AttributeTabPanel
extends TabPanel {
    private AttributeTableModel attributeTableModel;

    public AttributeTabPanel(Person person, MainDesktopPane desktop) {
        super("Attributes", null, "Natural Attributes", (Unit)person, desktop);
        JPanel attributeLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(attributeLabelPanel);
        JLabel attributeLabel = new JLabel("Natural Attributes", 0);
        attributeLabelPanel.add(attributeLabel);
        JScrollPane attributeScrollPanel = new JScrollPane();
        attributeScrollPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add(attributeScrollPanel);
        this.attributeTableModel = new AttributeTableModel(person);
        JTable attributeTable = new JTable(this.attributeTableModel);
        attributeTable.setPreferredScrollableViewportSize(new Dimension(225, 100));
        attributeTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        attributeTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        attributeTable.setCellSelectionEnabled(false);
        attributeScrollPanel.setViewportView(attributeTable);
    }

    @Override
    public void update() {
    }

    private static class AttributeTableModel
    extends AbstractTableModel {
        NaturalAttributeManager manager;

        private AttributeTableModel(Person person) {
            this.manager = person.getNaturalAttributeManager();
        }

        @Override
        public int getRowCount() {
            return this.manager.getAttributeNum();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            }
            if (columnIndex == 1) {
                dataType = String.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Attribute";
            }
            if (columnIndex == 1) {
                return "Level";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String[] attributeNames = NaturalAttributeManager.getKeys();
            if (column == 0) {
                return attributeNames[row];
            }
            if (column == 1) {
                return this.getLevelString(this.manager.getAttribute(attributeNames[row]));
            }
            return "unknown";
        }

        public void update() {
        }

        public String getLevelString(int level) {
            String result = "";
            result = level < 5 ? "Terrible" : (level < 20 ? "Very Poor" : (level < 35 ? "Poor" : (level < 45 ? "Below Average" : (level < 55 ? "Average" : (level < 65 ? "Above Average" : (level < 80 ? "Good" : (level < 95 ? "Very Good" : "Exceptional")))))));
            return result;
        }
    }
}

