/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class GeneralTabPanel
extends TabPanel {
    public GeneralTabPanel(Unit unit, MainDesktopPane desktop) {
        super("General", null, "General Info", unit, desktop);
        Person person = (Person)unit;
        JPanel generalLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(generalLabelPanel);
        JLabel generalLabel = new JLabel("General Info", 0);
        generalLabelPanel.add(generalLabel);
        JPanel infoPanel = new JPanel(new GridLayout(5, 2, 0, 0));
        infoPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add((Component)infoPanel, "North");
        JLabel genderNameLabel = new JLabel("Gender", 2);
        infoPanel.add(genderNameLabel);
        String gender = person.getGender().substring(0, 1).toUpperCase() + person.getGender().substring(1);
        JLabel genderLabel = new JLabel(gender, 4);
        infoPanel.add(genderLabel);
        JLabel birthNameLabel = new JLabel("Birth Date", 2);
        infoPanel.add(birthNameLabel);
        String birthdate = person.getBirthDate();
        JLabel birthDateLabel = new JLabel(birthdate, 4);
        infoPanel.add(birthDateLabel);
        JLabel birthLocationNameLabel = new JLabel("Birth Location", 2);
        infoPanel.add(birthLocationNameLabel);
        String birthLocation = "Earth";
        JLabel birthLocationLabel = new JLabel(birthLocation, 4);
        infoPanel.add(birthLocationLabel);
        JLabel ageNameLabel = new JLabel("Age", 2);
        infoPanel.add(ageNameLabel);
        String age = Integer.toString(person.getAge());
        JLabel ageLabel = new JLabel(age, 4);
        infoPanel.add(ageLabel);
        JLabel personalityNameLabel = new JLabel("Personality (MBTI)", 2);
        infoPanel.add(personalityNameLabel);
        String personality = person.getMind().getPersonalityType().getTypeString();
        JLabel personalityLabel = new JLabel(personality, 4);
        infoPanel.add(personalityLabel);
    }

    @Override
    public void update() {
    }
}

