/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingPanel;

public class BuildingsTabPanel
extends TabPanel
implements ActionListener {
    private DefaultComboBoxModel buildingComboBoxModel;
    private JComboBox buildingComboBox;
    private List<Building> buildingsCache;
    private JPanel buildingDisplayPanel;
    private CardLayout buildingLayout;
    private List<BuildingPanel> buildingPanels;
    private int count;

    public BuildingsTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Buildings", null, "Settlement Buildings", unit, desktop);
        Settlement settlement = (Settlement)unit;
        List buildings = settlement.getBuildingManager().getBuildings();
        JPanel buildingSelectPanel = new JPanel(new FlowLayout(1));
        buildingSelectPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(buildingSelectPanel);
        this.buildingComboBoxModel = new DefaultComboBoxModel();
        this.buildingsCache = new ArrayList<Building>(buildings);
        Iterator<Building> i = this.buildingsCache.iterator();
        while (i.hasNext()) {
            this.buildingComboBoxModel.addElement(i.next());
        }
        this.buildingComboBox = new JComboBox(this.buildingComboBoxModel);
        this.buildingComboBox.addActionListener(this);
        this.buildingComboBox.setMaximumRowCount(10);
        buildingSelectPanel.add(this.buildingComboBox);
        this.buildingDisplayPanel = new JPanel();
        this.buildingLayout = new CardLayout();
        this.buildingDisplayPanel.setLayout(this.buildingLayout);
        this.buildingDisplayPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add(this.buildingDisplayPanel);
        this.buildingPanels = new ArrayList<BuildingPanel>();
        this.count = 0;
        Iterator iter = buildings.iterator();
        while (iter.hasNext()) {
            BuildingPanel panel = new BuildingPanel(String.valueOf(this.count), (Building)iter.next(), desktop);
            this.buildingPanels.add(panel);
            this.buildingDisplayPanel.add((Component)panel, panel.getPanelName());
            ++this.count;
        }
    }

    @Override
    public void update() {
        Settlement settlement = (Settlement)this.unit;
        List buildings = settlement.getBuildingManager().getBuildings();
        if (!this.buildingsCache.equals(buildings)) {
            for (Building building : buildings) {
                if (this.buildingsCache.contains(building)) continue;
                BuildingPanel panel = new BuildingPanel(String.valueOf(this.count), building, this.desktop);
                this.buildingPanels.add(panel);
                this.buildingDisplayPanel.add((Component)panel, panel.getPanelName());
                this.buildingComboBoxModel.addElement(building);
                ++this.count;
            }
            for (Building building : this.buildingsCache) {
                BuildingPanel panel;
                if (buildings.contains(building) || (panel = this.getBuildingPanel(building)) == null) continue;
                this.buildingPanels.remove(panel);
                this.buildingDisplayPanel.remove(panel);
                this.buildingComboBoxModel.removeElement(building);
            }
            this.buildingsCache = buildings;
        }
        Iterator<BuildingPanel> i = this.buildingPanels.iterator();
        while (i.hasNext()) {
            i.next().update();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Building building = (Building)this.buildingComboBox.getSelectedItem();
        BuildingPanel panel = this.getBuildingPanel(building);
        if (panel != null) {
            this.buildingLayout.show(this.buildingDisplayPanel, panel.getPanelName());
        } else {
            System.err.println("Couldn't find panel for " + building);
        }
    }

    private BuildingPanel getBuildingPanel(Building building) {
        BuildingPanel result = null;
        for (BuildingPanel panel : this.buildingPanels) {
            if (panel.getBuilding() != building) continue;
            result = panel;
        }
        return result;
    }
}

