/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.structure.construction.ConstructedBuildingLogEntry;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;

public class ConstructedBuildingsPanel
extends JPanel {
    private ConstructedBuildingTableModel constructedTableModel = null;

    public ConstructedBuildingsPanel(ConstructionManager manager) {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new MarsPanelBorder());
        JPanel titlePanel = new JPanel(new FlowLayout(1));
        this.add((Component)titlePanel, "North");
        JLabel titleLabel = new JLabel("Constructed Buildings");
        titlePanel.add(titleLabel);
        JScrollPane scrollPanel = new JScrollPane();
        scrollPanel.setPreferredSize(new Dimension(200, 75));
        scrollPanel.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPanel, "Center");
        JPanel outerTablePanel = new JPanel(new FlowLayout(1, 0, 0));
        outerTablePanel.setBorder(new MarsPanelBorder());
        scrollPanel.setViewportView(outerTablePanel);
        JPanel constructedTablePanel = new JPanel(new BorderLayout(0, 0));
        outerTablePanel.add(constructedTablePanel);
        this.constructedTableModel = new ConstructedBuildingTableModel(manager);
        JTable constructedTable = new JTable(this.constructedTableModel);
        constructedTable.setCellSelectionEnabled(false);
        constructedTable.getColumnModel().getColumn(0).setPreferredWidth(105);
        constructedTable.getColumnModel().getColumn(1).setPreferredWidth(105);
        constructedTablePanel.add((Component)constructedTable.getTableHeader(), "North");
        constructedTablePanel.add((Component)constructedTable, "Center");
    }

    public void update() {
        this.constructedTableModel.update();
    }

    private static class ConstructedBuildingTableModel
    extends AbstractTableModel {
        ConstructionManager manager;

        private ConstructedBuildingTableModel(ConstructionManager manager) {
            this.manager = manager;
        }

        @Override
        public int getRowCount() {
            return this.manager.getConstructedBuildingLog().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Building";
            }
            if (columnIndex == 1) {
                return "Time Stamp";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.getRowCount()) {
                ConstructedBuildingLogEntry logEntry = (ConstructedBuildingLogEntry)this.manager.getConstructedBuildingLog().get(row);
                if (column == 0) {
                    return logEntry.getBuildingName();
                }
                if (column == 1) {
                    return logEntry.getBuiltTime().toString();
                }
                return "unknown";
            }
            return "";
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }
}

