/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.CreditEvent;
import org.mars_sim.msp.core.structure.goods.CreditListener;
import org.mars_sim.msp.core.structure.goods.CreditManager;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class CreditTabPanel
extends TabPanel {
    public CreditTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Credit", null, "Trade Credit", unit, desktop);
        JPanel creditLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(creditLabelPanel);
        JLabel creditLabel = new JLabel("Trade Credit", 0);
        creditLabelPanel.add(creditLabel);
        JScrollPane creditScrollPanel = new JScrollPane();
        creditScrollPanel.setPreferredSize(new Dimension(220, 280));
        this.topContentPanel.add(creditScrollPanel);
        JPanel outerTablePanel = new JPanel(new FlowLayout(1));
        outerTablePanel.setBorder(new MarsPanelBorder());
        creditScrollPanel.setViewportView(outerTablePanel);
        JPanel creditTablePanel = new JPanel(new BorderLayout(0, 0));
        outerTablePanel.add(creditTablePanel);
        CreditTableModel creditTableModel = new CreditTableModel((Settlement)unit);
        JTable creditTable = new JTable(creditTableModel);
        creditTable.setCellSelectionEnabled(false);
        creditTable.setDefaultRenderer(Double.class, new NumberCellRenderer(2));
        creditTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        creditTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        creditTable.getColumnModel().getColumn(2).setPreferredWidth(40);
        creditTablePanel.add((Component)creditTable.getTableHeader(), "North");
        creditTablePanel.add((Component)creditTable, "Center");
    }

    @Override
    public void update() {
    }

    private static class CreditTableModel
    extends AbstractTableModel
    implements CreditListener,
    UnitManagerListener {
        CreditManager manager;
        Collection<Settlement> settlements;
        Settlement thisSettlement;

        private CreditTableModel(Settlement thisSettlement) {
            this.thisSettlement = thisSettlement;
            this.manager = Simulation.instance().getCreditManager();
            this.settlements = new ConcurrentLinkedQueue<Settlement>();
            for (Settlement settlement : CollectionUtils.sortByName((Collection)Simulation.instance().getUnitManager().getSettlements())) {
                if (settlement == thisSettlement) continue;
                this.settlements.add(settlement);
            }
            this.manager.addListener((CreditListener)this);
            Simulation.instance().getUnitManager().addUnitManagerListener((UnitManagerListener)this);
        }

        @Override
        public int getRowCount() {
            return this.settlements.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            } else if (columnIndex == 1) {
                dataType = Double.class;
            } else if (columnIndex == 2) {
                dataType = String.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Settlement";
            }
            if (columnIndex == 1) {
                return "VP";
            }
            if (columnIndex == 2) {
                return "Type";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.getRowCount()) {
                Settlement settlement = (Settlement)this.settlements.toArray()[row];
                if (column == 0) {
                    return settlement.getName();
                }
                double credit = 0.0;
                try {
                    credit = this.manager.getCredit(this.thisSettlement, settlement);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                if (column == 1) {
                    return Math.abs(credit);
                }
                if (column == 2) {
                    if (credit > 0.0) {
                        return "credit";
                    }
                    if (credit < 0.0) {
                        return "debt";
                    }
                    return "";
                }
                return "unknown";
            }
            return "";
        }

        public void creditUpdate(CreditEvent event) {
            if (this.thisSettlement == event.getSettlement1() || this.thisSettlement == event.getSettlement2()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CreditTableModel.this.fireTableDataChanged();
                    }
                });
            }
        }

        public void unitManagerUpdate(UnitManagerEvent event) {
            if (event.getUnit() instanceof Settlement) {
                this.settlements.clear();
                for (Settlement settlement : CollectionUtils.sortByName((Collection)Simulation.instance().getUnitManager().getSettlements())) {
                    if (settlement == this.thisSettlement) continue;
                    this.settlements.add(settlement);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CreditTableModel.this.fireTableDataChanged();
                    }
                });
            }
        }

        public void destroy() {
            this.manager.removeListener((CreditListener)this);
            this.settlements = null;
            this.thisSettlement = null;
        }
    }
}

