/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class GoodsTabPanel
extends TabPanel {
    private GoodsTableModel goodsTableModel;

    public GoodsTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Goods", null, "Trade Goods", unit, desktop);
        JPanel goodsLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(goodsLabelPanel);
        JLabel goodsLabel = new JLabel("Trade Goods", 0);
        goodsLabelPanel.add(goodsLabel);
        JScrollPane goodsScrollPanel = new JScrollPane();
        goodsScrollPanel.setPreferredSize(new Dimension(220, 280));
        this.topContentPanel.add(goodsScrollPanel);
        JPanel outerTablePanel = new JPanel(new FlowLayout(1));
        outerTablePanel.setBorder(new MarsPanelBorder());
        goodsScrollPanel.setViewportView(outerTablePanel);
        JPanel goodsTablePanel = new JPanel(new BorderLayout(0, 0));
        outerTablePanel.add(goodsTablePanel);
        this.goodsTableModel = new GoodsTableModel(((Settlement)unit).getGoodsManager());
        JTable goodsTable = new JTable(this.goodsTableModel);
        goodsTable.setCellSelectionEnabled(false);
        goodsTable.setDefaultRenderer(Double.class, new NumberCellRenderer(2));
        goodsTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        goodsTablePanel.add((Component)goodsTable.getTableHeader(), "North");
        goodsTablePanel.add((Component)goodsTable, "Center");
    }

    @Override
    public void update() {
        this.goodsTableModel.update();
    }

    private static class GoodsTableModel
    extends AbstractTableModel {
        GoodsManager manager;
        List goods;

        private GoodsTableModel(GoodsManager manager) {
            this.manager = manager;
            this.goods = GoodsUtil.getGoodsList();
        }

        @Override
        public int getRowCount() {
            return this.goods.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            } else if (columnIndex == 1) {
                dataType = Double.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Good";
            }
            if (columnIndex == 1) {
                return "Value Points";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.getRowCount()) {
                Good good = (Good)this.goods.get(row);
                if (column == 0) {
                    return good.getName();
                }
                if (column == 1) {
                    try {
                        return this.manager.getGoodValuePerItem(good);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        return "unknown";
                    }
                }
                return "unknown";
            }
            return "";
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }
}

