/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class MaintenanceTabPanel
extends TabPanel {
    private Settlement settlement;
    private List<Building> buildingsList;
    private JScrollPane maintenanceScrollPanel;
    private JPanel maintenanceListPanel;
    private List<Malfunction> malfunctionsList;
    private JScrollPane malfunctionsScrollPanel;
    private JPanel malfunctionsListPanel;

    public MaintenanceTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Maint", null, "Maintenance", unit, desktop);
        this.settlement = (Settlement)unit;
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        this.centerContentPanel.add(topPanel);
        JPanel maintenancePanel = new JPanel(new BorderLayout());
        topPanel.add(maintenancePanel);
        JLabel maintenanceLabel = new JLabel("Building Maintenance", 0);
        maintenancePanel.add((Component)maintenanceLabel, "North");
        this.maintenanceScrollPanel = new JScrollPane();
        this.maintenanceScrollPanel.setPreferredSize(new Dimension(200, 75));
        maintenancePanel.add((Component)this.maintenanceScrollPanel, "Center");
        this.maintenanceListPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        this.maintenanceListPanel.setBorder(new MarsPanelBorder());
        this.maintenanceScrollPanel.setViewportView(this.maintenanceListPanel);
        this.populateMaintenanceList();
        JPanel malfunctionsPanel = new JPanel(new BorderLayout());
        topPanel.add(malfunctionsPanel);
        JLabel malfunctionsLabel = new JLabel("Building Malfunctions", 0);
        malfunctionsPanel.add((Component)malfunctionsLabel, "North");
        this.malfunctionsScrollPanel = new JScrollPane();
        this.malfunctionsScrollPanel.setPreferredSize(new Dimension(200, 75));
        malfunctionsPanel.add((Component)this.malfunctionsScrollPanel, "Center");
        JPanel malfunctionsOuterListPanel = new JPanel(new BorderLayout(0, 0));
        malfunctionsOuterListPanel.setBorder(new MarsPanelBorder());
        this.malfunctionsScrollPanel.setViewportView(malfunctionsOuterListPanel);
        this.malfunctionsListPanel = new JPanel();
        this.malfunctionsListPanel.setLayout(new BoxLayout(this.malfunctionsListPanel, 1));
        malfunctionsOuterListPanel.add((Component)this.malfunctionsListPanel, "North");
        this.populateMalfunctionsList();
    }

    private void populateMaintenanceList() {
        this.maintenanceListPanel.removeAll();
        this.buildingsList = this.settlement.getBuildingManager().getBuildings();
        Iterator<Building> i = this.buildingsList.iterator();
        while (i.hasNext()) {
            BuildingMaintenancePanel panel = new BuildingMaintenancePanel(i.next());
            this.maintenanceListPanel.add(panel);
        }
    }

    private void populateMalfunctionsList() {
        this.malfunctionsListPanel.removeAll();
        if (this.malfunctionsList == null) {
            this.malfunctionsList = new ArrayList<Malfunction>();
        } else {
            this.malfunctionsList.clear();
        }
        for (Building building : this.settlement.getBuildingManager().getBuildings()) {
            for (Malfunction malfunction : building.getMalfunctionManager().getMalfunctions()) {
                this.malfunctionsList.add(malfunction);
                BuildingMalfunctionPanel panel = new BuildingMalfunctionPanel(malfunction, building);
                this.malfunctionsListPanel.add(panel);
            }
        }
    }

    @Override
    public void update() {
        List tempBuildings = ((Settlement)this.unit).getBuildingManager().getBuildings();
        if (!tempBuildings.equals(this.buildingsList)) {
            this.populateMaintenanceList();
            this.maintenanceScrollPanel.validate();
        } else {
            Component[] components;
            for (Component component : components = this.maintenanceListPanel.getComponents()) {
                ((BuildingMaintenancePanel)component).update();
            }
        }
        ArrayList tempMalfunctions = new ArrayList();
        Iterator i = tempBuildings.iterator();
        while (i.hasNext()) {
            Iterator j = ((Building)i.next()).getMalfunctionManager().getMalfunctions().iterator();
            while (j.hasNext()) {
                this.malfunctionsList.add((Malfunction)j.next());
            }
        }
        if (!tempMalfunctions.equals(this.malfunctionsList)) {
            this.populateMalfunctionsList();
            this.malfunctionsListPanel.validate();
            this.malfunctionsScrollPanel.validate();
        } else {
            Component[] components;
            for (Component component : components = this.malfunctionsListPanel.getComponents()) {
                ((BuildingMalfunctionPanel)component).update();
            }
        }
    }

    private String getPartsString(Map<Part, Integer> parts) {
        StringBuilder buf = new StringBuilder("Parts: ");
        if (parts.size() > 0) {
            Iterator<Part> i = parts.keySet().iterator();
            while (i.hasNext()) {
                Part part = i.next();
                int number = parts.get(part);
                buf.append(number).append(" ").append(part.getName());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
        } else {
            buf.append("none");
        }
        return buf.toString();
    }

    private class BuildingMalfunctionPanel
    extends JPanel {
        private Malfunction malfunction;
        private JLabel malfunctionLabel;
        private BoundedRangeModel progressBarModel;
        private JLabel partsLabel;

        BuildingMalfunctionPanel(Malfunction malfunction, Building building) {
            this.malfunction = malfunction;
            this.setLayout(new GridLayout(4, 1, 0, 0));
            this.setBorder(new MarsPanelBorder());
            JLabel buildingLabel = new JLabel(building.getName(), 2);
            this.add(buildingLabel);
            this.malfunctionLabel = new JLabel(malfunction.getName(), 2);
            if (malfunction.getCompletedEmergencyWorkTime() < malfunction.getEmergencyWorkTime()) {
                this.malfunctionLabel.setText(malfunction.getName() + " - Emergency");
                this.malfunctionLabel.setForeground(Color.red);
            }
            this.add(this.malfunctionLabel);
            JPanel progressBarPanel = new JPanel(new BorderLayout(0, 0));
            this.add((Component)progressBarPanel, "Center");
            JProgressBar progressBar = new JProgressBar();
            this.progressBarModel = progressBar.getModel();
            progressBar.setStringPainted(true);
            progressBarPanel.add((Component)progressBar, "Center");
            double totalRequiredWork = malfunction.getEmergencyWorkTime() + malfunction.getWorkTime() + malfunction.getEVAWorkTime();
            double totalCompletedWork = malfunction.getCompletedEmergencyWorkTime() + malfunction.getCompletedWorkTime() + malfunction.getCompletedEVAWorkTime();
            int percentComplete = 0;
            if (totalRequiredWork > 0.0) {
                percentComplete = (int)(100.0 * (totalCompletedWork / totalRequiredWork));
            }
            this.progressBarModel.setValue(percentComplete);
            this.partsLabel = new JLabel(MaintenanceTabPanel.this.getPartsString(malfunction.getRepairParts()), 0);
            this.partsLabel.setPreferredSize(new Dimension(-1, -1));
            this.add(this.partsLabel);
            this.setToolTipText(this.getToolTipString());
        }

        void update() {
            if (this.malfunction.getCompletedEmergencyWorkTime() < this.malfunction.getEmergencyWorkTime()) {
                this.malfunctionLabel.setText(this.malfunction.getName() + " - Emergency");
                this.malfunctionLabel.setForeground(Color.red);
            } else {
                this.malfunctionLabel.setText(this.malfunction.getName());
                this.malfunctionLabel.setForeground(Color.black);
            }
            double totalRequiredWork = this.malfunction.getEmergencyWorkTime() + this.malfunction.getWorkTime() + this.malfunction.getEVAWorkTime();
            double totalCompletedWork = this.malfunction.getCompletedEmergencyWorkTime() + this.malfunction.getCompletedWorkTime() + this.malfunction.getCompletedEVAWorkTime();
            int percentComplete = 0;
            if (totalRequiredWork > 0.0) {
                percentComplete = (int)(100.0 * (totalCompletedWork / totalRequiredWork));
            }
            this.progressBarModel.setValue(percentComplete);
            this.partsLabel.setText(MaintenanceTabPanel.this.getPartsString(this.malfunction.getRepairParts()));
            this.setToolTipText(this.getToolTipString());
        }

        private String getToolTipString() {
            StringBuilder result = new StringBuilder("<html>");
            result.append(this.malfunction.getName()).append("<br>");
            result.append("General repair time: ").append((int)this.malfunction.getWorkTime()).append(" millisols<br>");
            result.append("EVA repair time: ").append((int)this.malfunction.getEVAWorkTime()).append(" millisols<br>");
            result.append("Emergency repair time: ").append((int)this.malfunction.getEmergencyWorkTime()).append(" millisols<br>");
            result.append("Repair ").append(MaintenanceTabPanel.this.getPartsString(this.malfunction.getRepairParts()).toLowerCase());
            result.append("</html>");
            return result.toString();
        }
    }

    private class BuildingMaintenancePanel
    extends JPanel {
        private MalfunctionManager manager;
        private int lastCompletedCache;
        private BoundedRangeModel progressBarModel;
        private JLabel lastLabel;
        private JLabel partsLabel;

        BuildingMaintenancePanel(Building building) {
            this.manager = building.getMalfunctionManager();
            this.setLayout(new GridLayout(3, 1, 0, 0));
            this.setBorder(new MarsPanelBorder());
            JLabel buildingLabel = new JLabel(building.getName(), 2);
            this.add(buildingLabel);
            JPanel mainPanel = new JPanel(new BorderLayout(0, 0));
            this.add(mainPanel);
            this.lastCompletedCache = (int)(this.manager.getTimeSinceLastMaintenance() / 1000.0);
            this.lastLabel = new JLabel("Last Completed: " + this.lastCompletedCache + " sols", 2);
            mainPanel.add((Component)this.lastLabel, "West");
            JPanel progressBarPanel = new JPanel(new FlowLayout(1, 0, 0));
            mainPanel.add((Component)progressBarPanel, "Center");
            JProgressBar progressBar = new JProgressBar();
            this.progressBarModel = progressBar.getModel();
            progressBar.setStringPainted(true);
            progressBar.setPreferredSize(new Dimension(80, 15));
            progressBarPanel.add(progressBar);
            double completed = this.manager.getMaintenanceWorkTimeCompleted();
            double total = this.manager.getMaintenanceWorkTime();
            int percentDone = (int)(100.0 * (completed / total));
            this.progressBarModel.setValue(percentDone);
            this.partsLabel = new JLabel(MaintenanceTabPanel.this.getPartsString(this.manager.getMaintenanceParts()), 0);
            this.partsLabel.setPreferredSize(new Dimension(-1, -1));
            this.add(this.partsLabel);
            this.setToolTipText(this.getToolTipString());
        }

        void update() {
            double completed = this.manager.getMaintenanceWorkTimeCompleted();
            double total = this.manager.getMaintenanceWorkTime();
            int percentDone = (int)(100.0 * (completed / total));
            this.progressBarModel.setValue(percentDone);
            int lastCompleted = (int)(this.manager.getTimeSinceLastMaintenance() / 1000.0);
            if (lastCompleted != this.lastCompletedCache) {
                this.lastCompletedCache = lastCompleted;
                this.lastLabel.setText("Last Completed: " + this.lastCompletedCache + " sols");
            }
            this.partsLabel.setText(MaintenanceTabPanel.this.getPartsString(this.manager.getMaintenanceParts()));
            this.setToolTipText(this.getToolTipString());
        }

        private String getToolTipString() {
            StringBuilder result = new StringBuilder("<html>");
            int maintSols = (int)(this.manager.getTimeSinceLastMaintenance() / 1000.0);
            result.append("Last completed maintenance: ").append(maintSols).append(" sols<br>");
            result.append("Repair ").append(MaintenanceTabPanel.this.getPartsString(this.manager.getMaintenanceParts()).toLowerCase());
            result.append("</html>");
            return result.toString();
        }
    }
}

