/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.structure.PowerGrid;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.PowerGeneration;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class PowerGridTabPanel
extends TabPanel {
    private JLabel powerGeneratedLabel;
    private JLabel powerUsedLabel;
    private JLabel powerStorageCapacityLabel;
    private JLabel powerStoredLabel;
    private PowerTableModel powerTableModel;
    private PowerGrid powerGrid;
    private double powerGeneratedCache;
    private double powerUsedCache;
    private double powerStorageCapacityCache;
    private double powerStoredCache;
    private DecimalFormat formatter = new DecimalFormat("0.0");

    public PowerGridTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Power", null, "Power Grid", unit, desktop);
        Settlement settlement = (Settlement)unit;
        this.powerGrid = settlement.getPowerGrid();
        JPanel powerGridLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(powerGridLabelPanel);
        JLabel powerGridLabel = new JLabel("Power Grid", 0);
        powerGridLabelPanel.add(powerGridLabel);
        JPanel powerInfoPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        powerInfoPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(powerInfoPanel);
        this.powerGeneratedCache = this.powerGrid.getGeneratedPower();
        this.powerGeneratedLabel = new JLabel("Total Power Generated: " + this.formatter.format(this.powerGeneratedCache) + " kW.", 0);
        powerInfoPanel.add(this.powerGeneratedLabel);
        this.powerUsedCache = this.powerGrid.getRequiredPower();
        this.powerUsedLabel = new JLabel("Total Power Used: " + this.formatter.format(this.powerUsedCache) + " kW.", 0);
        powerInfoPanel.add(this.powerUsedLabel);
        this.powerStorageCapacityCache = this.powerGrid.getStoredPowerCapacity();
        this.powerStorageCapacityLabel = new JLabel("Power Storage Capacity: " + this.formatter.format(this.powerStorageCapacityCache) + " kW hr.", 0);
        powerInfoPanel.add(this.powerStorageCapacityLabel);
        this.powerStoredCache = this.powerGrid.getStoredPower();
        this.powerStoredLabel = new JLabel("Total Power Stored: " + this.formatter.format(this.powerStoredCache) + " kW hr.", 0);
        powerInfoPanel.add(this.powerStoredLabel);
        JScrollPane powerScrollPanel = new JScrollPane();
        powerScrollPanel.setPreferredSize(new Dimension(257, 230));
        this.topContentPanel.add(powerScrollPanel);
        JPanel outerTablePanel = new JPanel(new FlowLayout(1));
        outerTablePanel.setBorder(new MarsPanelBorder());
        powerScrollPanel.setViewportView(outerTablePanel);
        JPanel powerTablePanel = new JPanel(new BorderLayout(0, 0));
        outerTablePanel.add(powerTablePanel);
        this.powerTableModel = new PowerTableModel(settlement);
        JTable powerTable = new JTable(this.powerTableModel);
        powerTable.setCellSelectionEnabled(false);
        powerTable.setDefaultRenderer(Double.class, new NumberCellRenderer());
        powerTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        powerTable.getColumnModel().getColumn(1).setPreferredWidth(120);
        powerTable.getColumnModel().getColumn(2).setPreferredWidth(40);
        powerTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        powerTablePanel.add((Component)powerTable.getTableHeader(), "North");
        powerTablePanel.add((Component)powerTable, "Center");
    }

    @Override
    public void update() {
        if (this.powerGeneratedCache != this.powerGrid.getGeneratedPower()) {
            this.powerGeneratedCache = this.powerGrid.getGeneratedPower();
            this.powerGeneratedLabel.setText("Total Power Generated: " + this.formatter.format(this.powerGeneratedCache) + " kW.");
        }
        if (this.powerUsedCache != this.powerGrid.getRequiredPower()) {
            this.powerUsedCache = this.powerGrid.getRequiredPower();
            this.powerUsedLabel.setText("Total Power Used: " + this.formatter.format(this.powerUsedCache) + " kW.");
        }
        if (this.powerStorageCapacityCache != this.powerGrid.getStoredPowerCapacity()) {
            this.powerStorageCapacityCache = this.powerGrid.getStoredPowerCapacity();
            this.powerStorageCapacityLabel.setText("Power Storage Capacity: " + this.formatter.format(this.powerStorageCapacityCache) + " kW hr.");
        }
        if (this.powerStoredCache != this.powerGrid.getStoredPower()) {
            this.powerStoredCache = this.powerGrid.getStoredPower();
            this.powerStoredLabel.setText("Total Power Stored: " + this.formatter.format(this.powerStoredCache) + " kW hr.");
        }
        this.powerTableModel.update();
    }

    private static class PowerTableModel
    extends AbstractTableModel {
        Settlement settlement;
        List<Building> buildings;
        ImageIcon redDot;
        ImageIcon yellowDot;
        ImageIcon greenDot;

        private PowerTableModel(Settlement settlement) {
            this.settlement = settlement;
            this.buildings = settlement.getBuildingManager().getBuildings();
            this.redDot = ImageLoader.getIcon("RedDot");
            this.yellowDot = ImageLoader.getIcon("YellowDot");
            this.greenDot = ImageLoader.getIcon("GreenDot");
        }

        @Override
        public int getRowCount() {
            return this.buildings.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = ImageIcon.class;
            } else if (columnIndex == 1) {
                dataType = String.class;
            } else if (columnIndex == 2) {
                dataType = Double.class;
            } else if (columnIndex == 3) {
                dataType = Double.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "S";
            }
            if (columnIndex == 1) {
                return "Building";
            }
            if (columnIndex == 2) {
                return "Gen.";
            }
            if (columnIndex == 3) {
                return "Used";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Building building = this.buildings.get(row);
            String powerMode = building.getPowerMode();
            if (column == 0) {
                if (powerMode.equals("Full Power")) {
                    return this.greenDot;
                }
                if (powerMode.equals("Power Down")) {
                    return this.yellowDot;
                }
                if (powerMode.equals("No Power")) {
                    return this.redDot;
                }
                return null;
            }
            if (column == 1) {
                return this.buildings.get(row);
            }
            if (column == 2) {
                double generated = 0.0;
                if (building.hasFunction("Power Generation")) {
                    try {
                        PowerGeneration generator = (PowerGeneration)building.getFunction("Power Generation");
                        generated = generator.getGeneratedPower();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return generated;
            }
            if (column == 3) {
                double used = 0.0;
                if (powerMode.equals("Full Power")) {
                    used = building.getFullPowerRequired();
                } else if (powerMode.equals("Power Down")) {
                    used = building.getPoweredDownPowerRequired();
                }
                return used;
            }
            return "unknown";
        }

        public void update() {
            if (!this.buildings.equals(this.settlement.getBuildingManager().getBuildings())) {
                this.buildings = this.settlement.getBuildingManager().getBuildings();
            }
            this.fireTableDataChanged();
        }
    }
}

