/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.collections.CollectionUtils;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class InhabitableBuildingPanel
extends BuildingFunctionPanel
implements MouseListener {
    private LifeSupport inhabitable;
    private DefaultListModel inhabitantListModel;
    private JList inhabitantList;
    private Collection<Person> inhabitantCache;
    private JLabel numberLabel;

    public InhabitableBuildingPanel(LifeSupport inhabitable, MainDesktopPane desktop) {
        super(inhabitable.getBuilding(), desktop);
        this.inhabitable = inhabitable;
        this.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(3, 1, 0, 0));
        this.add((Component)labelPanel, "North");
        JLabel inhabitantLabel = new JLabel("Occupants", 0);
        labelPanel.add(inhabitantLabel);
        this.numberLabel = new JLabel("Number: " + inhabitable.getOccupantNumber(), 0);
        labelPanel.add(this.numberLabel);
        JLabel capacityLabel = new JLabel("Capacity: " + inhabitable.getOccupantCapacity(), 0);
        labelPanel.add(capacityLabel);
        JPanel inhabitantListPanel = new JPanel(new FlowLayout(1));
        this.add((Component)inhabitantListPanel, "Center");
        JScrollPane inhabitantScrollPanel = new JScrollPane();
        inhabitantScrollPanel.setPreferredSize(new Dimension(160, 60));
        inhabitantListPanel.add(inhabitantScrollPanel);
        this.inhabitantListModel = new DefaultListModel();
        this.inhabitantCache = new ArrayList<Person>(inhabitable.getOccupants());
        Iterator<Person> i = this.inhabitantCache.iterator();
        while (i.hasNext()) {
            this.inhabitantListModel.addElement(i.next());
        }
        this.inhabitantList = new JList(this.inhabitantListModel);
        this.inhabitantList.addMouseListener(this);
        inhabitantScrollPanel.setViewportView(this.inhabitantList);
    }

    @Override
    public void update() {
        if (!CollectionUtils.isEqualCollection(this.inhabitantCache, (Collection)this.inhabitable.getOccupants())) {
            this.inhabitantCache = new ArrayList<Person>(this.inhabitable.getOccupants());
            this.inhabitantListModel.clear();
            Iterator<Person> i = this.inhabitantCache.iterator();
            while (i.hasNext()) {
                this.inhabitantListModel.addElement(i.next());
            }
            this.numberLabel.setText("Number: " + this.inhabitantCache.size());
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() >= 2) {
            this.desktop.openUnitWindow((Unit)((Person)this.inhabitantList.getSelectedValue()), false);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

