/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class MaintenanceBuildingPanel
extends BuildingFunctionPanel {
    private Malfunctionable malfunctionable;
    private int wearConditionCache;
    private JLabel wearConditionLabel;
    private JLabel lastCompletedLabel;
    private BoundedRangeModel progressBarModel;
    private int lastCompletedTime;
    private JLabel partsLabel;

    public MaintenanceBuildingPanel(Malfunctionable malfunctionable, MainDesktopPane desktop) {
        super((Building)malfunctionable, desktop);
        this.malfunctionable = malfunctionable;
        MalfunctionManager manager = malfunctionable.getMalfunctionManager();
        this.setLayout(new GridLayout(5, 1, 0, 0));
        JLabel maintenanceLabel = new JLabel("Maintenance", 0);
        this.add(maintenanceLabel);
        int wearConditionCache = (int)Math.round(manager.getWearCondition());
        this.wearConditionLabel = new JLabel("Wear Condition: " + wearConditionCache + "%", 0);
        this.wearConditionLabel.setToolTipText("The wear & tear condition: 100% = new; 0% = worn out");
        this.add(this.wearConditionLabel);
        this.lastCompletedTime = (int)(manager.getTimeSinceLastMaintenance() / 1000.0);
        this.lastCompletedLabel = new JLabel("Last Completed: " + this.lastCompletedTime + " sols", 0);
        this.add(this.lastCompletedLabel);
        JPanel progressPanel = new JPanel(new FlowLayout(1, 0, 0));
        this.add(progressPanel);
        JProgressBar progressBar = new JProgressBar();
        this.progressBarModel = progressBar.getModel();
        progressBar.setStringPainted(true);
        progressPanel.add(progressBar);
        double completed = manager.getMaintenanceWorkTimeCompleted();
        double total = manager.getMaintenanceWorkTime();
        int percentDone = (int)(100.0 * (completed / total));
        this.progressBarModel.setValue(percentDone);
        this.partsLabel = new JLabel(this.getPartsString(), 0);
        this.partsLabel.setPreferredSize(new Dimension(-1, -1));
        this.add(this.partsLabel);
        this.setToolTipText(this.getToolTipString());
    }

    @Override
    public void update() {
        int lastComplete;
        MalfunctionManager manager = this.malfunctionable.getMalfunctionManager();
        int wearCondition = (int)Math.round(manager.getWearCondition());
        if (wearCondition != this.wearConditionCache) {
            this.wearConditionCache = wearCondition;
            this.wearConditionLabel.setText("Wear Condition: " + wearCondition + "%");
        }
        if ((lastComplete = (int)(manager.getTimeSinceLastMaintenance() / 1000.0)) != this.lastCompletedTime) {
            this.lastCompletedTime = lastComplete;
            this.lastCompletedLabel.setText("Last Completed: " + this.lastCompletedTime + " sols");
        }
        double completed = manager.getMaintenanceWorkTimeCompleted();
        double total = manager.getMaintenanceWorkTime();
        int percentDone = (int)(100.0 * (completed / total));
        this.progressBarModel.setValue(percentDone);
        this.partsLabel.setText(this.getPartsString());
        this.setToolTipText(this.getToolTipString());
    }

    private String getPartsString() {
        StringBuilder buf = new StringBuilder("Parts: ");
        Map parts = this.malfunctionable.getMalfunctionManager().getMaintenanceParts();
        if (parts.size() > 0) {
            Iterator i = parts.keySet().iterator();
            while (i.hasNext()) {
                Part part = (Part)i.next();
                int number = (Integer)parts.get(part);
                buf.append(number).append(" ").append(part.getName());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
        } else {
            buf.append("none");
        }
        return buf.toString();
    }

    private String getToolTipString() {
        MalfunctionManager manager = this.malfunctionable.getMalfunctionManager();
        StringBuilder result = new StringBuilder("<html>");
        int maintSols = (int)(manager.getTimeSinceLastMaintenance() / 1000.0);
        result.append("Last completed maintenance: ").append(maintSols).append(" sols<br>");
        result.append("Repair ").append(this.getPartsString().toLowerCase());
        result.append("</html>");
        return result.toString();
    }
}

