/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import org.mars_sim.msp.core.structure.building.function.PowerStorage;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class PowerStorageBuildingPanel
extends BuildingFunctionPanel {
    private PowerStorage storage;
    private JLabel capacityLabel;
    private double capacityCache;
    private JLabel storedLabel;
    private double storedCache;

    public PowerStorageBuildingPanel(PowerStorage storage, MainDesktopPane desktop) {
        super(storage.getBuilding(), desktop);
        this.storage = storage;
        this.setLayout(new GridLayout(2, 1, 0, 0));
        DecimalFormat formatter = new DecimalFormat("0.0");
        this.capacityCache = storage.getPowerStorageCapacity();
        this.capacityLabel = new JLabel("Power Capacity: " + formatter.format(this.capacityCache) + " kW hr", 0);
        this.add(this.capacityLabel);
        this.storedCache = storage.getPowerStored();
        this.storedLabel = new JLabel("Power Stored: " + formatter.format(this.storedCache) + " kW hr", 0);
        this.add(this.storedLabel);
    }

    @Override
    public void update() {
        double newStored;
        DecimalFormat formatter = new DecimalFormat("0.0");
        double newCapacity = this.storage.getPowerStorageCapacity();
        if (this.capacityCache != newCapacity) {
            this.capacityCache = newCapacity;
            this.capacityLabel.setText("Power Capacity: " + formatter.format(this.capacityCache) + " kW hr");
        }
        if (this.storedCache != (newStored = this.storage.getPowerStored())) {
            this.storedCache = newStored;
            this.storedLabel.setText("Power Stored: " + formatter.format(this.storedCache) + " kW hr");
        }
    }
}

