/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.structure.building.function.ResourceProcess;
import org.mars_sim.msp.core.structure.building.function.ResourceProcessing;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class ResourceProcessingBuildingPanel
extends BuildingFunctionPanel {
    private ResourceProcessing processor;
    private List<JLabel> processLabels;
    private ImageIcon greenDot;
    private ImageIcon redDot;

    public ResourceProcessingBuildingPanel(ResourceProcessing processor, MainDesktopPane desktop) {
        super(processor.getBuilding(), desktop);
        this.processor = processor;
        this.setLayout(new BorderLayout());
        JLabel resourceProcessesLabel = new JLabel("Resource Processes", 0);
        this.add((Component)resourceProcessesLabel, "North");
        List processes = processor.getProcesses();
        JPanel resourceProcessesListPanel = new JPanel(new GridLayout(processes.size(), 1, 0, 0));
        resourceProcessesListPanel.setBorder(new MarsPanelBorder());
        this.add((Component)resourceProcessesListPanel, "Center");
        this.greenDot = new ImageIcon("images/GreenDot.png", "Process is running.");
        this.redDot = new ImageIcon("images/RedDot.png", "Process is not running");
        this.processLabels = new ArrayList<JLabel>(processes.size());
        for (ResourceProcess process : processes) {
            JLabel processLabel = new JLabel(process.getProcessName(), 2);
            if (process.isProcessRunning()) {
                processLabel.setIcon(this.greenDot);
                processLabel.setToolTipText(process.getProcessName() + " process is running.");
            } else {
                processLabel.setIcon(this.redDot);
                processLabel.setToolTipText(process.getProcessName() + " process is not running.");
            }
            resourceProcessesListPanel.add(processLabel);
            this.processLabels.add(processLabel);
        }
    }

    @Override
    public void update() {
        List processes = this.processor.getProcesses();
        for (int x = 0; x < processes.size(); ++x) {
            ResourceProcess process = (ResourceProcess)processes.get(x);
            JLabel processLabel = this.processLabels.get(x);
            if (process.isProcessRunning()) {
                processLabel.setIcon(this.greenDot);
                processLabel.setToolTipText(process.getProcessName() + " process is running.");
                continue;
            }
            processLabel.setIcon(this.redDot);
            processLabel.setToolTipText(process.getProcessName() + " process is not running.");
        }
    }
}

