/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.collections.CollectionUtils;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.structure.building.function.VehicleMaintenance;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class VehicleMaintenanceBuildingPanel
extends BuildingFunctionPanel
implements MouseListener {
    private VehicleMaintenance garage;
    private JLabel vehicleNumberLabel;
    private int vehicleNumberCache = 0;
    private JList vehicleList;
    private DefaultListModel vehicleListModel;
    private Collection<Vehicle> vehicleCache;

    public VehicleMaintenanceBuildingPanel(VehicleMaintenance garage, MainDesktopPane desktop) {
        super(garage.getBuilding(), desktop);
        this.garage = garage;
        this.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(3, 1, 0, 0));
        this.add((Component)labelPanel, "North");
        JLabel vehicleMaintenanceLabel = new JLabel("Vehicle Loading/Maintenance", 0);
        labelPanel.add(vehicleMaintenanceLabel);
        this.vehicleNumberCache = garage.getCurrentVehicleNumber();
        this.vehicleNumberLabel = new JLabel("Vehicle Number: " + this.vehicleNumberCache, 0);
        labelPanel.add(this.vehicleNumberLabel);
        int vehicleCapacity = garage.getVehicleCapacity();
        JLabel vehicleCapacityLabel = new JLabel("Vehicle Capacity: " + vehicleCapacity, 0);
        labelPanel.add(vehicleCapacityLabel);
        JPanel vehicleListPanel = new JPanel(new FlowLayout(1));
        this.add((Component)vehicleListPanel, "Center");
        JScrollPane vehicleScrollPanel = new JScrollPane();
        vehicleScrollPanel.setPreferredSize(new Dimension(160, 60));
        vehicleListPanel.add(vehicleScrollPanel);
        this.vehicleListModel = new DefaultListModel();
        this.vehicleCache = new ArrayList<Vehicle>(garage.getVehicles());
        Iterator<Vehicle> i = this.vehicleCache.iterator();
        while (i.hasNext()) {
            this.vehicleListModel.addElement(i.next());
        }
        this.vehicleList = new JList(this.vehicleListModel);
        this.vehicleList.addMouseListener(this);
        vehicleScrollPanel.setViewportView(this.vehicleList);
    }

    @Override
    public void update() {
        if (!CollectionUtils.isEqualCollection(this.vehicleCache, (Collection)this.garage.getVehicles())) {
            this.vehicleCache = new ArrayList<Vehicle>(this.garage.getVehicles());
            this.vehicleListModel.clear();
            Iterator<Vehicle> i = this.vehicleCache.iterator();
            while (i.hasNext()) {
                this.vehicleListModel.addElement(i.next());
            }
            this.vehicleNumberCache = this.garage.getCurrentVehicleNumber();
            this.vehicleNumberLabel.setText("Vehicle Number: " + this.vehicleNumberCache);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Vehicle vehicle;
        if (event.getClickCount() >= 2 && (vehicle = (Vehicle)this.vehicleList.getSelectedValue()) != null) {
            this.desktop.openUnitWindow((Unit)vehicle, false);
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }
}

