/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.vehicle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class DirectionDisplayPanel
extends JPanel {
    private static final int CIRCLE_DIAMETER = 44;
    private static final int CIRCLE_RADIUS = 22;
    private Vehicle vehicle;

    public DirectionDisplayPanel(Vehicle vehicle) {
        this.vehicle = vehicle;
        this.setPreferredSize(new Dimension(52, 52));
        this.setBorder(new LineBorder(Color.green));
        this.setOpaque(true);
        this.setBackground(Color.black);
    }

    public void update() {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int height = this.getHeight();
        int width = this.getWidth();
        int centerX = width / 2;
        int centerY = height / 2;
        g.setColor(new Color(0, 62, 0));
        g.fillOval(centerX - 22, centerY - 22, 44, 44);
        g.setColor(Color.green);
        g.drawOval(centerX - 22, centerY - 22, 44, 44);
        g.drawRect(centerX, centerY, 1, 1);
        Font tempFont = new Font("SansSerif", 0, 9);
        g.setFont(tempFont);
        FontMetrics tempMetrics = this.getFontMetrics(tempFont);
        int fontHeight = tempMetrics.getAscent();
        int letterRadius = 15;
        int nWidth = tempMetrics.charWidth('N');
        g.drawString("N", centerX - nWidth / 2, centerY - letterRadius + fontHeight / 2);
        int sWidth = tempMetrics.charWidth('S');
        g.drawString("S", centerX - sWidth / 2, centerY + letterRadius + fontHeight / 2);
        int wWidth = tempMetrics.charWidth('W');
        g.drawString("W", centerX - letterRadius - wWidth / 2, centerY + fontHeight / 2);
        int eWidth = tempMetrics.charWidth('E');
        g.drawString("E", centerX + letterRadius - eWidth / 2, centerY + fontHeight / 2);
        String status = this.vehicle.getStatus();
        if (status.equals("Moving") || status.equals("Stuck - using winch") && this.vehicle.getSpeed() > 0.0) {
            Direction direction = this.vehicle.getDirection();
            double hyp = 22.0;
            int newX = (int)Math.round(hyp * direction.getSinDirection());
            int newY = -1 * (int)Math.round(hyp * direction.getCosDirection());
            g.drawLine(centerX, centerY, centerX + newX, centerY + newY);
        }
    }
}

