/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.vehicle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Lab;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class LaboratoryTabPanel
extends TabPanel {
    private JLabel researchersLabel;
    private int researchersCache;

    public LaboratoryTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Lab", null, "Laboratory", unit, desktop);
        Rover rover = (Rover)unit;
        Lab lab = rover.getLab();
        JPanel laboratoryPanel = new JPanel(new BorderLayout());
        this.topContentPanel.add(laboratoryPanel);
        JPanel namePanel = new JPanel();
        laboratoryPanel.add((Component)namePanel, "North");
        JLabel laboratoryLabel = new JLabel("Laboratory", 0);
        namePanel.add(laboratoryLabel);
        JPanel labelPanel = new JPanel(new GridLayout(3, 1));
        laboratoryPanel.add((Component)labelPanel, "Center");
        this.researchersCache = lab.getResearcherNum();
        this.researchersLabel = new JLabel("Number of Researchers: " + this.researchersCache, 0);
        labelPanel.add(this.researchersLabel);
        JLabel researcherCapacityLabel = new JLabel("Researcher Capacity: " + lab.getLaboratorySize(), 0);
        labelPanel.add(researcherCapacityLabel);
        JLabel specialitiesLabel = new JLabel("Specialities: ", 0);
        labelPanel.add(specialitiesLabel);
        String[] specialities = lab.getTechSpecialities();
        JPanel specialitiesListPanel = new JPanel(new GridLayout(specialities.length, 1, 0, 0));
        specialitiesListPanel.setBorder(new MarsPanelBorder());
        laboratoryPanel.add((Component)specialitiesListPanel, "South");
        for (String speciality : specialities) {
            JLabel specialityLabel = new JLabel(speciality, 0);
            specialitiesListPanel.add(specialityLabel);
        }
    }

    @Override
    public void update() {
        Rover rover = (Rover)this.unit;
        Lab lab = rover.getLab();
        if (this.researchersCache != lab.getResearcherNum()) {
            this.researchersCache = lab.getResearcherNum();
            this.researchersLabel.setText("Number of Researchers: " + this.researchersCache);
        }
    }
}

