/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.vehicle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.mars_sim.msp.core.vehicle.GroundVehicle;

public class TerrainDisplayPanel
extends JPanel {
    private GroundVehicle vehicle;

    public TerrainDisplayPanel(GroundVehicle vehicle) {
        this.vehicle = vehicle;
        this.setPreferredSize(new Dimension(102, 52));
        this.setBorder(new LineBorder(Color.green));
        this.setOpaque(true);
        this.setBackground(Color.black);
    }

    public void update() {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int height = this.getHeight();
        int width = this.getWidth();
        int centerX = width / 2;
        int centerY = height / 2;
        double terrainGrade = 0.0;
        if (this.vehicle.getStatus().equals("Moving")) {
            terrainGrade = this.vehicle.getTerrainGrade();
        }
        int opp = (int)Math.round(75.0 * Math.sin(terrainGrade));
        int[] xPoints = new int[]{0, 0, width - 1, width - 1, 0};
        int[] yPoints = new int[]{height - 1, centerY + opp, centerY - opp, height - 1, height - 1};
        Polygon terrainShape = new Polygon(xPoints, yPoints, 5);
        g.setColor(Color.green);
        g.fillPolygon(terrainShape);
        int arrowCenterY = centerY - height / 4;
        g.drawLine(centerX - 10, arrowCenterY, centerX + 10, arrowCenterY);
        g.drawLine(centerX + 10, arrowCenterY, centerX + 5, arrowCenterY + 5);
        g.drawLine(centerX + 10, arrowCenterY, centerX + 5, arrowCenterY - 5);
    }
}

