/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.Micropolis;
import micropolisj.engine.Sprite;
import micropolisj.engine.SpriteKind;

public class AirplaneSprite
extends Sprite {
    int destX;
    int destY;
    static int[] CDx = new int[]{0, 0, 6, 8, 6, 0, -6, -8, -6, 8, 8, 8};
    static int[] CDy = new int[]{0, -8, -6, 0, 6, 8, 6, 0, -6, 0, 0, 0};

    public AirplaneSprite(Micropolis engine, int xpos, int ypos) {
        super(engine, SpriteKind.AIR);
        this.x = xpos * 16 + 8;
        this.y = ypos * 16 + 8;
        this.width = 48;
        this.height = 48;
        this.offx = -24;
        this.offy = -24;
        this.destY = this.y;
        if (xpos > engine.getWidth() - 20) {
            this.destX = this.x - 200;
            this.frame = 7;
        } else {
            this.destX = this.x + 200;
            this.frame = 11;
        }
    }

    @Override
    public void moveImpl() {
        int z = this.frame;
        if (this.city.acycle % 5 == 0) {
            if (z > 8) {
                if (--z < 9) {
                    z = 3;
                }
                this.frame = z;
            } else {
                int d = AirplaneSprite.getDir(this.x, this.y, this.destX, this.destY);
                this.frame = z = AirplaneSprite.turnTo(z, d);
            }
        }
        if (AirplaneSprite.getDis(this.x, this.y, this.destX, this.destY) < 50) {
            this.destX = this.city.PRNG.nextInt(this.city.getWidth()) * 16 + 8;
            this.destY = this.city.PRNG.nextInt(this.city.getHeight()) * 16 + 8;
        }
        if (!this.city.noDisasters) {
            boolean explode = false;
            for (Sprite s : this.city.allSprites()) {
                if (s == this || s.kind != SpriteKind.AIR && s.kind != SpriteKind.COP || !this.checkSpriteCollision(s)) continue;
                s.explodeSprite();
                explode = true;
            }
            if (explode) {
                this.explodeSprite();
            }
        }
        this.x += CDx[z];
        this.y += CDy[z];
    }
}

