/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import micropolisj.engine.CityProblem;
import micropolisj.engine.Micropolis;

public class CityEval {
    private final Micropolis engine;
    private final Random PRNG;
    public int cityYes;
    public int cityNo;
    public int cityAssValue;
    public int cityScore;
    public int deltaCityScore;
    public int cityPop;
    public int deltaCityPop;
    public int cityClass;
    public CityProblem[] problemOrder = new CityProblem[0];
    public EnumMap<CityProblem, Integer> problemVotes = new EnumMap(CityProblem.class);
    public EnumMap<CityProblem, Integer> problemTable = new EnumMap(CityProblem.class);

    public CityEval(Micropolis engine) {
        this.engine = engine;
        this.PRNG = engine.PRNG;
        assert (this.PRNG != null);
    }

    void cityEvaluation() {
        if (this.engine.totalPop != 0) {
            this.calculateAssValue();
            this.doPopNum();
            this.doProblems();
            this.calculateScore();
            this.doVotes();
        } else {
            this.evalInit();
        }
        this.engine.fireEvaluationChanged();
    }

    void evalInit() {
        this.cityYes = 0;
        this.cityNo = 0;
        this.cityAssValue = 0;
        this.cityClass = 0;
        this.cityScore = 500;
        this.deltaCityScore = 0;
        this.problemVotes.clear();
        this.problemOrder = new CityProblem[0];
    }

    void calculateAssValue() {
        int z = 0;
        z += this.engine.roadTotal * 5;
        z += this.engine.railTotal * 10;
        z += this.engine.policeCount * 1000;
        z += this.engine.fireStationCount * 1000;
        z += this.engine.hospitalCount * 400;
        z += this.engine.stadiumCount * 3000;
        z += this.engine.seaportCount * 5000;
        z += this.engine.airportCount * 10000;
        z += this.engine.coalCount * 3000;
        this.cityAssValue = (z += this.engine.nuclearCount * 6000) * 1000;
    }

    void doPopNum() {
        int oldCityPop = this.cityPop;
        this.cityPop = this.engine.getCityPopulation();
        this.deltaCityPop = this.cityPop - oldCityPop;
        this.cityClass = this.cityPop > 500000 ? 5 : (this.cityPop > 100000 ? 4 : (this.cityPop > 50000 ? 3 : (this.cityPop > 10000 ? 2 : (this.cityPop > 2000 ? 1 : 0))));
    }

    void doProblems() {
        int c;
        this.problemTable.clear();
        this.problemTable.put(CityProblem.CRIME, this.engine.crimeAverage);
        this.problemTable.put(CityProblem.POLLUTION, this.engine.pollutionAverage);
        this.problemTable.put(CityProblem.HOUSING, (int)Math.round((double)this.engine.landValueAverage * 0.7));
        this.problemTable.put(CityProblem.TAXES, this.engine.cityTax * 10);
        this.problemTable.put(CityProblem.TRAFFIC, this.averageTrf());
        this.problemTable.put(CityProblem.UNEMPLOYMENT, this.getUnemployment());
        this.problemTable.put(CityProblem.FIRE, this.getFire());
        this.problemVotes = this.voteProblems(this.problemTable);
        CityProblem[] probOrder = CityProblem.values();
        Arrays.sort(probOrder, new Comparator<CityProblem>(){

            @Override
            public int compare(CityProblem a, CityProblem b) {
                return -CityEval.this.problemVotes.get((Object)a).compareTo(CityEval.this.problemVotes.get((Object)b));
            }
        });
        for (c = 0; c < probOrder.length && this.problemVotes.get((Object)probOrder[c]) != 0 && c < 4; ++c) {
        }
        this.problemOrder = new CityProblem[c];
        for (int i = 0; i < c; ++i) {
            this.problemOrder[i] = probOrder[i];
        }
    }

    EnumMap<CityProblem, Integer> voteProblems(Map<CityProblem, Integer> probTab) {
        CityProblem[] pp = CityProblem.values();
        int[] votes = new int[pp.length];
        int countVotes = 0;
        for (int i = 0; i < 600; ++i) {
            if (this.PRNG.nextInt(301) >= probTab.get((Object)pp[i % pp.length])) continue;
            int n = i % pp.length;
            votes[n] = votes[n] + 1;
            if (++countVotes >= 100) break;
        }
        EnumMap<CityProblem, Integer> rv = new EnumMap<CityProblem, Integer>(CityProblem.class);
        for (int i = 0; i < pp.length; ++i) {
            rv.put(pp[i], votes[i]);
        }
        return rv;
    }

    int averageTrf() {
        int count = 1;
        int total = 0;
        for (int y = 0; y < this.engine.getHeight(); ++y) {
            for (int x = 0; x < this.engine.getWidth(); ++x) {
                if (this.engine.getLandValue(x, y) == 0) continue;
                total += this.engine.getTrafficDensity(x, y);
                ++count;
            }
        }
        this.engine.trafficAverage = (int)Math.round((double)total / (double)count * 2.4);
        return this.engine.trafficAverage;
    }

    int getUnemployment() {
        int b = (this.engine.comPop + this.engine.indPop) * 8;
        if (b == 0) {
            return 0;
        }
        double r = (double)this.engine.resPop / (double)b;
        if ((b = (int)Math.floor((r - 1.0) * 255.0)) > 255) {
            b = 255;
        }
        return b;
    }

    int getFire() {
        int z = this.engine.firePop * 5;
        return Math.min(255, z);
    }

    static double clamp(double x, double min, double max) {
        return Math.max(min, Math.min(max, x));
    }

    void calculateScore() {
        int oldCityScore = this.cityScore;
        int x = 0;
        for (Integer z : this.problemTable.values()) {
            x += z.intValue();
        }
        x /= 3;
        x = Math.min(256, x);
        double z = CityEval.clamp((256 - x) * 4, 0.0, 1000.0);
        if (this.engine.resCap) {
            z = 0.85 * z;
        }
        if (this.engine.comCap) {
            z = 0.85 * z;
        }
        if (this.engine.indCap) {
            z = 0.85 * z;
        }
        if (this.engine.roadEffect < 32) {
            z -= (double)(32 - this.engine.roadEffect);
        }
        if (this.engine.policeEffect < 1000) {
            z *= 0.9 + (double)this.engine.policeEffect / 10000.1;
        }
        if (this.engine.fireEffect < 1000) {
            z *= 0.9 + (double)this.engine.fireEffect / 10000.1;
        }
        if (this.engine.resValve < -1000) {
            z *= 0.85;
        }
        if (this.engine.comValve < -1000) {
            z *= 0.85;
        }
        if (this.engine.indValve < -1000) {
            z *= 0.85;
        }
        double SM = 1.0;
        if (this.cityPop == 0 && this.deltaCityPop == 0) {
            SM = 1.0;
        } else if (this.deltaCityPop == this.cityPop) {
            SM = 1.0;
        } else if (this.deltaCityPop > 0) {
            SM = (double)this.deltaCityPop / (double)this.cityPop + 1.0;
        } else if (this.deltaCityPop < 0) {
            SM = 0.95 + (double)this.deltaCityPop / (double)(this.cityPop - this.deltaCityPop);
        }
        z *= SM;
        z -= (double)this.getFire();
        z -= (double)this.engine.cityTax;
        int TM = this.engine.unpoweredZoneCount + this.engine.poweredZoneCount;
        SM = TM != 0 ? (double)this.engine.poweredZoneCount / (double)TM : 1.0;
        z *= SM;
        z = CityEval.clamp(z, 0.0, 1000.0);
        this.cityScore = (int)Math.round(((double)this.cityScore + z) / 2.0);
        this.deltaCityScore = this.cityScore - oldCityScore;
    }

    void doVotes() {
        this.cityNo = 0;
        this.cityYes = 0;
        for (int i = 0; i < 100; ++i) {
            if (this.PRNG.nextInt(1001) < this.cityScore) {
                ++this.cityYes;
                continue;
            }
            ++this.cityNo;
        }
    }
}

