/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.BuildingTool;
import micropolisj.engine.Bulldozer;
import micropolisj.engine.Micropolis;
import micropolisj.engine.RoadLikeTool;
import micropolisj.engine.ToolResult;
import micropolisj.engine.ToolStroke;

public enum MicropolisTool {
    BULLDOZER(1, 1),
    WIRE(1, 5),
    ROADS(1, 10),
    RAIL(1, 20),
    RESIDENTIAL(3, 100),
    COMMERCIAL(3, 100),
    INDUSTRIAL(3, 100),
    FIRE(3, 500),
    POLICE(3, 500),
    STADIUM(4, 5000),
    PARK(1, 10),
    SEAPORT(4, 3000),
    POWERPLANT(4, 3000),
    NUCLEAR(4, 5000),
    AIRPORT(6, 10000),
    QUERY(1, 0);

    int size;
    int cost;

    private MicropolisTool(int size, int cost) {
        this.size = size;
        this.cost = cost;
    }

    public int getWidth() {
        return this.size;
    }

    public int getHeight() {
        return this.getWidth();
    }

    public ToolStroke beginStroke(Micropolis engine, int xpos, int ypos) {
        switch (this) {
            case BULLDOZER: {
                return new Bulldozer(engine, xpos, ypos);
            }
            case WIRE: 
            case ROADS: 
            case RAIL: {
                return new RoadLikeTool(engine, this, xpos, ypos);
            }
            case FIRE: 
            case POLICE: 
            case STADIUM: 
            case SEAPORT: 
            case POWERPLANT: 
            case NUCLEAR: 
            case AIRPORT: {
                return new BuildingTool(engine, this, xpos, ypos);
            }
        }
        return new ToolStroke(engine, this, xpos, ypos);
    }

    public ToolResult apply(Micropolis engine, int xpos, int ypos) {
        return this.beginStroke(engine, xpos, ypos).apply();
    }

    public int getToolCost() {
        return this.cost;
    }
}

