/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.CityLocation;
import micropolisj.engine.Micropolis;
import micropolisj.engine.Sound;
import micropolisj.engine.Sprite;
import micropolisj.engine.SpriteKind;

public class MonsterSprite
extends Sprite {
    int count;
    int soundCount;
    int destX;
    int destY;
    int origX;
    int origY;
    int step;
    boolean flag;
    static int[] Gx = new int[]{2, 2, -2, -2, 0};
    static int[] Gy = new int[]{-2, 2, 2, -2, 0};
    static int[] ND1 = new int[]{0, 1, 2, 3};
    static int[] ND2 = new int[]{1, 2, 3, 0};
    static int[] nn1 = new int[]{2, 5, 8, 11};
    static int[] nn2 = new int[]{11, 2, 5, 8};

    public MonsterSprite(Micropolis engine, int xpos, int ypos) {
        super(engine, SpriteKind.GOD);
        this.x = xpos * 16 + 8;
        this.y = ypos * 16 + 8;
        this.width = 48;
        this.height = 48;
        this.offx = -24;
        this.offy = -24;
        this.origX = this.x;
        this.origY = this.y;
        this.frame = xpos > this.city.getWidth() / 2 ? (ypos > this.city.getHeight() / 2 ? 10 : 7) : (ypos > this.city.getHeight() / 2 ? 1 : 4);
        this.count = 1000;
        CityLocation p = this.city.getLocationOfMaxPollution();
        this.destX = p.x * 16 + 8;
        this.destY = p.y * 16 + 8;
        this.flag = false;
        this.step = 1;
    }

    @Override
    public void moveImpl() {
        int c;
        if (this.frame == 0) {
            return;
        }
        if (this.soundCount > 0) {
            --this.soundCount;
        }
        int d = (this.frame - 1) / 3;
        int z = (this.frame - 1) % 3;
        if (d < 4) {
            assert (this.step == -1 || this.step == 1);
            if (z == 2) {
                this.step = -1;
            }
            if (z == 0) {
                this.step = 1;
            }
            z += this.step;
            if (MonsterSprite.getDis(this.x, this.y, this.destX, this.destY) < 60) {
                if (!this.flag) {
                    this.flag = true;
                    this.destX = this.origX;
                    this.destY = this.origY;
                } else {
                    this.frame = 0;
                    return;
                }
            }
            c = MonsterSprite.getDir(this.x, this.y, this.destX, this.destY);
            c = (c - 1) / 2;
            assert (c >= 0 && c < 4);
            if (c != d && this.city.PRNG.nextInt(11) == 0) {
                z = this.city.PRNG.nextInt(2) == 0 ? ND1[d] : ND2[d];
                d = 4;
                if (this.soundCount == 0) {
                    this.city.makeSound(this.x / 16, this.y / 16, Sound.MONSTER);
                    this.soundCount = 50 + this.city.PRNG.nextInt(101);
                }
            }
        } else {
            assert (this.frame >= 13 && this.frame <= 16);
            int z2 = (this.frame - 13) % 4;
            if (this.city.PRNG.nextInt(4) == 0) {
                int newFrame = this.city.PRNG.nextInt(2) == 0 ? nn1[z2] : nn2[z2];
                d = (newFrame - 1) / 3;
                z = (newFrame - 1) % 3;
                assert (d < 4);
            } else {
                d = 4;
            }
        }
        this.frame = d * 3 + z + 1;
        assert (this.frame >= 1 && this.frame <= 16);
        this.x += Gx[d];
        this.y += Gy[d];
        if (this.count > 0) {
            --this.count;
        }
        if ((c = this.getChar(this.x, this.y)) != -1) {
            if (c == 2 && this.count != 0) {
                // empty if block
            }
        } else {
            this.frame = 0;
        }
        for (Sprite s : this.city.allSprites()) {
            if (!this.checkSpriteCollision(s) || s.kind != SpriteKind.AIR && s.kind != SpriteKind.COP && s.kind != SpriteKind.SHI && s.kind != SpriteKind.TRA) continue;
            s.explodeSprite();
        }
        this.destroyTile(this.x / 16, this.y / 16);
    }
}

