/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import micropolisj.engine.CityLocation;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.Sound;
import micropolisj.gui.ColorParser;
import micropolisj.gui.MainWindow;

public class GraphsPane
extends JPanel
implements Micropolis.Listener {
    Micropolis engine;
    JToggleButton tenYearsBtn;
    JToggleButton onetwentyYearsBtn;
    GraphArea graphArea;
    EnumMap<GraphData, JToggleButton> dataBtns = new EnumMap(GraphData.class);
    static ResourceBundle strings = MainWindow.strings;
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 4;
    static final int TOP_MARGIN = 2;
    static final int BOTTOM_MARGIN = 2;
    static final int LEGEND_PADDING = 6;

    public GraphsPane(Micropolis engine) {
        super(new BorderLayout());
        assert (engine != null);
        this.engine = engine;
        engine.addListener(this);
        JButton dismissBtn = new JButton(strings.getString("dismiss_graph"));
        dismissBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphsPane.this.onDismissClicked();
            }
        });
        this.add((Component)dismissBtn, "South");
        JPanel b1 = new JPanel(new BorderLayout());
        this.add((Component)b1, "Center");
        JPanel toolsPane = new JPanel(new GridBagLayout());
        b1.add((Component)toolsPane, "West");
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        this.tenYearsBtn = new JToggleButton(strings.getString("ten_years"));
        this.tenYearsBtn.setMargin(new Insets(0, 0, 0, 0));
        this.tenYearsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphsPane.this.setTimePeriod(TimePeriod.TEN_YEARS);
            }
        });
        toolsPane.add((Component)this.tenYearsBtn, c);
        ++c.gridy;
        this.onetwentyYearsBtn = new JToggleButton(strings.getString("onetwenty_years"));
        this.onetwentyYearsBtn.setMargin(new Insets(0, 0, 0, 0));
        this.onetwentyYearsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphsPane.this.setTimePeriod(TimePeriod.ONETWENTY_YEARS);
            }
        });
        toolsPane.add((Component)this.onetwentyYearsBtn, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 11;
        c.weightx = 0.5;
        toolsPane.add((Component)this.makeDataBtn(GraphData.RESPOP), c);
        c.gridy = 3;
        toolsPane.add((Component)this.makeDataBtn(GraphData.COMPOP), c);
        c.gridy = 4;
        toolsPane.add((Component)this.makeDataBtn(GraphData.INDPOP), c);
        c.gridx = 1;
        c.gridy = 2;
        toolsPane.add((Component)this.makeDataBtn(GraphData.MONEY), c);
        c.gridy = 3;
        toolsPane.add((Component)this.makeDataBtn(GraphData.CRIME), c);
        c.gridy = 4;
        toolsPane.add((Component)this.makeDataBtn(GraphData.POLLUTION), c);
        this.graphArea = new GraphArea();
        b1.add((Component)this.graphArea, "Center");
        this.setTimePeriod(TimePeriod.TEN_YEARS);
        this.dataBtns.get((Object)GraphData.MONEY).setSelected(true);
        this.dataBtns.get((Object)GraphData.POLLUTION).setSelected(true);
    }

    public void setEngine(Micropolis newEngine) {
        if (this.engine != null) {
            this.engine.removeListener(this);
        }
        this.engine = newEngine;
        if (this.engine != null) {
            this.engine.addListener(this);
            this.graphArea.repaint();
        }
    }

    private void onDismissClicked() {
        this.setVisible(false);
    }

    @Override
    public void cityMessage(MicropolisMessage message, CityLocation loc) {
    }

    @Override
    public void citySound(Sound sound, CityLocation loc) {
    }

    @Override
    public void demandChanged() {
    }

    @Override
    public void evaluationChanged() {
    }

    @Override
    public void fundsChanged() {
    }

    @Override
    public void optionsChanged() {
    }

    @Override
    public void censusChanged() {
        this.graphArea.repaint();
    }

    private JToggleButton makeDataBtn(GraphData graph) {
        String icon1name = strings.getString("graph_button." + graph.name());
        String icon2name = strings.getString("graph_button." + graph.name() + ".selected");
        ImageIcon icon1 = new ImageIcon(this.getClass().getResource("/" + icon1name));
        ImageIcon icon2 = new ImageIcon(this.getClass().getResource("/" + icon2name));
        JToggleButton btn = new JToggleButton();
        btn.setIcon(icon1);
        btn.setSelectedIcon(icon2);
        btn.setBorder(null);
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setContentAreaFilled(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphsPane.this.graphArea.repaint();
            }
        });
        this.dataBtns.put(graph, btn);
        return btn;
    }

    int getHistoryMax() {
        int max = 0;
        for (GraphData g : GraphData.values()) {
            for (int pos = 0; pos < 240; ++pos) {
                max = Math.max(max, this.getHistoryValue(g, pos));
            }
        }
        return max;
    }

    int getHistoryValue(GraphData graph, int pos) {
        assert (pos >= 0 && pos < 240);
        switch (graph) {
            case RESPOP: {
                return this.engine.history.res[pos];
            }
            case COMPOP: {
                return this.engine.history.com[pos];
            }
            case INDPOP: {
                return this.engine.history.ind[pos];
            }
            case MONEY: {
                return this.engine.history.money[pos];
            }
            case CRIME: {
                return this.engine.history.crime[pos];
            }
            case POLLUTION: {
                return this.engine.history.pollution[pos];
            }
        }
        throw new Error("unexpected");
    }

    void setTimePeriod(TimePeriod period) {
        this.tenYearsBtn.setSelected(period == TimePeriod.TEN_YEARS);
        this.onetwentyYearsBtn.setSelected(period == TimePeriod.ONETWENTY_YEARS);
        this.graphArea.repaint();
    }

    class GraphArea
    extends JComponent {
        GraphArea() {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        @Override
        public void paintComponent(Graphics gr1) {
            Graphics2D gr = (Graphics2D)gr1;
            FontMetrics fm = gr.getFontMetrics();
            gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gr.setColor(Color.WHITE);
            gr.fill(gr.getClipBounds());
            int maxLabelWidth = 0;
            for (GraphData gd : GraphData.values()) {
                String labelStr = strings.getString("graph_label." + gd.name());
                int adv = fm.stringWidth(labelStr);
                if (adv <= maxLabelWidth) continue;
                maxLabelWidth = adv;
            }
            int leftEdge = this.getInsets().left + 4;
            int topEdge = this.getInsets().top + 2 + fm.getHeight() * 2;
            int bottomEdge = this.getHeight() - this.getInsets().bottom - this.getInsets().top - 2;
            int rightEdge = this.getWidth() - this.getInsets().right - this.getInsets().left - 4 - maxLabelWidth - 6;
            gr.setColor(Color.BLACK);
            gr.drawLine(leftEdge, topEdge, rightEdge, topEdge);
            gr.drawLine(leftEdge, bottomEdge, rightEdge, bottomEdge);
            boolean isOneTwenty = GraphsPane.this.onetwentyYearsBtn.isSelected();
            int unitPeriod = isOneTwenty ? 48 : 4;
            int hashPeriod = isOneTwenty ? 10 * unitPeriod : 12 * unitPeriod;
            int startTime = (GraphsPane.this.engine.history.cityTime / unitPeriod - 119) * unitPeriod;
            double x_interval = (double)(rightEdge - leftEdge) / 120.0;
            for (int i = 0; i < 120; ++i) {
                int t = startTime + i * unitPeriod;
                if (t % hashPeriod != 0) continue;
                int year = 1900 + t / 48;
                int numHashes = t / hashPeriod;
                int x = (int)Math.round((double)leftEdge + (double)i * x_interval);
                int y = this.getInsets().top + 2 + (numHashes % 2 == 0 ? fm.getHeight() : 0) + fm.getAscent();
                gr.drawString(Integer.toString(year), x, y);
                gr.drawLine(x, topEdge, x, bottomEdge);
            }
            int H = isOneTwenty ? 239 : 119;
            final HashMap<GraphData, Path2D.Double> paths = new HashMap<GraphData, Path2D.Double>();
            double scale = Math.max(256.0, (double)GraphsPane.this.getHistoryMax());
            for (GraphData gd : GraphData.values()) {
                if (!GraphsPane.this.dataBtns.get((Object)gd).isSelected()) continue;
                Path2D.Double path = new Path2D.Double();
                for (int i = 0; i < 120; ++i) {
                    double xp = (double)leftEdge + (double)i * x_interval;
                    double yp = (double)bottomEdge - (double)(GraphsPane.this.getHistoryValue(gd, H - i) * (bottomEdge - topEdge)) / scale;
                    if (i == 0) {
                        path.moveTo(xp, yp);
                        continue;
                    }
                    path.lineTo(xp, yp);
                }
                paths.put(gd, path);
            }
            GraphData[] myGraphs = paths.keySet().toArray(new GraphData[0]);
            Arrays.sort(myGraphs, new Comparator<GraphData>(){

                @Override
                public int compare(GraphData a, GraphData b) {
                    double y0 = ((Path2D.Double)paths.get((Object)a)).getCurrentPoint().getY();
                    double y1 = ((Path2D.Double)paths.get((Object)b)).getCurrentPoint().getY();
                    return -Double.compare(y0, y1);
                }
            });
            int lbottom = bottomEdge;
            for (GraphData gd : myGraphs) {
                String labelStr = strings.getString("graph_label." + gd.name());
                String colStr = strings.getString("graph_color." + gd.name());
                Color col = ColorParser.parseColor(colStr);
                Path2D.Double path = (Path2D.Double)paths.get((Object)gd);
                gr.setColor(col);
                gr.setStroke(new BasicStroke(2.0f));
                gr.draw(path);
                int x = rightEdge + 6;
                int y = (int)Math.round(path.getCurrentPoint().getY() + (double)(fm.getAscent() / 2));
                y = Math.min(lbottom, y);
                lbottom = y - fm.getAscent();
                gr.setColor(col);
                gr.drawString(labelStr, x - 1, y);
                gr.drawString(labelStr, x, y - 1);
                gr.setColor(Color.BLACK);
                gr.drawString(labelStr, x, y);
            }
        }
    }

    static enum GraphData {
        RESPOP,
        COMPOP,
        INDPOP,
        MONEY,
        CRIME,
        POLLUTION;

    }

    static enum TimePeriod {
        TEN_YEARS,
        ONETWENTY_YEARS;

    }
}

